/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class SystemTimeZoneLoggingIT {
    @Inject
    private TestDirectory testDirectory;

    SystemTimeZoneLoggingIT() {
    }

    @Test
    void databaseLogsUseSystemTimeZoneIfConfigure() throws IOException {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            this.checkStartLogLine(5, "+0500");
            this.checkStartLogLine(-7, "-0700");
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    private void checkStartLogLine(int hoursShift, String timeZoneSuffix) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.ofHours(hoursShift)));
        File storeDir = this.testDirectory.homeDir(String.valueOf(hoursShift));
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.db_timezone, (Object)LogTimeZone.SYSTEM).build();
        managementService.database("neo4j");
        managementService.shutdown();
        Path databasePath = storeDir.toPath();
        Path debugLog = Paths.get("logs", "debug.log");
        String debugLogLine = SystemTimeZoneLoggingIT.getLogLine(databasePath, debugLog);
        Assertions.assertTrue((boolean)debugLogLine.contains(timeZoneSuffix), (String)debugLogLine);
    }

    private static String getLogLine(Path databasePath, Path logFilePath) throws IOException {
        return Files.readAllLines(databasePath.resolve(logFilePath)).get(0);
    }
}

