/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class CompositeCountsTest {
    @Inject
    private GraphDatabaseAPI db;

    CompositeCountsTest() {
    }

    @Test
    void shouldReportNumberOfRelationshipsFromNodesWithGivenLabel() {
        try (Transaction tx = this.db.beginTx();){
            Node foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node fooBar = tx.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"ALPHA"));
            foo.createRelationshipTo(fooBar, RelationshipType.withName((String)"BETA"));
            fooBar.createRelationshipTo(tx.createNode(new Label[]{Label.label((String)"Bar")}), RelationshipType.withName((String)"BETA"));
            fooBar.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"GAMMA"));
            bar.createRelationshipTo(tx.createNode(new Label[]{Label.label((String)"Foo")}), RelationshipType.withName((String)"GAMMA"));
            tx.commit();
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"ALPHA"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BETA"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"GAMMA"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"ALPHA"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"BETA"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"GAMMA"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"ALPHA"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"BETA"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"GAMMA"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"ALPHA"), Label.label((String)"Bar")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"BETA"), Label.label((String)"Bar")).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"GAMMA"), Label.label((String)"Bar")).shouldBe(0L);
    }

    @Test
    void shouldMaintainCountsOnRelationshipCreate() {
        Node bar;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(foo.getId()).createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    void shouldMaintainCountsOnRelationshipDelete() {
        Relationship relationship;
        try (Transaction tx = this.db.beginTx();){
            relationship = tx.createNode(new Label[]{Label.label((String)"Foo")}).createRelationshipTo(tx.createNode(new Label[]{Label.label((String)"Bar")}), RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getRelationshipById(relationship.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(0L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    void shouldMaintainCountsOnLabelAdd() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode();
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(foo.getId()).addLabel(Label.label((String)"Foo"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    void shouldMaintainCountsOnLabelRemove() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(foo.getId()).removeLabel(Label.label((String)"Foo"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    void shouldMaintainCountsOnLabelAddAndRelationshipCreate() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            foo = tx.getNodeById(foo.getId());
            foo.addLabel(Label.label((String)"Bar"));
            foo.createRelationshipTo(tx.createNode(new Label[]{Label.label((String)"Foo")}), RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
    }

    @Test
    void shouldMaintainCountsOnLabelRemoveAndRelationshipDelete() {
        Relationship rel;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            rel = bar.createRelationshipTo(foo, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(foo.getId()).removeLabel(Label.label((String)"Bar"));
            tx.getRelationshipById(rel.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    void shouldMaintainCountsOnLabelAddAndRelationshipDelete() {
        Relationship rel;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            rel = bar.createRelationshipTo(foo, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(foo.getId()).addLabel(Label.label((String)"Bar"));
            tx.getRelationshipById(rel.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(1L);
    }

    @Test
    void shouldMaintainCountsOnLabelRemoveAndRelationshipCreate() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            foo = tx.getNodeById(foo.getId());
            foo.removeLabel(Label.label((String)"Bar"));
            foo.createRelationshipTo(tx.createNode(new Label[]{Label.label((String)"Foo")}), RelationshipType.withName((String)"KNOWS"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(2L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(1L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(1L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
    }

    @Test
    void shouldNotUpdateCountsIfCreatedRelationshipIsDeletedInSameTransaction() {
        Node bar;
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(foo.getId()).createRelationshipTo(bar, RelationshipType.withName((String)"KNOWS")).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(Label.label((String)"Bar"), RelationshipType.withName((String)"KNOWS"), null).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Foo")).shouldBe(0L);
        this.numberOfRelationshipsMatching(null, RelationshipType.withName((String)"KNOWS"), Label.label((String)"Bar")).shouldBe(0L);
    }

    private MatchingRelationships numberOfRelationshipsMatching(Label lhs, RelationshipType type, Label rhs) {
        try (Transaction tx = this.db.beginTx();){
            long nodeCount = this.countsForRelationship(tx, lhs, type, rhs);
            tx.commit();
            MatchingRelationships matchingRelationships = new MatchingRelationships(String.format("(%s)-%s->(%s)", lhs == null ? "" : ":" + lhs.name(), type == null ? "" : "[:" + type.name() + "]", rhs == null ? "" : ":" + rhs.name()), nodeCount);
            return matchingRelationships;
        }
    }

    private long countsForRelationship(Transaction tx, Label start, RelationshipType type, Label end) {
        int endId;
        int typeId;
        int startId;
        KernelTransaction transaction = ((InternalTransaction)tx).kernelTransaction();
        TokenRead tokenRead = transaction.tokenRead();
        if (start == null) {
            startId = -1;
        } else {
            startId = tokenRead.nodeLabel(start.name());
            if (-1 == startId) {
                return 0L;
            }
        }
        if (type == null) {
            typeId = -1;
        } else {
            typeId = tokenRead.relationshipType(type.name());
            if (-1 == typeId) {
                return 0L;
            }
        }
        if (end == null) {
            endId = -1;
        } else {
            endId = tokenRead.nodeLabel(end.name());
            if (-1 == endId) {
                return 0L;
            }
        }
        return transaction.dataRead().countsForRelationship(startId, typeId, endId);
    }

    private static class MatchingRelationships {
        private final String message;
        private final long count;

        MatchingRelationships(String message, long count) {
            this.message = message;
            this.count = count;
        }

        void shouldBe(long expected) {
            Assertions.assertEquals((long)expected, (long)this.count, (String)this.message);
        }
    }
}

