/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class LabelCountsTest {
    @Inject
    private GraphDatabaseAPI db;

    LabelCountsTest() {
    }

    @Test
    void shouldGetNumberOfNodesWithLabel() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"Foo")});
            tx.createNode(new Label[]{Label.label((String)"Bar")});
            tx.createNode(new Label[]{Label.label((String)"Bar")});
            tx.commit();
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assertions.assertEquals((long)1L, (long)fooCount);
        Assertions.assertEquals((long)2L, (long)barCount);
    }

    @Test
    void shouldAccountForDeletedNodes() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{Label.label((String)"Foo")});
            tx.createNode(new Label[]{Label.label((String)"Foo")});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        Assertions.assertEquals((long)1L, (long)fooCount);
    }

    @Test
    void shouldAccountForDeletedNodesWithMultipleLabels() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            tx.createNode(new Label[]{Label.label((String)"Foo")});
            tx.createNode(new Label[]{Label.label((String)"Bar")});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assertions.assertEquals((long)1L, (long)fooCount);
        Assertions.assertEquals((long)1L, (long)barCount);
    }

    @Test
    void shouldAccountForAddedLabels() {
        Node n3;
        Node n2;
        Node n1;
        try (Transaction tx = this.db.beginTx();){
            n1 = tx.createNode(new Label[]{Label.label((String)"Foo")});
            n2 = tx.createNode();
            n3 = tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(n1.getId()).addLabel(Label.label((String)"Bar"));
            tx.getNodeById(n2.getId()).addLabel(Label.label((String)"Bar"));
            tx.getNodeById(n3.getId()).addLabel(Label.label((String)"Foo"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assertions.assertEquals((long)2L, (long)fooCount);
        Assertions.assertEquals((long)2L, (long)barCount);
    }

    @Test
    void shouldAccountForRemovedLabels() {
        Node n3;
        Node n2;
        Node n1;
        try (Transaction tx = this.db.beginTx();){
            n1 = tx.createNode(new Label[]{Label.label((String)"Foo"), Label.label((String)"Bar")});
            n2 = tx.createNode(new Label[]{Label.label((String)"Bar")});
            n3 = tx.createNode(new Label[]{Label.label((String)"Foo")});
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(n1.getId()).removeLabel(Label.label((String)"Bar"));
            tx.getNodeById(n2.getId()).removeLabel(Label.label((String)"Bar"));
            tx.getNodeById(n3.getId()).removeLabel(Label.label((String)"Foo"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        long fooCount = this.numberOfNodesWith(Label.label((String)"Foo"));
        long barCount = this.numberOfNodesWith(Label.label((String)"Bar"));
        Assertions.assertEquals((long)1L, (long)fooCount);
        Assertions.assertEquals((long)0L, (long)barCount);
    }

    private long numberOfNodesWith(Label label) {
        try (Transaction tx = this.db.beginTx();){
            long nodeCount = this.countsForNode(tx, label);
            tx.commit();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForNode(Transaction tx, Label label) {
        int labelId;
        KernelTransaction transaction = ((InternalTransaction)tx).kernelTransaction();
        Read read = transaction.dataRead();
        if (label == null) {
            labelId = -1;
        } else {
            labelId = transaction.tokenRead().nodeLabel(label.name());
            if (-1 == labelId) {
                return 0L;
            }
        }
        return read.countsForNode(labelId);
    }
}

