/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

@ResourceLock(value="sharedContext")
public abstract class AbstractNeo4jTestCase {
    private static DatabaseManagementService managementService;
    private static GraphDatabaseAPI graphDb;

    @BeforeAll
    static void beforeAll() {
        AbstractNeo4jTestCase.startDb();
    }

    @AfterAll
    static void afterAll() {
        AbstractNeo4jTestCase.stopDb();
    }

    protected static void startDb() {
        managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        graphDb = (GraphDatabaseAPI)managementService.database("neo4j");
    }

    protected static void stopDb() {
        managementService.shutdown();
    }

    public GraphDatabaseService getGraphDb() {
        return graphDb;
    }

    public DatabaseManagementService getManagementService() {
        return managementService;
    }

    protected GraphDatabaseAPI getGraphDbAPI() {
        return graphDb;
    }

    protected Node createNode() {
        Node node;
        try (Transaction transaction = graphDb.beginTx();){
            node = transaction.createNode();
            transaction.commit();
        }
        return node;
    }

    protected IdGenerator getIdGenerator(IdType idType) {
        return ((IdGeneratorFactory)graphDb.getDependencyResolver().resolveDependency(IdGeneratorFactory.class)).get(idType);
    }

    protected long propertyRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore());
    }

    private static <RECORD extends AbstractBaseRecord> int numberOfRecordsInUse(RecordStore<RECORD> store) {
        int inUse = 0;
        for (long id = (long)store.getNumberOfReservedLowIds(); id < store.getHighId(); ++id) {
            AbstractBaseRecord record = store.getRecord(id, store.newRecord(), RecordLoad.FORCE);
            if (!record.inUse()) continue;
            ++inUse;
        }
        return inUse;
    }

    protected long dynamicStringRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getStringStore());
    }

    protected long dynamicArrayRecordsInUse() {
        return AbstractNeo4jTestCase.numberOfRecordsInUse(this.propertyStore().getArrayStore());
    }

    protected PropertyStore propertyStore() {
        return ((RecordStorageEngine)graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getPropertyStore();
    }
}

