/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class FailedIndexRestartIT {
    private static final String ROBOT = "Robot";
    private static final String GENDER = "gender";
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void failedIndexUpdatesAfterRestart() {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder().setDatabaseRootDirectory(this.databaseLayout.databaseDirectory());
        this.managementService = builder.build();
        GraphDatabaseService database = this.managementService.database("neo4j");
        Label robot = Label.label((String)ROBOT);
        String megaProperty = RandomStringUtils.randomAlphanumeric((int)((int)ByteUnit.mebiBytes((long)16L)));
        this.createNodeWithProperty(database, robot, megaProperty);
        try (Transaction tx = database.beginTx();){
            tx.schema().indexFor(robot).on(GENDER).create();
            tx.commit();
        }
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.awaitIndexesOnline(this.managementService.database("neo4j")));
        MatcherAssert.assertThat((Object)ExceptionUtils.getRootCause((Throwable)e).getMessage(), (Matcher)Matchers.containsString((String)"Max supported key size is"));
        this.createNodeWithProperty(database, robot, megaProperty);
        try (Transaction transaction = database.beginTx();){
            Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)transaction.findNodes(robot)));
        }
        this.managementService.shutdown();
        this.managementService = builder.build();
        database = this.managementService.database("neo4j");
        this.createNodeWithProperty(database, robot, megaProperty);
        transaction = database.beginTx();
        try {
            Assertions.assertEquals((long)3L, (long)Iterators.count((Iterator)transaction.findNodes(robot)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void createNodeWithProperty(GraphDatabaseService db, Label label, String propertyValue) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(GENDER, (Object)propertyValue);
            tx.commit();
        }
    }

    private void awaitIndexesOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(3L, TimeUnit.MINUTES);
        }
    }
}

