/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

class IndexIT
extends KernelIntegrationTest {
    private static final String LABEL = "Label";
    private static final String LABEL2 = "Label2";
    private static final String REL_TYPE = "RelType";
    private static final String REL_TYPE2 = "RelType2";
    private static final String PROPERTY_KEY = "prop";
    private static final String PROPERTY_KEY2 = "prop2";
    private int labelId;
    private int labelId2;
    private int relType;
    private int relType2;
    private int propertyKeyId;
    private int propertyKeyId2;
    private LabelSchemaDescriptor schema;
    private LabelSchemaDescriptor schema2;
    private ExecutorService executorService;

    IndexIT() {
    }

    @BeforeEach
    void createLabelAndProperty() throws Exception {
        TokenWrite tokenWrites = this.tokenWriteInNewTransaction();
        this.labelId = tokenWrites.labelGetOrCreateForName(LABEL);
        this.labelId2 = tokenWrites.labelGetOrCreateForName(LABEL2);
        this.relType = tokenWrites.relationshipTypeGetOrCreateForName(REL_TYPE);
        this.relType2 = tokenWrites.relationshipTypeGetOrCreateForName(REL_TYPE2);
        this.propertyKeyId = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY);
        this.propertyKeyId2 = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY2);
        this.schema = SchemaDescriptor.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId});
        this.schema2 = SchemaDescriptor.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId2});
        this.commit();
        this.executorService = Executors.newCachedThreadPool();
    }

    @AfterEach
    void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    void createIndexForAnotherLabelWhileHoldingSharedLockOnOtherLabel() throws KernelException, ExecutionException, InterruptedException {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int label2 = tokenWrite.labelGetOrCreateForName(LABEL2);
        this.commit();
        Write write = this.dataWriteInNewTransaction();
        long nodeId = write.nodeCreate();
        write.nodeAddLabel(nodeId, label2);
        try (Resource ignored = this.captureTransaction();){
            this.executorService.submit(() -> {
                try {
                    this.schemaWriteInNewTransaction().indexCreate((SchemaDescriptor)this.schema, null);
                    this.commit();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).get();
        }
    }

    @Test
    @Timeout(value=10L)
    void createIndexesForDifferentLabelsConcurrently() throws Throwable {
        TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
        int label2 = tokenWrite.labelGetOrCreateForName(LABEL2);
        this.commit();
        LabelSchemaDescriptor anotherLabelDescriptor = SchemaDescriptor.forLabel((int)label2, (int[])new int[]{this.propertyKeyId});
        this.schemaWriteInNewTransaction().indexCreate((SchemaDescriptor)anotherLabelDescriptor, "my index");
        Future<?> indexFuture = this.executorService.submit(IndexIT.createIndex(this.db, Label.label((String)LABEL), PROPERTY_KEY));
        indexFuture.get();
        this.commit();
    }

    @Test
    void addIndexRuleInATransaction() throws Exception {
        SchemaWrite schemaWriteOperations = this.schemaWriteInNewTransaction();
        IndexDescriptor expectedRule = schemaWriteOperations.indexCreate((SchemaDescriptor)this.schema, "my index");
        this.commit();
        SchemaRead schemaRead = this.newTransaction().schemaRead();
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{expectedRule}), (Object)Iterators.asSet((Iterator)schemaRead.indexesGetForLabel(this.labelId)));
        Assertions.assertEquals((Object)expectedRule, (Object)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)this.schema)));
        this.commit();
    }

    @Test
    void committedAndTransactionalIndexRulesShouldBeMerged() throws Exception {
        SchemaWrite schemaWriteOperations = this.schemaWriteInNewTransaction();
        IndexDescriptor existingRule = schemaWriteOperations.indexCreate((SchemaDescriptor)this.schema, "my index");
        this.commit();
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId2});
        IndexDescriptor addedRule = transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, "my other index");
        Set indexRulesInTx = Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId));
        this.commit();
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{existingRule, addedRule}), (Object)indexRulesInTx);
    }

    @Test
    void rollBackIndexRuleShouldNotBeCommitted() throws Exception {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.indexCreate((SchemaDescriptor)this.schema, "my index");
        this.rollback();
        KernelTransaction transaction = this.newTransaction();
        Assertions.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    void shouldBeAbleToRemoveAConstraintIndexWithoutOwner() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, this.indexingService, (LogProvider)logProvider);
        IndexProviderDescriptor provider = GenericNativeIndexProvider.DESCRIPTOR;
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(provider);
        IndexDescriptor constraintIndex = creator.createConstraintIndex(prototype);
        KernelTransaction transaction = this.newTransaction();
        Assertions.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().constraintsGetForLabel(this.labelId)));
        this.commit();
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        schemaWrite.indexDrop(constraintIndex);
        this.commit();
        transaction = this.newTransaction();
        Assertions.assertEquals(Collections.emptySet(), (Object)Iterators.asSet((Iterator)transaction.schemaRead().indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        IndexDescriptor index = statement.indexCreate((SchemaDescriptor)this.schema, "my index");
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        SchemaKernelException e = (SchemaKernelException)Assertions.assertThrows(SchemaKernelException.class, () -> {
            SchemaWrite statement = this.schemaWriteInNewTransaction();
            statement.indexDrop(index);
        });
        Assertions.assertEquals((Object)"Unable to drop index: Index does not exist: Index( 1, 'my index', GENERAL BTREE, :Label(prop), native-btree-1.0 )", (Object)e.getUserMessage(TokenNameLookup.idTokenNameLookup));
        this.commit();
    }

    @Test
    void shouldDisallowDroppingIndexBySchemaThatDoesNotExist() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        IndexDescriptor index = statement.indexCreate((SchemaDescriptor)this.schema, "my index");
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.indexDrop(index.schema());
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)Assertions.assertThrows(SchemaKernelException.class, () -> statement.indexDrop(index.schema()));
        Assertions.assertEquals((Object)"Unable to drop index on :Label(prop). There is no such index.", (Object)e.getMessage());
        this.commit();
    }

    @Test
    void shouldDisallowDroppingIndexByNameThatDoesNotExist() throws KernelException {
        String indexName = "My fancy index";
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        IndexDescriptor index = statement.indexCreate((SchemaDescriptor)this.schema, indexName);
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)Assertions.assertThrows(SchemaKernelException.class, () -> statement.indexDrop(indexName));
        Assertions.assertEquals((Object)e.getMessage(), (Object)"Unable to drop index called `My fancy index`. There is no such index.");
        this.rollback();
    }

    @Test
    void shouldDisallowDroppingConstraintByNameThatDoesNotExist() throws KernelException {
        String constraintName = "my constraint";
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        ConstraintDescriptor constraint = statement.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        statement.constraintDrop(constraint);
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)Assertions.assertThrows(SchemaKernelException.class, () -> statement.constraintDrop(constraintName));
        Assertions.assertEquals((Object)"Unable to drop constraint `my constraint`: No such constraint my constraint.", (Object)e.getMessage());
        this.rollback();
    }

    @Test
    void shouldDisallowDroppingIndexByNameThatBelongsToConstraint() throws KernelException {
        String constraintName = "my constraint";
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        statement.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
        this.commit();
        statement = this.schemaWriteInNewTransaction();
        SchemaKernelException e = (SchemaKernelException)Assertions.assertThrows(SchemaKernelException.class, () -> statement.indexDrop(constraintName));
        Assertions.assertEquals((Object)"Unable to drop index called `my constraint`. There is no such index.", (Object)e.getMessage());
        this.rollback();
    }

    @Test
    void shouldFailToCreateIndexWhereAConstraintAlreadyExists() throws Exception {
        SchemaWrite statement = this.schemaWriteInNewTransaction();
        statement.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
        this.commit();
        SchemaKernelException e = (SchemaKernelException)Assertions.assertThrows(SchemaKernelException.class, () -> {
            SchemaWrite statement = this.schemaWriteInNewTransaction();
            statement.indexCreate((SchemaDescriptor)this.schema, "my index");
            this.commit();
        });
        Assertions.assertEquals((Object)"There is a uniqueness constraint on :Label(prop), so an index is already created that matches this.", (Object)e.getMessage());
        this.commit();
    }

    @Test
    void shouldListConstraintIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("Label1");
        int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("property1");
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)labelId, (int[])new int[]{propertyKeyId});
        transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertEquals((int)1, (int)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assertions.assertEquals((Object)"Label1", (Object)((Label)Iterables.single((Iterable)index.getLabels())).name());
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"property1"}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
            Assertions.assertTrue((boolean)index.isConstraintIndex(), (String)"index should be a constraint index");
            IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).drop());
            Assertions.assertEquals((Object)"Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", (Object)e.getMessage());
        }
    }

    @Test
    void shouldListMultiTokenIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{this.labelId, this.labelId2}, (int[])new int[]{this.propertyKeyId});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT);
        transaction.schemaWrite().indexCreate(prototype);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertEquals((int)1, (int)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getRelationshipTypes());
            MatcherAssert.assertThat((Object)index.getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)LABEL), Label.label((String)LABEL2)}));
            Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            Assertions.assertTrue((boolean)index.isMultiTokenIndex(), (String)"should be a multi-token index");
            Assertions.assertFalse((boolean)index.isCompositeIndex(), (String)"should not be a composite index");
            Assertions.assertTrue((boolean)index.isNodeIndex(), (String)"should be a node index");
            Assertions.assertFalse((boolean)index.isRelationshipIndex(), (String)"should not be a relationship index");
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{PROPERTY_KEY}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
        }
    }

    @Test
    void shouldListCompositeIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId, this.propertyKeyId2});
        transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, "my index");
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertEquals((int)1, (int)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assertions.assertEquals((Object)LABEL, (Object)((Label)Iterables.single((Iterable)index.getLabels())).name());
            MatcherAssert.assertThat((Object)index.getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)LABEL)}));
            Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getRelationshipTypes());
            Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            Assertions.assertFalse((boolean)index.isMultiTokenIndex(), (String)"should not be a multi-token index");
            Assertions.assertTrue((boolean)index.isCompositeIndex(), (String)"should be a composite index");
            Assertions.assertTrue((boolean)index.isNodeIndex(), (String)"should be a node index");
            Assertions.assertFalse((boolean)index.isRelationshipIndex(), (String)"should not be a relationship index");
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{PROPERTY_KEY, PROPERTY_KEY2}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
        }
    }

    @Test
    void shouldListRelationshipIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        RelationTypeSchemaDescriptor schema = SchemaDescriptor.forRelType((int)this.relType, (int[])new int[]{this.propertyKeyId});
        transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, "my index");
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertEquals((int)1, (int)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getLabels());
            Assertions.assertEquals(Collections.singletonList(RelationshipType.withName((String)REL_TYPE)), (Object)index.getRelationshipTypes());
            Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            Assertions.assertFalse((boolean)index.isMultiTokenIndex(), (String)"should not be a multi-token index");
            Assertions.assertFalse((boolean)index.isCompositeIndex(), (String)"should not be a composite index");
            Assertions.assertFalse((boolean)index.isNodeIndex(), (String)"should not be a node index");
            Assertions.assertTrue((boolean)index.isRelationshipIndex(), (String)"should be a relationship index");
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{PROPERTY_KEY}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
        }
    }

    @Test
    void shouldListCompositeMultiTokenRelationshipIndexesInTheCoreAPI() throws Exception {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{this.relType, this.relType2}, (int[])new int[]{this.propertyKeyId, this.propertyKeyId2});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withIndexType(IndexType.FULLTEXT).withName("index name");
        transaction.schemaWrite().indexCreate(prototype);
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)tx.schema().getIndexes());
            Assertions.assertEquals((int)1, (int)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assertions.assertThrows(IllegalStateException.class, () -> ((IndexDefinition)index).getLabels());
            MatcherAssert.assertThat((Object)index.getRelationshipTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RelationshipType[]{RelationshipType.withName((String)REL_TYPE), RelationshipType.withName((String)REL_TYPE2)}));
            Assertions.assertFalse((boolean)index.isConstraintIndex(), (String)"should not be a constraint index");
            Assertions.assertTrue((boolean)index.isMultiTokenIndex(), (String)"should be a multi-token index");
            Assertions.assertTrue((boolean)index.isCompositeIndex(), (String)"should be a composite index");
            Assertions.assertFalse((boolean)index.isNodeIndex(), (String)"should not be a node index");
            Assertions.assertTrue((boolean)index.isRelationshipIndex(), (String)"should be a relationship index");
            Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{PROPERTY_KEY, PROPERTY_KEY2}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
        }
    }

    @Test
    void shouldListAll() throws Exception {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        IndexDescriptor index1 = schemaWrite.indexCreate((SchemaDescriptor)this.schema, "my index");
        IndexBackedConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema2).withName("constraint name")).asIndexBackedConstraint();
        this.commit();
        SchemaRead schemaRead = this.newTransaction().schemaRead();
        IndexDescriptor index2 = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index(constraint.schema()));
        List indexes = Iterators.asList((Iterator)schemaRead.indexesGetAll());
        MatcherAssert.assertThat((Object)indexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{index1, index2}));
        this.commit();
    }

    private static Runnable createIndex(GraphDatabaseAPI db, Label label, String propertyKey) {
        return () -> {
            try (Transaction transaction = db.beginTx();){
                transaction.schema().indexFor(label).on(propertyKey).create();
                transaction.commit();
            }
            transaction = db.beginTx();
            try {
                transaction.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        };
    }
}

