/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsIterableContaining;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

class ProceduresKernelIT
extends KernelIntegrationTest {
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc"}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build();
    private final CallableProcedure procedure = ProceduresKernelIT.procedure(this.signature);

    ProceduresKernelIT() {
    }

    @Test
    void shouldGetProcedureByName() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        ProcedureSignature found = this.procs().procedureGet(new QualifiedName(new String[]{"example"}, "exampleProc")).signature();
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)this.signature));
        this.commit();
    }

    @Test
    void shouldGetBuiltInProcedureByName() throws Throwable {
        ProcedureSignature found = this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).signature();
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)ProcedureSignature.procedureSignature((QualifiedName)ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).out("label", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        this.commit();
    }

    @Test
    void shouldGetAllProcedures() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc3"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
        List signatures = Iterables.asList((Iterable)this.newTransaction().procedures().proceduresGetAll());
        MatcherAssert.assertThat((Object)signatures, (Matcher)IsIterableContaining.hasItems((Object[])new ProcedureSignature[]{this.procedure.signature(), ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build(), ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc3"}).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()}));
        this.commit();
    }

    @Test
    void shouldRefuseToRegisterNonVoidProcedureWithoutOutputs() throws ProcedureException {
        ProcedureException e = (ProcedureException)Assertions.assertThrows(ProcedureException.class, () -> this.internalKernel().registerProcedure(ProceduresKernelIT.procedure(ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc2"}).build())));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Procedures with zero output fields must be declared as VOID"));
    }

    @Test
    void shouldCallReadOnlyProcedure() throws Throwable {
        this.internalKernel().registerProcedure(this.procedure);
        RawIterator found = this.procs().procedureCallRead(this.procs().procedureGet(new QualifiedName(new String[]{"example"}, "exampleProc")).id(), new AnyValue[]{Values.longValue((long)1337L)}, ProcedureCallContext.EMPTY);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)found), (Matcher)Matchers.contains((Matcher)CoreMatchers.equalTo((Object)new AnyValue[]{Values.longValue((long)1337L)})));
        this.commit();
    }

    @Test
    void registeredProcedureShouldGetRead() throws Throwable {
        this.internalKernel().registerProcedure((CallableProcedure)new CallableProcedure.BasicProcedure(this.signature){

            public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
                return RawIterator.of((Object[])new AnyValue[][]{{Values.stringValue((String)ctx.internalTransaction().kernelTransaction().dataRead().toString())}});
            }
        });
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(this.signature.name()).id(), new AnyValue[]{Values.EMPTY_STRING}, ProcedureCallContext.EMPTY);
        Assertions.assertNotNull((Object)((AnyValue[])Iterators.asList((RawIterator)stream).get(0))[0]);
        this.commit();
    }

    private static CallableProcedure procedure(ProcedureSignature signature) {
        return new CallableProcedure.BasicProcedure(signature){

            public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) {
                return RawIterator.of((Object[])new AnyValue[][]{input});
            }
        };
    }
}

