/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@EphemeralTestDirectoryExtension
class SchemaRecoveryIT {
    @Inject
    private volatile EphemeralFileSystemAbstraction fs;
    @Inject
    private TestDirectory testDirectory;
    private GraphDatabaseAPI db;
    private DatabaseManagementService managementService;

    SchemaRecoveryIT() {
    }

    @AfterEach
    void shutdownDatabase() {
        if (this.db != null) {
            this.managementService.shutdown();
            this.db = null;
        }
    }

    @Test
    void schemaTransactionsShouldSurviveRecovery() {
        Label label = Label.label((String)"User");
        String property = "email";
        this.startDb();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.createNode(new Label[]{label}).setProperty(property, (Object)"neo4j@neo4j.com");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.killDb();
        this.startDb();
        Assertions.assertEquals((int)1, (int)this.constraints((GraphDatabaseService)this.db).size());
        Assertions.assertEquals((int)1, (int)this.indexes((GraphDatabaseService)this.db).size());
    }

    @Test
    void inconsistentlyFlushedTokensShouldBeRecovered() {
        Label label = Label.label((String)"User");
        String property = "email";
        this.startDb();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().constraintFor(label).assertPropertyIsUnique(property).create();
            tx.commit();
        }
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        storageEngine.testAccessNeoStores().getPropertyKeyTokenStore().flush();
        this.killDb();
        this.startDb();
        Assertions.assertEquals((int)1, (int)this.constraints((GraphDatabaseService)this.db).size());
        Assertions.assertEquals((int)1, (int)this.indexes((GraphDatabaseService)this.db).size());
    }

    private void startDb() {
        if (this.db != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setFileSystem((FileSystemAbstraction)this.fs).impermanent().build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private void killDb() {
        if (this.db != null) {
            this.fs = this.fs.snapshot();
            this.managementService.shutdown();
        }
    }

    private List<ConstraintDefinition> constraints(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            List list = Iterables.asList((Iterable)tx.schema().getConstraints());
            return list;
        }
    }

    private List<IndexDefinition> indexes(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            List list = Iterables.asList((Iterable)tx.schema().getIndexes());
            return list;
        }
    }
}

