/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class BigStoreIT {
    private static final RelationshipType OTHER_TYPE = RelationshipType.withName((String)"OTHER");
    private static final RelationshipType BIG_TYPE = RelationshipType.withName((String)"BIG_TYPE");
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;
    private GraphDatabaseService db;
    private static final Label REFERENCE = Label.label((String)"Reference");

    BigStoreIT() {
    }

    @BeforeEach
    void doBefore() {
        this.startDb();
    }

    private void startDb() {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir());
        this.managementService = builder.build();
        this.db = this.managementService.database("neo4j");
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    void create4BPlusStuff() {
        this.testHighIds((long)Math.pow(2.0, 32.0), 2, 400);
    }

    @Test
    void create8BPlusStuff() {
        this.testHighIds((long)Math.pow(2.0, 33.0), 1, 1000);
    }

    @Test
    void createAndVerify32BitGraph() {
        this.createAndVerifyGraphStartingWithId((long)Math.pow(2.0, 32.0), 400);
    }

    @Test
    void createAndVerify33BitGraph() {
        this.createAndVerifyGraphStartingWithId((long)Math.pow(2.0, 33.0), 1000);
    }

    private void createAndVerifyGraphStartingWithId(long startId, int requiredHeapMb) {
        Assumptions.assumeTrue((boolean)BigStoreIT.machineIsOkToRunThisTest(requiredHeapMb));
        Node refNode = BigStoreIT.createReferenceNode(this.db);
        this.setHighIds(startId - 1000L);
        byte[] bytes = new byte[45];
        bytes[2] = 5;
        bytes[10] = 42;
        Map properties = MapUtil.map((Object[])new Object[]{"number", 11, "short string", "test", "long string", "This is a long value, long enough", "array", bytes});
        Transaction tx = this.db.beginTx();
        int count = 10000;
        for (int i = 0; i < count; ++i) {
            Node node = tx.createNode();
            BigStoreIT.setProperties((Entity)node, properties);
            Relationship rel1 = tx.getNodeById(refNode.getId()).createRelationshipTo(node, BIG_TYPE);
            BigStoreIT.setProperties((Entity)rel1, properties);
            Node highNode = tx.createNode();
            Relationship rel2 = node.createRelationshipTo(highNode, OTHER_TYPE);
            BigStoreIT.setProperties((Entity)rel2, properties);
            BigStoreIT.setProperties((Entity)highNode, properties);
            if (i % 100 != 0 || i <= 0) continue;
            tx.commit();
            tx = this.db.beginTx();
        }
        tx.commit();
        this.managementService.shutdown();
        this.startDb();
        int verified = 0;
        try (Transaction transaction = this.db.beginTx();){
            refNode = transaction.getNodeById(refNode.getId());
            for (Relationship rel : refNode.getRelationships(Direction.OUTGOING)) {
                Node node = rel.getEndNode();
                BigStoreIT.assertProperties(properties, (Entity)node);
                BigStoreIT.assertProperties(properties, (Entity)rel);
                Node highNode = node.getSingleRelationship(OTHER_TYPE, Direction.OUTGOING).getEndNode();
                BigStoreIT.assertProperties(properties, (Entity)highNode);
                ++verified;
            }
            transaction.commit();
        }
        Assertions.assertEquals((int)count, (int)verified);
    }

    private static Node createReferenceNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{REFERENCE});
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }

    private static boolean machineIsOkToRunThisTest(int requiredHeapMb) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return false;
        }
        long heapMb = Runtime.getRuntime().maxMemory() / 1000000L;
        return heapMb >= (long)requiredHeapMb;
    }

    private static void assertProperties(Map<String, Object> properties, Entity entity) {
        int count = 0;
        for (String key : entity.getPropertyKeys()) {
            Object expectedValue = properties.get(key);
            Object entityValue = entity.getProperty(key);
            if (expectedValue.getClass().isArray()) {
                Assertions.assertArrayEquals((byte[])((byte[])expectedValue), (byte[])((byte[])entityValue));
            } else {
                Assertions.assertEquals((Object)expectedValue, (Object)entityValue);
            }
            ++count;
        }
        Assertions.assertEquals((int)properties.size(), (int)count);
    }

    private static void setProperties(Entity entity, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            entity.setProperty(property.getKey(), property.getValue());
        }
    }

    private void testHighIds(long highMark, int minus, int requiredHeapMb) {
        Assumptions.assumeTrue((boolean)BigStoreIT.machineIsOkToRunThisTest(requiredHeapMb));
        long idBelow = highMark - (long)minus;
        this.setHighIds(idBelow);
        String propertyKey = "name";
        int intPropertyValue = 123;
        String stringPropertyValue = "Long string, longer than would fit in shortstring";
        long[] arrayPropertyValue = new long[]{1021L, 321L, 343212L};
        Transaction tx = this.db.beginTx();
        Node nodeBelowTheLine = tx.createNode();
        nodeBelowTheLine.setProperty(propertyKey, (Object)intPropertyValue);
        Assertions.assertEquals((long)idBelow, (long)nodeBelowTheLine.getId());
        Node nodeAboveTheLine = tx.createNode();
        nodeAboveTheLine.setProperty(propertyKey, (Object)stringPropertyValue);
        Relationship relBelowTheLine = nodeBelowTheLine.createRelationshipTo(nodeAboveTheLine, BIG_TYPE);
        relBelowTheLine.setProperty(propertyKey, (Object)arrayPropertyValue);
        Assertions.assertEquals((long)idBelow, (long)relBelowTheLine.getId());
        Relationship relAboveTheLine = nodeAboveTheLine.createRelationshipTo(nodeBelowTheLine, BIG_TYPE);
        Assertions.assertEquals((long)highMark, (long)relAboveTheLine.getId());
        Assertions.assertEquals((long)highMark, (long)nodeAboveTheLine.getId());
        Assertions.assertEquals((Object)intPropertyValue, (Object)nodeBelowTheLine.getProperty(propertyKey));
        Assertions.assertEquals((Object)stringPropertyValue, (Object)nodeAboveTheLine.getProperty(propertyKey));
        Assertions.assertArrayEquals((long[])arrayPropertyValue, (long[])((long[])relBelowTheLine.getProperty(propertyKey)));
        tx.commit();
        for (int i = 0; i < 2; ++i) {
            try (Transaction transaction = this.db.beginTx();){
                Assertions.assertEquals((Object)nodeAboveTheLine, (Object)transaction.getNodeById(highMark));
                Assertions.assertEquals((long)idBelow, (long)nodeBelowTheLine.getId());
                Assertions.assertEquals((long)highMark, (long)nodeAboveTheLine.getId());
                Assertions.assertEquals((long)idBelow, (long)relBelowTheLine.getId());
                Assertions.assertEquals((long)highMark, (long)relAboveTheLine.getId());
                Assertions.assertEquals((Object)relBelowTheLine, (Object)transaction.getNodeById(idBelow).getSingleRelationship(BIG_TYPE, Direction.OUTGOING));
                Assertions.assertEquals((Object)relAboveTheLine, (Object)transaction.getNodeById(idBelow).getSingleRelationship(BIG_TYPE, Direction.INCOMING));
                Assertions.assertEquals((long)idBelow, (long)relBelowTheLine.getId());
                Assertions.assertEquals((long)highMark, (long)relAboveTheLine.getId());
                Assertions.assertEquals(BigStoreIT.asSet(Arrays.asList(relBelowTheLine, relAboveTheLine)), BigStoreIT.asSet(Iterables.asCollection((Iterable)transaction.getNodeById(idBelow).getRelationships())));
                transaction.commit();
            }
            if (i != 0) continue;
            this.managementService.shutdown();
            this.startDb();
        }
    }

    private void setHighIds(long id) {
        this.setHighId(IdType.NODE, id);
        this.setHighId(IdType.RELATIONSHIP, id);
        this.setHighId(IdType.PROPERTY, id);
        this.setHighId(IdType.ARRAY_BLOCK, id);
        this.setHighId(IdType.STRING_BLOCK, id);
    }

    private static <T> Collection<T> asSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    private void setHighId(IdType type, long highId) {
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(IdGeneratorFactory.class);
        IdGenerator idGenerator = idGeneratorFactory.get(type);
        idGenerator.setHighId(highId);
        idGenerator.markHighestWrittenAtHighId();
    }
}

