/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class LargePropertiesIT {
    @Inject
    private EphemeralFileSystemAbstraction fs;

    LargePropertiesIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void readArrayAndStringPropertiesWithDifferentBlockSizes() {
        String stringValue = RandomStringUtils.randomAlphanumeric((int)10000);
        byte[] arrayValue = RandomStringUtils.randomAlphanumeric((int)10000).getBytes();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder().setFileSystem((FileSystemAbstraction)this.fs).impermanent().setConfig(GraphDatabaseSettings.string_block_size, (Object)1024).setConfig(GraphDatabaseSettings.array_block_size, (Object)2048).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            long nodeId;
            Node node;
            try (Transaction tx = db.beginTx();){
                node = tx.createNode();
                nodeId = node.getId();
                node.setProperty("string", (Object)stringValue);
                node.setProperty("array", (Object)arrayValue);
                tx.commit();
            }
            tx = db.beginTx();
            try {
                node = tx.getNodeById(nodeId);
                Assertions.assertEquals((Object)stringValue, (Object)node.getProperty("string"));
                Assertions.assertArrayEquals((byte[])arrayValue, (byte[])((byte[])node.getProperty("array")));
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
    }
}

