/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class TestConcurrentIteratorModification {
    @Inject
    private GraphDatabaseService db;

    TestConcurrentIteratorModification() {
    }

    @Test
    void shouldNotThrowConcurrentModificationExceptionWhenUpdatingWhileIterating() {
        Node node3;
        Node node2;
        Node node1;
        Label label = Label.label((String)"Bird");
        try (Transaction tx = this.db.beginTx();){
            node1 = tx.createNode(new Label[]{label});
            node2 = tx.createNode(new Label[]{label});
            tx.commit();
        }
        HashSet<Node> result = new HashSet<Node>();
        try (Transaction tx = this.db.beginTx();){
            node3 = tx.createNode(new Label[]{label});
            ResourceIterator iterator = tx.findNodes(label);
            node3.removeLabel(label);
            tx.createNode(new Label[]{label});
            while (iterator.hasNext()) {
                result.add((Node)iterator.next());
            }
            tx.commit();
        }
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node2, node3}), result);
    }
}

