/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;

class TestPropertyTypes
extends AbstractNeo4jTestCase {
    private Node node1;

    TestPropertyTypes() {
    }

    @BeforeEach
    void createInitialNode() {
        this.node1 = this.createNode();
    }

    @Test
    void testDoubleType() {
        Double propertyValue;
        Double dValue = 45.678;
        String key = "testdouble";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)dValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Double)this.node1.getProperty(key);
            Assertions.assertEquals((Double)dValue, (Double)propertyValue);
            dValue = 56784.3243;
            this.node1.setProperty(key, (Object)dValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Double)this.node1.getProperty(key);
            Assertions.assertEquals((Double)dValue, (Double)propertyValue);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(this.node1.getId()).removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testFloatType() {
        Float propertyValue;
        Float fValue = Float.valueOf(45.678f);
        String key = "testfloat";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)fValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Float)this.node1.getProperty(key);
            Assertions.assertEquals((Float)fValue, (Float)propertyValue);
            fValue = Float.valueOf(5684.324f);
            this.node1.setProperty(key, (Object)fValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Float)this.node1.getProperty(key);
            Assertions.assertEquals((Float)fValue, (Float)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLongType() {
        Long propertyValue;
        Long lValue = System.currentTimeMillis();
        String key = "testlong";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)lValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Long)this.node1.getProperty(key);
            Assertions.assertEquals((Long)lValue, (Long)propertyValue);
            lValue = System.currentTimeMillis();
            this.node1.setProperty(key, (Object)lValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Long)this.node1.getProperty(key);
            Assertions.assertEquals((Long)lValue, (Long)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            Assertions.assertFalse((boolean)this.node1.hasProperty(key));
            this.node1.setProperty("other", (Object)123L);
            Assertions.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)123L, (Object)transaction.getNodeById(this.node1.getId()).getProperty("other"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testIntType() {
        Integer propertyValue;
        Integer iValue = (int)System.currentTimeMillis();
        String key = "testing";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)iValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Integer)this.node1.getProperty(key);
            Assertions.assertEquals((Integer)iValue, (Integer)propertyValue);
            iValue = (int)System.currentTimeMillis();
            this.node1.setProperty(key, (Object)iValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Integer)this.node1.getProperty(key);
            Assertions.assertEquals((Integer)iValue, (Integer)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            Assertions.assertFalse((boolean)this.node1.hasProperty(key));
            this.node1.setProperty("other", (Object)123L);
            Assertions.assertEquals((Object)123L, (Object)this.node1.getProperty("other"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertEquals((Object)123L, (Object)transaction.getNodeById(this.node1.getId()).getProperty("other"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testByteType() {
        Byte propertyValue;
        byte b = -79;
        String key = "testbyte";
        Byte bValue = b;
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)bValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Byte)this.node1.getProperty(key);
            Assertions.assertEquals((Byte)bValue, (Byte)propertyValue);
            bValue = -56;
            this.node1.setProperty(key, (Object)bValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Byte)this.node1.getProperty(key);
            Assertions.assertEquals((Byte)bValue, (Byte)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testShortType() {
        Short propertyValue;
        Short sValue = 453;
        String key = "testshort";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)sValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Short)this.node1.getProperty(key);
            Assertions.assertEquals((Short)sValue, (Short)propertyValue);
            sValue = 5335;
            this.node1.setProperty(key, (Object)sValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Short)this.node1.getProperty(key);
            Assertions.assertEquals((Short)sValue, (Short)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testCharType() {
        Character propertyValue;
        Character cValue = Character.valueOf('c');
        String key = "testchar";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)cValue);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Character)this.node1.getProperty(key);
            Assertions.assertEquals((Character)cValue, (Character)propertyValue);
            cValue = Character.valueOf('d');
            this.node1.setProperty(key, (Object)cValue);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Character)this.node1.getProperty(key);
            Assertions.assertEquals((Character)cValue, (Character)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testBooleanType() {
        Boolean propertyValue;
        String key = "testbool";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)Boolean.TRUE);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Boolean)this.node1.getProperty(key);
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)propertyValue);
            this.node1.setProperty(key, (Object)Boolean.FALSE);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (Boolean)this.node1.getProperty(key);
            Assertions.assertEquals((Object)Boolean.FALSE, (Object)propertyValue);
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testPointType() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        String key = "location";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)point);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)point, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testPointTypeWithOneOtherProperty() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        String key = "location";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            this.node1.setProperty("prop1", (Object)1);
            this.node1.setProperty(key, (Object)point);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)point, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testPointTypeWithTwoOtherProperties() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0});
        String key = "location";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            this.node1.setProperty("prop1", (Object)1);
            this.node1.setProperty("prop2", (Object)2);
            this.node1.setProperty(key, (Object)point);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)point, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void test3DPointType() {
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 1.0, 1.0});
        String key = "location";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)point);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            Object property = this.node1.getProperty(key);
            Assertions.assertEquals((Object)point, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void test4DPointType() {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> transaction.getNodeById(this.node1.getId()).setProperty("location", (Object)Values.unsafePointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{1.0, 1.0, 1.0, 1.0})));
        }
    }

    @Test
    void testPointArray() {
        Point[] array = new Point[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{1.0, 1.0, 1.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{2.0, 1.0, 3.0})};
        String key = "testpointarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            Point[] propertyValue = (Point[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateTypeSmallEpochDay() {
        LocalDate date = (LocalDate)DateValue.date((int)2018, (int)1, (int)31).asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)date);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)date, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateTypeLargeEpochDay() {
        LocalDate date = (LocalDate)DateValue.epochDate((long)0x80000000L).asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)date);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)date, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateArray() {
        LocalDate[] array = new LocalDate[]{(LocalDate)DateValue.date((int)2018, (int)1, (int)31).asObjectCopy(), (LocalDate)DateValue.epochDate((long)0x80000000L).asObjectCopy()};
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            LocalDate[] propertyValue = (LocalDate[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLocalTimeTypeSmallNano() {
        LocalTime time = (LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)0, (int)37).asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)time);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)time, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLocalTimeTypeLargeNano() {
        LocalTime time = (LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)13, (int)37).asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)time);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)time, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLocalTimeArray() {
        LocalTime[] array = new LocalTime[]{(LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)0, (int)37).asObjectCopy(), (LocalTime)LocalTimeValue.localTime((int)0, (int)0, (int)13, (int)37).asObjectCopy()};
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            LocalTime[] propertyValue = (LocalTime[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLocalDateTimeType() {
        LocalDateTime dateTime = (LocalDateTime)LocalDateTimeValue.localDateTime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37).asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)dateTime);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)dateTime, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLocalDateTimeArray() {
        LocalDateTime[] array = new LocalDateTime[]{(LocalDateTime)LocalDateTimeValue.localDateTime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37).asObjectCopy(), (LocalDateTime)LocalDateTimeValue.localDateTime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000).asObjectCopy()};
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            LocalDateTime[] propertyValue = (LocalDateTime[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testTimeType() {
        OffsetTime time = (OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)time);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)time, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testTimeArray() {
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            for (OffsetTime[] array : new OffsetTime[][]{{(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy()}, {(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy(), (OffsetTime)TimeValue.time((int)14, (int)34, (int)55, (int)3478, (String)"+02:00").asObjectCopy()}, {(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy(), (OffsetTime)TimeValue.time((int)14, (int)34, (int)55, (int)3478, (String)"+02:00").asObjectCopy(), (OffsetTime)TimeValue.time((int)0, (int)17, (int)20, (int)783478, (String)"-03:00").asObjectCopy()}, {(OffsetTime)TimeValue.time((int)23, (int)11, (int)8, (int)0, (String)"+17:59").asObjectCopy(), (OffsetTime)TimeValue.time((int)14, (int)34, (int)55, (int)3478, (String)"+02:00").asObjectCopy(), (OffsetTime)TimeValue.time((int)0, (int)17, (int)20, (int)783478, (String)"-03:00").asObjectCopy(), (OffsetTime)TimeValue.time((int)1, (int)1, (int)1, (int)1, (String)"-01:00").asObjectCopy()}}) {
                this.node1.setProperty(key, (Object)array);
                OffsetTime[] propertyValue = (OffsetTime[])this.node1.getProperty(key);
                Assertions.assertEquals((int)array.length, (int)propertyValue.length);
                for (int i = 0; i < array.length; ++i) {
                    Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
                }
            }
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            transaction.getNodeById(this.node1.getId()).removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDurationType() {
        TemporalAmount duration = DurationValue.duration((long)57L, (long)57L, (long)57L, (long)57L).asObjectCopy();
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)duration);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)duration, (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDurationArray() {
        TemporalAmount[] array = new TemporalAmount[]{DurationValue.duration((long)57L, (long)57L, (long)57L, (long)57L).asObjectCopy(), DurationValue.duration((long)-40L, (long)-189L, (long)-6247L, (long)-1L).asObjectCopy()};
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            TemporalAmount[] propertyValue = (TemporalAmount[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateTimeTypeWithZoneOffset() {
        DateTimeValue dateTime = DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (String)"+01:00");
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)dateTime);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)dateTime.asObjectCopy(), (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateTimeArrayWithZoneOffset() {
        ZonedDateTime[] array = new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (String)"-01:00").asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000, (String)"+11:00").asObjectCopy()};
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            ZonedDateTime[] propertyValue = (ZonedDateTime[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateTimeTypeWithZoneId() {
        DateTimeValue dateTime = DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (ZoneId)ZoneId.of("Europe/Stockholm"));
        String key = "dt";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)dateTime);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Object property = transaction.getNodeById(this.node1.getId()).getProperty(key);
            Assertions.assertEquals((Object)dateTime.asObjectCopy(), (Object)property);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDateTimeArrayWithZoneOffsetAndZoneID() {
        ZonedDateTime[] array = new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.datetime((int)1991, (int)1, (int)1, (int)0, (int)0, (int)13, (int)37, (String)"-01:00").asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000, (String)"+11:00").asObjectCopy(), (ZonedDateTime)DateTimeValue.datetime((int)1992, (int)2, (int)28, (int)1, (int)15, (int)0, (int)4000, (ZoneId)ZoneId.of("Europe/Stockholm")).asObjectCopy()};
        String key = "testarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            ZonedDateTime[] propertyValue = (ZonedDateTime[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array.length, (int)propertyValue.length);
            for (int i = 0; i < array.length; ++i) {
                Assertions.assertEquals((Object)array[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testIntArray() {
        int i;
        int[] propertyValue;
        int[] array1 = new int[]{1, 2, 3, 4, 5};
        Integer[] array2 = new Integer[]{6, 7, 8};
        String key = "testintarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (int[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((int)array1[i], (int)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (int[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Integer)array2[i], (Integer)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testShortArray() {
        int i;
        short[] propertyValue;
        short[] array1 = new short[]{1, 2, 3, 4, 5};
        Short[] array2 = new Short[]{(short)6, (short)7, (short)8};
        String key = "testintarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (short[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((short)array1[i], (short)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (short[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Short)array2[i], (Short)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testStringArray() {
        int i;
        String[] propertyValue;
        String[] array1 = new String[]{"a", "b", "c", "d", "e"};
        String[] array2 = new String[]{"ff", "gg", "hh"};
        String key = "teststringarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (String[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((Object)array1[i], (Object)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (String[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Object)array2[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testBooleanArray() {
        int i;
        boolean[] propertyValue;
        boolean[] array1 = new boolean[]{true, false, true, false, true};
        Boolean[] array2 = new Boolean[]{false, true, false};
        String key = "testboolarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (boolean[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((Object)array1[i], (Object)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (boolean[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Object)array2[i], (Object)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testDoubleArray() {
        int i;
        double[] propertyValue;
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        Double[] array2 = new Double[]{6.0, 7.0, 8.0};
        String key = "testdoublearray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (double[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((double)array1[i], (double)propertyValue[i], (double)0.0);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (double[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Double)array2[i], (Double)new Double(propertyValue[i]));
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testFloatArray() {
        int i;
        float[] propertyValue;
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Float[] array2 = new Float[]{Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f)};
        String key = "testfloatarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (float[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((double)array1[i], (double)propertyValue[i], (double)0.0);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (float[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Float)array2[i], (Float)new Float(propertyValue[i]));
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testLongArray() {
        int i;
        long[] propertyValue;
        long[] array1 = new long[]{1L, 2L, 3L, 4L, 5L};
        Long[] array2 = new Long[]{6L, 7L, 8L};
        String key = "testlongarray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (long[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((long)array1[i], (long)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (long[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Long)array2[i], (Long)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testByteArray() {
        int i;
        byte[] propertyValue;
        byte[] array1 = new byte[]{1, 2, 3, 4, 5};
        Byte[] array2 = new Byte[]{(byte)6, (byte)7, (byte)8};
        String key = "testbytearray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (byte[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((byte)array1[i], (byte)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (byte[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Byte)array2[i], (Byte)propertyValue[i]);
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testCharArray() {
        int i;
        char[] propertyValue;
        char[] array1 = new char[]{'1', '2', '3', '4', '5'};
        Character[] array2 = new Character[]{Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8')};
        String key = "testchararray";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, (Object)array1);
            transaction.commit();
        }
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (char[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array1.length, (int)propertyValue.length);
            for (i = 0; i < array1.length; ++i) {
                Assertions.assertEquals((char)array1[i], (char)propertyValue[i]);
            }
            this.node1.setProperty(key, (Object)array2);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            propertyValue = (char[])this.node1.getProperty(key);
            Assertions.assertEquals((int)array2.length, (int)propertyValue.length);
            for (i = 0; i < array2.length; ++i) {
                Assertions.assertEquals((Character)array2[i], (Character)new Character(propertyValue[i]));
            }
            this.node1.removeProperty(key);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = this.getGraphDb().beginTx();
        try {
            Assertions.assertFalse((boolean)transaction.getNodeById(this.node1.getId()).hasProperty(key));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testEmptyString() {
        Node node = this.createNode();
        try (Transaction transaction = this.getGraphDb().beginTx();){
            node = transaction.getNodeById(node.getId());
            node.setProperty("1", (Object)2);
            node.setProperty("2", (Object)"");
            node.setProperty("3", (Object)"");
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            node = transaction.getNodeById(node.getId());
            Assertions.assertEquals((Object)2, (Object)node.getProperty("1"));
            Assertions.assertEquals((Object)"", (Object)node.getProperty("2"));
            Assertions.assertEquals((Object)"", (Object)node.getProperty("3"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotBeAbleToPoisonBooleanArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new boolean[]{false, false, false}, true);
    }

    @Test
    void shouldNotBeAbleToPoisonByteArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new byte[]{0, 0, 0}, (byte)1);
    }

    @Test
    void shouldNotBeAbleToPoisonShortArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new short[]{0, 0, 0}, (short)1);
    }

    @Test
    void shouldNotBeAbleToPoisonIntArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new int[]{0, 0, 0}, 1);
    }

    @Test
    void shouldNotBeAbleToPoisonLongArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new long[]{0L, 0L, 0L}, 1L);
    }

    @Test
    void shouldNotBeAbleToPoisonFloatArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new float[]{0.0f, 0.0f, 0.0f}, Float.valueOf(1.0f));
    }

    @Test
    void shouldNotBeAbleToPoisonDoubleArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new double[]{0.0, 0.0, 0.0}, 1.0);
    }

    @Test
    void shouldNotBeAbleToPoisonCharArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new char[]{'0', '0', '0'}, Character.valueOf('1'));
    }

    @Test
    void shouldNotBeAbleToPoisonStringArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(new String[]{"zero", "zero", "zero"}, "one");
    }

    private Object veryLongArray(Class<?> type) {
        return Array.newInstance(type, 1000);
    }

    private String[] veryLongStringArray() {
        Object[] array = new String[100];
        Arrays.fill(array, "zero");
        return array;
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongBooleanArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Boolean.TYPE), true);
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongByteArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Byte.TYPE), (byte)1);
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongShortArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Short.TYPE), (short)1);
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongIntArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Integer.TYPE), 1);
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongLongArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Long.TYPE), 1L);
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongFloatArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Float.TYPE), Float.valueOf(1.0f));
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongDoubleArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Double.TYPE), 1.0);
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongCharArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongArray(Character.TYPE), Character.valueOf('1'));
    }

    @Test
    void shouldNotBeAbleToPoisonVeryLongStringArrayProperty() {
        this.shouldNotBeAbleToPoisonArrayProperty(this.veryLongStringArray(), "one");
    }

    private void shouldNotBeAbleToPoisonArrayProperty(Object value, Object poison) {
        this.shouldNotBeAbleToPoisonArrayPropertyInsideTransaction(value, poison);
        this.shouldNotBeAbleToPoisonArrayPropertyOutsideTransaction(value, poison);
    }

    private void shouldNotBeAbleToPoisonArrayPropertyInsideTransaction(Object value, Object poison) {
        try (Transaction transaction = this.getGraphDb().beginTx();){
            this.node1 = transaction.getNodeById(this.node1.getId());
            String key = "key";
            this.node1.setProperty(key, value);
            Object readValue = this.node1.getProperty(key);
            Array.set(readValue, 0, poison);
            Assertions.assertTrue((boolean)ArrayUtil.equals((Object)value, (Object)this.node1.getProperty(key)), (String)String.format("Expected %s, but was %s", Strings.prettyPrint((Object)value), Strings.prettyPrint((Object)readValue)));
            transaction.commit();
        }
    }

    private void shouldNotBeAbleToPoisonArrayPropertyOutsideTransaction(Object value, Object poison) {
        String key = "key";
        try (Transaction transaction = this.getGraphDb().beginTx();){
            transaction.getNodeById(this.node1.getId()).setProperty(key, value);
            transaction.commit();
        }
        transaction = this.getGraphDb().beginTx();
        try {
            this.node1 = transaction.getNodeById(this.node1.getId());
            Object readValue = this.node1.getProperty(key);
            Array.set(readValue, 0, poison);
            Assertions.assertTrue((boolean)ArrayUtil.equals((Object)value, (Object)this.node1.getProperty(key)), (String)String.format("Expected %s, but was %s", Strings.prettyPrint((Object)value), Strings.prettyPrint((Object)readValue)));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

