/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.Race;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
@ImpermanentDbmsExtension
class RelationshipCreateDeleteIT {
    @Inject
    private GraphDatabaseService db;
    @Inject
    private static RandomRule random;

    RelationshipCreateDeleteIT() {
    }

    @Test
    void shouldNotDeadlockOrCrashFromInconsistency() throws Throwable {
        int i;
        Node b;
        Node a;
        try (Transaction tx = this.db.beginTx();){
            a = tx.createNode();
            b = tx.createNode();
            a.createRelationshipTo(b, (RelationshipType)MyRelTypes.TEST);
            tx.commit();
        }
        Race race = new Race();
        for (i = 0; i < 30; ++i) {
            race.addContestant(() -> {
                for (int j = 0; j < 10; ++j) {
                    try (Transaction tx = this.db.beginTx();){
                        Node node = random.nextBoolean() ? a : b;
                        node = tx.getNodeById(node.getId());
                        for (Relationship relationship : node.getRelationships()) {
                            try {
                                relationship.delete();
                            }
                            catch (NotFoundException e) {
                                Assertions.assertTrue((boolean)e.getMessage().contains("already deleted"));
                            }
                        }
                        tx.commit();
                        continue;
                    }
                }
            });
        }
        for (i = 0; i < 30; ++i) {
            race.addContestant(() -> {
                for (int j = 0; j < 10; ++j) {
                    try (Transaction tx = this.db.beginTx();){
                        boolean order = random.nextBoolean();
                        Node start = tx.getNodeById((order ? a : b).getId());
                        Node end = tx.getNodeById((order ? b : a).getId());
                        start.createRelationshipTo(end, (RelationshipType)MyRelTypes.TEST);
                        tx.commit();
                        continue;
                    }
                }
            });
        }
        race.go();
    }
}

