/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;

public abstract class DefaultPooledCursorsTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long startNode;
    private static long relationship;
    private static long propNode;
    private static final String NODE_PROP_INDEX_NAME = "nodeProp";

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").withName(NODE_PROP_INDEX_NAME).create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            Node a = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node b = tx.createNode(new Label[]{Label.label((String)"Bar")});
            startNode = a.getId();
            relationship = a.createRelationshipTo(b, RelationshipType.withName((String)"REL")).getId();
            propNode = this.createNodeWithProperty(tx, "prop", true);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldReuseNodeCursor() {
        NodeCursor c1 = this.cursors.allocateNodeCursor();
        this.read.singleNode(startNode, c1);
        c1.close();
        NodeCursor c2 = this.cursors.allocateNodeCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessNodeCursor() {
        NodeCursor c1 = this.cursors.allocateFullAccessNodeCursor();
        this.read.singleNode(startNode, c1);
        c1.close();
        NodeCursor c2 = this.cursors.allocateFullAccessNodeCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseRelationshipScanCursor() {
        RelationshipScanCursor c1 = this.cursors.allocateRelationshipScanCursor();
        this.read.singleRelationship(relationship, c1);
        c1.close();
        RelationshipScanCursor c2 = this.cursors.allocateRelationshipScanCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessRelationshipScanCursor() {
        RelationshipScanCursor c1 = this.cursors.allocateFullAccessRelationshipScanCursor();
        this.read.singleRelationship(relationship, c1);
        c1.close();
        RelationshipScanCursor c2 = this.cursors.allocateFullAccessRelationshipScanCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseRelationshipGroupCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor();
        RelationshipGroupCursor c1 = this.cursors.allocateRelationshipGroupCursor();
        this.read.singleNode(startNode, node);
        node.next();
        node.relationships(c1);
        node.close();
        c1.close();
        RelationshipGroupCursor c2 = this.cursors.allocateRelationshipGroupCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseRelationshipTraversalCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor();
        RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor c1 = this.cursors.allocateRelationshipTraversalCursor();
        this.read.singleNode(startNode, node);
        node.next();
        node.relationships(group);
        group.outgoing(c1);
        node.close();
        group.close();
        c1.close();
        RelationshipTraversalCursor c2 = this.cursors.allocateRelationshipTraversalCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReusePropertyCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor();
        PropertyCursor c1 = this.cursors.allocatePropertyCursor();
        this.read.singleNode(propNode, node);
        node.next();
        node.properties(c1);
        node.close();
        c1.close();
        PropertyCursor c2 = this.cursors.allocatePropertyCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessPropertyCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor();
        PropertyCursor c1 = this.cursors.allocateFullAccessPropertyCursor();
        this.read.singleNode(propNode, node);
        node.next();
        node.properties(c1);
        node.close();
        c1.close();
        PropertyCursor c2 = this.cursors.allocateFullAccessPropertyCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseNodeValueIndexCursor() throws Exception {
        int prop = this.token.propertyKey("prop");
        IndexDescriptor indexDescriptor = this.tx.schemaRead().indexGetForName(NODE_PROP_INDEX_NAME);
        Predicates.awaitEx(() -> this.tx.schemaRead().indexGetState(indexDescriptor) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        IndexReadSession indexSession = this.tx.dataRead().indexReadSession(indexDescriptor);
        NodeValueIndexCursor c1 = this.cursors.allocateNodeValueIndexCursor();
        this.read.nodeIndexSeek(indexSession, c1, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"zero")});
        c1.close();
        NodeValueIndexCursor c2 = this.cursors.allocateNodeValueIndexCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseNodeLabelIndexCursor() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            NodeLabelIndexCursor c1 = tx.cursors().allocateNodeLabelIndexCursor();
            tx.dataRead().nodeLabelScan(1, c1);
            c1.close();
            NodeLabelIndexCursor c2 = tx.cursors().allocateNodeLabelIndexCursor();
            Assertions.assertEquals((Object)c1, (Object)c2);
            c2.close();
        }
    }

    @Test
    void shouldReuseRelationshipIndexCursors() throws Exception {
        IndexDescriptor index;
        int name;
        int connection;
        String indexName = "myIndex";
        try (KernelTransaction tx = this.beginTransaction();){
            connection = tx.tokenWrite().relationshipTypeGetOrCreateForName("Connection");
            name = tx.tokenWrite().propertyKeyGetOrCreateForName("name");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])this.array(connection), (int[])this.array(name));
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withName(indexName).withIndexType(IndexType.FULLTEXT);
            index = tx.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Predicates.awaitEx(() -> this.tx.schemaRead().indexGetState(index) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        RelationshipIndexCursor c1 = this.cursors.allocateRelationshipIndexCursor();
        this.read.relationshipIndexSeek(index, c1, new IndexQuery[]{IndexQuery.fulltextSearch((String)"hello")});
        c1.close();
        RelationshipIndexCursor c2 = this.cursors.allocateRelationshipIndexCursor();
        Assertions.assertEquals((Object)c1, (Object)c2);
        c2.close();
    }

    private int[] array(int ... elements) {
        return elements;
    }

    private long createNodeWithProperty(Transaction tx, String propertyKey, Object value) {
        Node p = tx.createNode();
        p.setProperty(propertyKey, value);
        return p.getId();
    }
}

