/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.ManagedTestCursors;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ResourceLock(value="sharedContext")
public abstract class KernelAPIReadTestBase<ReadSupport extends KernelAPIReadTestSupport> {
    protected static KernelAPIReadTestSupport testSupport;
    protected KernelTransaction tx;
    protected Read read;
    protected SchemaRead schemaRead;
    protected Token token;
    protected ManagedTestCursors cursors;
    @Inject
    private TestDirectory testDirectory;

    @AfterEach
    public void closeTransaction() throws Exception {
        this.tx.commit();
        this.cursors.assertAllClosedAndReset();
    }

    @AfterAll
    public static void tearDown() {
        if (testSupport != null) {
            testSupport.tearDown();
            testSupport = null;
        }
    }

    public abstract ReadSupport newTestSupport();

    public abstract void createTestGraph(GraphDatabaseService var1);

    public void createSystemGraph(GraphDatabaseService graphDb) {
    }

    @BeforeEach
    public void setupGraph() throws KernelException {
        if (testSupport == null) {
            testSupport = this.newTestSupport();
            testSupport.setup(this.testDirectory.homeDir(), this::createTestGraph, this::createSystemGraph);
        }
        this.changeUser(LoginContext.AUTH_DISABLED);
    }

    protected void changeUser(LoginContext loginContext) throws KernelException {
        Kernel kernel = testSupport.kernelToTest();
        this.tx = KernelAPIReadTestBase.beginTransaction(kernel, loginContext);
        this.token = this.tx.token();
        this.read = this.tx.dataRead();
        this.schemaRead = this.tx.schemaRead();
        this.cursors = new ManagedTestCursors(this.tx.cursors());
    }

    protected KernelTransaction beginTransaction() throws TransactionFailureException {
        Kernel kernel = testSupport.kernelToTest();
        return KernelAPIReadTestBase.beginTransaction(kernel, LoginContext.AUTH_DISABLED);
    }

    protected KernelTransaction beginTransaction(LoginContext loginContext) throws TransactionFailureException {
        Kernel kernel = testSupport.kernelToTest();
        return KernelAPIReadTestBase.beginTransaction(kernel, loginContext);
    }

    private static KernelTransaction beginTransaction(Kernel kernel, LoginContext loginContext) throws TransactionFailureException {
        return kernel.beginTransaction(KernelTransaction.Type.implicit, loginContext);
    }
}

