/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.collector.Collectors2;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NodeIndexTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private final String indexName = "myIndex";

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringSuffixSearch(boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "1suff"));
            this.nodeWithProp(tx, "pluff");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "2suff"));
            this.nodeWithPropId(tx, "skruff");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "pasuff", new IndexQuery[]{IndexQuery.stringSuffix((int)prop, (TextValue)Values.stringValue((String)"suff"))});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformScan(boolean needsValues) throws Exception {
        long nodeToChange;
        long nodeToDelete;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "suff1"));
            expected.add(this.nodeWithProp(tx, "supp"));
            nodeToDelete = this.nodeWithPropId(tx, "supp");
            nodeToChange = this.nodeWithPropId(tx, "supper");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "suff2"));
            tx.dataWrite().nodeDelete(nodeToDelete);
            tx.dataWrite().nodeRemoveProperty(nodeToChange, prop);
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertNodeAndValueForScan(expected, tx, index, false, "noff");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldPerformEqualitySeek() throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "banana"));
            this.nodeWithProp(tx, "apple");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "banana"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertNodeAndValueForSeek(expected, tx, index, false, "banana", new IndexQuery[]{IndexQuery.exact((int)prop, (Object)"banana")});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringPrefixSearch(boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "suff1"));
            this.nodeWithPropId(tx, "supp");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "suff2"));
            this.nodeWithPropId(tx, "skruff");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "suffpa", new IndexQuery[]{IndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"suff"))});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringRangeSearch(boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "banana"));
            this.nodeWithProp(tx, "apple");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringRangeSearchWithAddedNodeInTxState(boolean needsValues) throws Exception {
        long nodeToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "banana"));
            nodeToChange = this.nodeWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            TextValue newProperty = Values.stringValue((String)"blueberry");
            tx.dataWrite().nodeSetProperty(nodeToChange, prop, (Value)newProperty);
            expected.add(Pair.of((Object)nodeToChange, (Object)newProperty));
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringRangeSearchWithRemovedNodeInTxState(boolean needsValues) throws Exception {
        long nodeToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            nodeToChange = this.nodeWithPropId(tx, "banana");
            this.nodeWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            TextValue newProperty = Values.stringValue((String)"kiwi");
            tx.dataWrite().nodeSetProperty(nodeToChange, prop, (Value)newProperty);
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringRangeSearchWithDeletedNodeInTxState(boolean needsValues) throws Exception {
        long nodeToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            nodeToChange = this.nodeWithPropId(tx, "banana");
            this.nodeWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "cherry"));
            this.nodeWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            tx.dataWrite().nodeDelete(nodeToChange);
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "berry", new IndexQuery[]{IndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldPerformStringContainsSearch(boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = this.beginTransaction();){
            expected.add(this.nodeWithProp(tx, "gnomebat"));
            this.nodeWithPropId(tx, "fishwombat");
            tx.commit();
        }
        this.createIndex();
        tx = this.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey("prop");
            expected.add(this.nodeWithProp(tx, "homeopatic"));
            this.nodeWithPropId(tx, "telephonecompany");
            IndexDescriptor index = tx.schemaRead().indexGetForName("myIndex");
            this.assertNodeAndValueForSeek(expected, tx, index, needsValues, "immense", new IndexQuery[]{IndexQuery.stringContains((int)prop, (TextValue)Values.stringValue((String)"me"))});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowIfTransactionTerminated() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            this.terminate(tx);
            Assertions.assertThrows(TransactionTerminatedException.class, () -> tx.dataRead().nodeExists(42L));
        }
    }

    protected abstract void terminate(KernelTransaction var1);

    private long nodeWithPropId(KernelTransaction tx, Object value) throws Exception {
        return (Long)this.nodeWithProp(tx, value).first();
    }

    private Pair<Long, Value> nodeWithProp(KernelTransaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName("Node"));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }

    private void createIndex() {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertNodeAndValueForSeek(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery, IndexQuery ... queries) throws Exception {
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor();){
            IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
            tx.dataRead().nodeIndexSeek(indexSession, nodes, IndexOrder.NONE, needsValues, queries);
            this.assertNodeAndValue(expected, tx, needsValues, anotherValueFoundByQuery, nodes);
        }
    }

    private void assertNodeAndValueForScan(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery) throws Exception {
        IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor();){
            tx.dataRead().nodeIndexScan(indexSession, nodes, IndexOrder.NONE, needsValues);
            this.assertNodeAndValue(expected, tx, needsValues, anotherValueFoundByQuery, nodes);
        }
    }

    private void assertNodeAndValue(Set<Pair<Long, Value>> expected, KernelTransaction tx, boolean needsValues, Object anotherValueFoundByQuery, NodeValueIndexCursor nodes) throws Exception {
        for (Pair<Long, Value> pair : expected) {
            tx.dataWrite().nodeDelete(((Long)pair.first()).longValue());
        }
        this.nodeWithPropId(tx, anotherValueFoundByQuery);
        if (needsValues) {
            HashSet<Pair> found = new HashSet<Pair>();
            while (nodes.next()) {
                found.add(Pair.of((Object)nodes.nodeReference(), (Object)nodes.propertyValue(0)));
            }
            MatcherAssert.assertThat(found, (Matcher)CoreMatchers.equalTo(expected));
        } else {
            HashSet<Long> foundIds = new HashSet<Long>();
            while (nodes.next()) {
                foundIds.add(nodes.nodeReference());
            }
            ImmutableSet expectedIds = (ImmutableSet)expected.stream().map(Pair::first).collect(Collectors2.toImmutableSet());
            MatcherAssert.assertThat(foundIds, (Matcher)CoreMatchers.equalTo((Object)expectedIds));
        }
    }
}

