/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.TestAccessMode;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class NodeTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    void shouldSeeNodeInTransaction() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                Assertions.assertEquals((long)nodeId, (long)node.nodeReference());
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            Assertions.assertEquals((long)nodeId, (long)tx.getNodeById(nodeId).getId());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeNewLabeledNodeInTransaction() throws Exception {
        long nodeId;
        String labelName = "Town";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.token().labelGetOrCreateForName("Town");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                LabelSet labels = node.labels();
                Assertions.assertEquals((int)1, (int)labels.numberOfLabels());
                Assertions.assertEquals((int)labelId, (int)labels.label(0));
                Assertions.assertTrue((boolean)node.hasLabel(labelId));
                Assertions.assertFalse((boolean)node.hasLabel(labelId + 1));
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getLabels(), (Matcher)Matchers.equalTo((Object)Iterables.iterable((Object[])new Object[]{Label.label((String)"Town")})));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeLabelChangesInTransaction() throws Exception {
        int toDelete;
        int toRetain;
        long nodeId;
        String toRetainName = "ToRetain";
        String toDeleteName = "ToDelete";
        String toAddName = "ToAdd";
        String toRegretName = "ToRegret";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            toRetain = tx.token().labelGetOrCreateForName("ToRetain");
            toDelete = tx.token().labelGetOrCreateForName("ToDelete");
            tx.dataWrite().nodeAddLabel(nodeId, toRetain);
            tx.dataWrite().nodeAddLabel(nodeId, toDelete);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)"ToRetain"), Label.label((String)"ToDelete")}));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            int toAdd = tx.token().labelGetOrCreateForName("ToAdd");
            tx.dataWrite().nodeAddLabel(nodeId, toAdd);
            tx.dataWrite().nodeRemoveLabel(nodeId, toDelete);
            int toRegret = tx.token().labelGetOrCreateForName("ToRegret");
            tx.dataWrite().nodeAddLabel(nodeId, toRegret);
            tx.dataWrite().nodeRemoveLabel(nodeId, toRegret);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                this.assertLabels(node.labels(), toRetain, toAdd);
                Assertions.assertTrue((boolean)node.hasLabel(toAdd));
                Assertions.assertTrue((boolean)node.hasLabel(toRetain));
                Assertions.assertFalse((boolean)node.hasLabel(toDelete));
                Assertions.assertFalse((boolean)node.hasLabel(toRegret));
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)"ToRetain"), Label.label((String)"ToAdd")}));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDiscoverDeletedNodeInTransaction() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertTrue((boolean)tx.dataWrite().nodeDelete(nodeId));
            try (NodeCursor node = tx.cursors().allocateNodeCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertFalse((boolean)node.next());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleMultipleNodeDeletions() throws Exception {
        long nodeId;
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertTrue((boolean)tx.dataWrite().nodeDelete(nodeId));
            Assertions.assertFalse((boolean)tx.dataWrite().nodeDelete(nodeId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeNewNodePropertyInTransaction() throws Exception {
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (KernelTransaction tx = this.beginTransaction();){
            long nodeId = tx.dataWrite().nodeCreate();
            int prop1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            int prop2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, prop1, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, prop2, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)prop1, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)prop2, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assertions.assertFalse((boolean)property.next(), (String)"should only find two properties");
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
    }

    @Test
    void shouldSeeAddedPropertyFromExistingNodeWithoutPropertiesInTransaction() throws Exception {
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assertions.assertFalse((boolean)property.next(), (String)"should only find one properties");
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"hello"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeAddedPropertyFromExistingNodeWithPropertiesInTransaction() throws Exception {
        int propToken1;
        long nodeId;
        String propKey1 = "prop1";
        String propKey2 = "prop2";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken1 = tx.token().propertyKeyGetOrCreateForName(propKey1);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken1, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            int propToken2 = tx.token().propertyKeyGetOrCreateForName(propKey2);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken2, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)propToken2, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)propToken1, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"hello"));
                Assertions.assertFalse((boolean)property.next(), (String)"should only find two properties");
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey1), (Matcher)Matchers.equalTo((Object)"hello"));
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey2), (Matcher)Matchers.equalTo((Object)"world"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeUpdatedPropertyFromExistingNodeWithPropertiesInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.stringValue((String)"hello"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assertions.assertFalse((boolean)property.next(), (String)"should only find one property");
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"world"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeRemovedPropertyInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertEquals((Object)tx.dataWrite().nodeRemoveProperty(nodeId, propToken), (Object)Values.stringValue((String)"hello"));
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                Assertions.assertFalse((boolean)property.next(), (String)"should not find any properties");
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            Assertions.assertFalse((boolean)tx.getNodeById(nodeId).hasProperty(propKey));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeRemovedThenAddedPropertyInTransaction() throws Exception {
        int propToken;
        long nodeId;
        String propKey = "prop1";
        try (KernelTransaction tx = this.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            propToken = tx.token().propertyKeyGetOrCreateForName(propKey);
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"hello")), (Object)Values.NO_VALUE);
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertEquals((Object)tx.dataWrite().nodeRemoveProperty(nodeId, propToken), (Object)Values.stringValue((String)"hello"));
            Assertions.assertEquals((Object)tx.dataWrite().nodeSetProperty(nodeId, propToken, (Value)Values.stringValue((String)"world")), (Object)Values.NO_VALUE);
            try (NodeCursor node = tx.cursors().allocateNodeCursor();
                 PropertyCursor property = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(nodeId, node);
                Assertions.assertTrue((boolean)node.next(), (String)"should access node");
                node.properties(property);
                Assertions.assertTrue((boolean)property.next());
                Assertions.assertEquals((int)propToken, (int)property.propertyKey());
                Assertions.assertEquals((Object)property.propertyValue(), (Object)Values.stringValue((String)"world"));
                Assertions.assertFalse((boolean)property.next(), (String)"should not find any properties");
                Assertions.assertFalse((boolean)node.next(), (String)"should only find one node");
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            MatcherAssert.assertThat((Object)tx.getNodeById(nodeId).getProperty(propKey), (Matcher)Matchers.equalTo((Object)"world"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldSeeExistingNode() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            Assertions.assertTrue((boolean)tx.dataRead().nodeExists(node));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotSeeNonExistingNode() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            Assertions.assertFalse((boolean)tx.dataRead().nodeExists(1337L));
        }
    }

    @Test
    void shouldSeeNodeExistingInTxOnly() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            Assertions.assertTrue((boolean)tx.dataRead().nodeExists(node));
        }
    }

    @Test
    void shouldNotSeeDeletedNode() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(node);
            Assertions.assertFalse((boolean)tx.dataRead().nodeExists(node));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotFindDeletedNodeInLabelScan() throws Exception {
        Node node = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeDelete(node.node);
            tx.dataRead().nodeLabelScan(node.labels[0], cursor);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldNotFindNodeWithRemovedLabelInLabelScan() throws Exception {
        Node node = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node.node, node.labels[0]);
            tx.dataRead().nodeLabelScan(node.labels[0], cursor);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    @Test
    void shouldFindUpdatedNodeInInLabelScan() throws Exception {
        Node node = this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            int label = tx.tokenWrite().labelGetOrCreateForName("label");
            tx.dataWrite().nodeAddLabel(node.node, label);
            tx.dataRead().nodeLabelScan(label, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertEquals((long)node.node, (long)cursor.nodeReference());
        }
    }

    @Test
    void shouldFindSwappedNodeInLabelScan() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
            tx.dataWrite().nodeRemoveLabel(node1.node, node1.labels[0]);
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            tx.dataRead().nodeLabelScan(node1.labels[0], cursor);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertEquals((long)node2.node, (long)cursor.nodeReference());
        }
    }

    @Test
    void shouldCountNewLabelsFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assertions.assertEquals((long)2L, (long)countTxState);
            Assertions.assertEquals((long)1L, (long)countNoTxState);
        }
    }

    @Test
    void shouldCountNewNodesFromTxState() throws Exception {
        this.createNode(new String[0]);
        this.createNode(new String[0]);
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeCreate();
            long countTxState = tx.dataRead().countsForNode(-1);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(-1);
            Assertions.assertEquals((long)3L, (long)countTxState);
            Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedLabelsFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeRemoveLabel(node2.node, node2.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assertions.assertEquals((long)1L, (long)countTxState);
            Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedNodesFromTxState() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        try (KernelTransaction tx = this.beginTransaction();){
            tx.dataWrite().nodeDelete(node2.node);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assertions.assertEquals((long)1L, (long)countTxState);
            Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldCountNewLabelsFromTxStateRestrictedUser() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode(new String[0]);
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false));
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeAddLabel(node2.node, node1.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assertions.assertEquals((long)2L, (long)countTxState);
            Assertions.assertEquals((long)1L, (long)countNoTxState);
        }
    }

    @Test
    void shouldCountNewNodesFromTxStateRestrictedUser() throws Exception {
        this.createNode(new String[0]);
        this.createNode(new String[0]);
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false));
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeCreate();
            long countTxState = tx.dataRead().countsForNode(-1);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(-1);
            Assertions.assertEquals((long)3L, (long)countTxState);
            Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedLabelsFromTxStateRestrictedUser() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false));
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeRemoveLabel(node2.node, node2.labels[0]);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assertions.assertEquals((long)1L, (long)countTxState);
            Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void shouldNotCountRemovedNodesFromTxStateRestrictedUser() throws Exception {
        Node node1 = this.createNode("label");
        Node node2 = this.createNode("label");
        SecurityContext loginContext = new SecurityContext(AuthSubject.AUTH_DISABLED, (AccessMode)new TestAccessMode(true, false, true, false));
        try (KernelTransaction tx = this.beginTransaction((LoginContext)loginContext);){
            tx.dataWrite().nodeDelete(node2.node);
            long countTxState = tx.dataRead().countsForNode(node1.labels[0]);
            long countNoTxState = tx.dataRead().countsForNodeWithoutTxState(node1.labels[0]);
            Assertions.assertEquals((long)1L, (long)countTxState);
            Assertions.assertEquals((long)2L, (long)countNoTxState);
        }
    }

    @Test
    void hasPropertiesShouldSeeNewlyCreatedProperties() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor cursor = tx.cursors().allocateNodeCursor();
             PropertyCursor props = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertFalse((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
            Assertions.assertTrue((boolean)this.hasProperties(cursor, props));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private boolean hasProperties(NodeCursor cursor, PropertyCursor props) {
        cursor.properties(props);
        return props.next();
    }

    @Test
    void hasPropertiesShouldSeeNewlyCreatedPropertiesOnNewlyCreatedNode() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            long node = tx.dataWrite().nodeCreate();
            try (NodeCursor cursor = tx.cursors().allocateNodeCursor();
                 PropertyCursor props = tx.cursors().allocatePropertyCursor();){
                tx.dataRead().singleNode(node, cursor);
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertFalse((boolean)this.hasProperties(cursor, props));
                tx.dataWrite().nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), (Value)Values.stringValue((String)"foo"));
                Assertions.assertTrue((boolean)this.hasProperties(cursor, props));
            }
        }
    }

    @Test
    void hasPropertiesShouldSeeNewlyRemovedProperties() throws Exception {
        int prop3;
        int prop2;
        int prop1;
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            prop3 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop3");
            tx.dataWrite().nodeSetProperty(node, prop1, (Value)Values.longValue((long)1L));
            tx.dataWrite().nodeSetProperty(node, prop2, (Value)Values.longValue((long)2L));
            tx.dataWrite().nodeSetProperty(node, prop3, (Value)Values.longValue((long)3L));
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor cursor = tx.cursors().allocateNodeCursor();
             PropertyCursor props = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertTrue((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop1);
            Assertions.assertTrue((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop2);
            Assertions.assertTrue((boolean)this.hasProperties(cursor, props));
            tx.dataWrite().nodeRemoveProperty(node, prop3);
            Assertions.assertFalse((boolean)this.hasProperties(cursor, props));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void propertyTypeShouldBeTxStateAware() throws Exception {
        long node;
        try (KernelTransaction tx = this.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.commit();
        }
        tx = this.beginTransaction();
        try (NodeCursor nodes = tx.cursors().allocateNodeCursor();
             PropertyCursor properties = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, nodes);
            Assertions.assertTrue((boolean)nodes.next());
            Assertions.assertFalse((boolean)this.hasProperties(nodes, properties));
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(node, prop, (Value)Values.stringValue((String)"foo"));
            nodes.properties(properties);
            Assertions.assertTrue((boolean)properties.next());
            MatcherAssert.assertThat((Object)properties.propertyType(), (Matcher)Matchers.equalTo((Object)ValueGroup.TEXT));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void assertLabels(LabelSet labels, int ... expected) {
        Assertions.assertEquals((int)expected.length, (int)labels.numberOfLabels());
        Arrays.sort(expected);
        int[] labelArray = new int[labels.numberOfLabels()];
        for (int i = 0; i < labels.numberOfLabels(); ++i) {
            labelArray[i] = labels.label(i);
        }
        Arrays.sort(labelArray);
        Assertions.assertTrue((boolean)Arrays.equals(expected, labelArray), (String)"labels match expected");
    }

    public Node createNode(String ... labels) throws Exception {
        long node;
        int[] labelIds = new int[labels.length];
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            node = write.nodeCreate();
            for (int i = 0; i < labels.length; ++i) {
                labelIds[i] = tx.tokenWrite().labelGetOrCreateForName(labels[i]);
                write.nodeAddLabel(node, labelIds[i]);
            }
            tx.commit();
        }
        return new Node(node, labelIds);
    }

    private static class Node {
        private final long node;
        private final int[] labels;

        private Node(long node, int[] labels) {
            this.node = node;
            this.labels = labels;
        }

        public long node() {
            return this.node;
        }

        public int[] labels() {
            return this.labels;
        }
    }
}

