/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;

public abstract class ParallelNodeLabelScanTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final ToLongFunction<NodeLabelIndexCursor> NODE_GET = NodeIndexCursor::nodeReference;

    @Test
    void shouldHandleEmptyDatabase() throws KernelException {
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                while (scan.reserveBatch((Cursor)cursor, 23)) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    @Test
    void scanShouldNotSeeDeletedNode() throws Exception {
        Object write;
        int size = 1000;
        HashSet<Long> created = new HashSet<Long>(size);
        HashSet<Long> deleted = new HashSet<Long>(size);
        int label = this.label("L");
        try (KernelTransaction tx = this.beginTransaction();){
            write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                long createId = write.nodeCreate();
                long deleteId = write.nodeCreate();
                write.nodeAddLabel(createId, label);
                write.nodeAddLabel(deleteId, label);
                created.add(createId);
                deleted.add(deleteId);
            }
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            write = deleted.iterator();
            while (write.hasNext()) {
                long delete = (Long)write.next();
                tx.dataWrite().nodeDelete(delete);
            }
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                HashSet<Long> seen = new HashSet<Long>();
                while (scan.reserveBatch((Cursor)cursor, 128)) {
                    while (cursor.next()) {
                        long nodeId = cursor.nodeReference();
                        Assertions.assertTrue((boolean)seen.add(nodeId));
                        Assertions.assertTrue((boolean)created.remove(nodeId));
                    }
                }
                Assertions.assertTrue((boolean)created.isEmpty());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void scanShouldSeeAddedNodes() throws Exception {
        int size = 64;
        int label = this.label("L");
        MutableLongSet existing = LongSets.mutable.withAll((LongIterable)this.createNodesWithLabel(label, size));
        try (KernelTransaction tx = this.beginTransaction();){
            MutableLongSet added = LongSets.mutable.withAll((LongIterable)this.createNodesWithLabel(tx.dataWrite(), label, size));
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                HashSet<Long> seen = new HashSet<Long>();
                while (scan.reserveBatch((Cursor)cursor, 64)) {
                    while (cursor.next()) {
                        long nodeId = cursor.nodeReference();
                        Assertions.assertTrue((boolean)seen.add(nodeId), (String)String.format("%d was seen multiple times", nodeId));
                        Assertions.assertTrue((existing.remove(nodeId) || added.remove(nodeId) ? 1 : 0) != 0);
                    }
                }
                Assertions.assertTrue((boolean)existing.isEmpty());
                Assertions.assertTrue((boolean)added.isEmpty());
            }
        }
    }

    @Test
    void shouldReserveBatchFromTxState() throws KernelException {
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            this.createNodesWithLabel(tx.dataWrite(), label, 11);
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor();){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 5));
                Assertions.assertEquals((int)5, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 4));
                Assertions.assertEquals((int)4, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 6));
                Assertions.assertEquals((int)2, (int)TestUtils.count((Cursor)cursor));
                while (scan.reserveBatch((Cursor)cursor, 3)) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException, KernelException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        int size = 1024;
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            LongList ids = this.createNodesWithLabel(tx.dataWrite(), label, size);
            Read read = tx.dataRead();
            Scan scan = read.nodeLabelScan(label);
            Supplier<NodeLabelIndexCursor> allocateCursor = () -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor();
            Future<LongList> future1 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, size / 4));
            Future<LongList> future2 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, size / 4));
            Future<LongList> future3 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, size / 4));
            Future<LongList> future4 = service.submit(TestUtils.singleBatchWorker(scan, allocateCursor, NODE_GET, size / 4));
            LongList ids1 = future1.get();
            LongList ids2 = future2.get();
            LongList ids3 = future3.get();
            LongList ids4 = future4.get();
            TestUtils.assertDistinct(ids1, ids2, ids3, ids4);
            LongList concat = TestUtils.concat(ids1, ids2, ids3, ids4);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromRandomlySizedWorkers() throws InterruptedException, KernelException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        int size = 2000;
        try (KernelTransaction tx = this.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            LongList ids = this.createNodesWithLabel(tx.dataWrite(), label, size);
            Read read = tx.dataRead();
            Scan scan = read.nodeLabelScan(label);
            CursorFactory cursors = testSupport.kernelToTest().cursors();
            ArrayList<Future<LongList>> futures = new ArrayList<Future<LongList>>();
            for (int i = 0; i < 10; ++i) {
                futures.add(service.submit(TestUtils.randomBatchWorker(scan, () -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(), NODE_GET)));
            }
            List<LongList> lists = futures.stream().map(TestUtils::unsafeGet).collect(Collectors.toList());
            TestUtils.assertDistinct(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)TestUtils.concat(lists).toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void parallelTxStateScanStressTest() throws KernelException, InterruptedException {
        int label = this.label("L");
        MutableLongSet existingNodes = LongSets.mutable.withAll((LongIterable)this.createNodesWithLabel(label, 1000));
        int workers = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(workers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                MutableLongSet allNodes = LongSets.mutable.withAll((LongIterable)existingNodes);
                try (KernelTransaction tx = this.beginTransaction();){
                    int nodeInTx = random.nextInt(1000);
                    allNodes.addAll((LongIterable)this.createNodesWithLabel(tx.dataWrite(), label, nodeInTx));
                    Scan scan = tx.dataRead().nodeLabelScan(label);
                    ArrayList<Future<LongList>> futures = new ArrayList<Future<LongList>>(workers);
                    for (int j = 0; j < workers; ++j) {
                        futures.add(threadPool.submit(TestUtils.randomBatchWorker(scan, () -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(), NODE_GET)));
                    }
                    List<LongList> lists = futures.stream().map(TestUtils::unsafeGet).collect(Collectors.toList());
                    TestUtils.assertDistinct(lists);
                    LongList concat = TestUtils.concat(lists);
                    Assertions.assertEquals((Object)allNodes, (Object)LongSets.immutable.withAll((LongIterable)concat), (String)String.format("nodes=%d, seen=%d, all=%d", nodeInTx, concat.size(), allNodes.size()));
                    Assertions.assertEquals((int)allNodes.size(), (int)concat.size(), (String)String.format("nodes=%d", nodeInTx));
                    tx.rollback();
                    continue;
                }
            }
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private LongList createNodesWithLabel(int label, int size) throws KernelException {
        LongList ids;
        try (KernelTransaction tx = this.beginTransaction();){
            Write write = tx.dataWrite();
            ids = this.createNodesWithLabel(write, label, size);
            tx.commit();
        }
        return ids;
    }

    private LongList createNodesWithLabel(Write write, int label, int size) throws KernelException {
        MutableLongList ids = LongLists.mutable.empty();
        for (int i = 0; i < size; ++i) {
            long node = write.nodeCreate();
            write.nodeAddLabel(node, label);
            ids.add(node);
        }
        return ids;
    }

    private int label(String name) throws KernelException {
        int label;
        try (KernelTransaction tx = this.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName(name);
            tx.commit();
        }
        return label;
    }
}

