/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.RelationshipTestSupport;

public abstract class RelationshipTraversalCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long bare;
    private static long start;
    private static long end;
    private static RelationshipTestSupport.StartNode sparse;
    private static RelationshipTestSupport.StartNode dense;

    private boolean supportsDirectTraversal() {
        return true;
    }

    private boolean supportsSparseNodes() {
        return true;
    }

    private static void bareStartAndEnd(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            bare = tx.createNode().getId();
            Node x = tx.createNode();
            Node y = tx.createNode();
            start = x.getId();
            end = y.getId();
            x.createRelationshipTo(y, RelationshipType.withName((String)"GEN"));
            tx.commit();
        }
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        RelationshipTestSupport.someGraph(graphDb);
        RelationshipTraversalCursorTestBase.bareStartAndEnd(graphDb);
        sparse = RelationshipTestSupport.sparse(graphDb);
        dense = RelationshipTestSupport.dense(graphDb);
    }

    @Test
    void shouldNotAccessGroupsOfBareNode() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();){
            this.read.singleNode(bare, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access node");
            node.relationships(group);
            Assertions.assertFalse((boolean)group.next(), (String)"access group");
        }
    }

    @Test
    void shouldTraverseRelationshipsOfGivenType() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            int empty = 0;
            this.read.allNodesScan(node);
            while (node.next()) {
                node.relationships(group);
                boolean none = true;
                while (group.next()) {
                    none = false;
                    Sizes degree = new Sizes();
                    group.outgoing(relationship);
                    while (relationship.next()) {
                        Assertions.assertEquals((int)group.type(), (int)relationship.type(), (String)("node #" + node.nodeReference() + " relationship should have same label as group"));
                        ++degree.outgoing;
                    }
                    group.incoming(relationship);
                    while (relationship.next()) {
                        Assertions.assertEquals((int)group.type(), (int)relationship.type(), (String)("node #" + node.nodeReference() + "relationship should have same label as group"));
                        ++degree.incoming;
                    }
                    group.loops(relationship);
                    while (relationship.next()) {
                        Assertions.assertEquals((int)group.type(), (int)relationship.type(), (String)("node #" + node.nodeReference() + "relationship should have same label as group"));
                        ++degree.loop;
                    }
                    Assertions.assertNotEquals((int)0, (int)(degree.incoming + degree.outgoing + degree.loop), (String)"all");
                    Assertions.assertEquals((int)group.outgoingCount(), (int)degree.outgoing, (String)("node #" + node.nodeReference() + " outgoing"));
                    Assertions.assertEquals((int)group.incomingCount(), (int)degree.incoming, (String)("node #" + node.nodeReference() + " incoming"));
                    Assertions.assertEquals((int)group.loopCount(), (int)degree.loop, (String)("node #" + node.nodeReference() + " loop"));
                    Assertions.assertEquals((int)group.totalCount(), (int)(degree.incoming + degree.outgoing + degree.loop), (String)("node #" + node.nodeReference() + " all = incoming + outgoing - loop"));
                }
                if (!none) continue;
                ++empty;
            }
            Assertions.assertEquals((int)1, (int)empty, (String)"number of empty nodes");
        }
    }

    @Test
    void shouldFollowSpecificRelationship() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            this.read.singleNode(start, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access start node");
            node.relationships(group);
            Assertions.assertTrue((boolean)group.next(), (String)"access relationship group");
            group.outgoing(relationship);
            Assertions.assertTrue((boolean)relationship.next(), (String)"access outgoing relationships");
            Assertions.assertEquals((long)start, (long)relationship.sourceNodeReference(), (String)"source node");
            Assertions.assertEquals((long)end, (long)relationship.targetNodeReference(), (String)"target node");
            Assertions.assertEquals((long)start, (long)relationship.originNodeReference(), (String)"node of origin");
            Assertions.assertEquals((long)end, (long)relationship.neighbourNodeReference(), (String)"neighbouring node");
            Assertions.assertEquals((int)group.type(), (int)relationship.type(), (String)"relationship should have same label as group");
            Assertions.assertFalse((boolean)relationship.next(), (String)"only a single relationship");
            group.incoming(relationship);
            Assertions.assertFalse((boolean)relationship.next(), (String)"no incoming relationships");
            group.loops(relationship);
            Assertions.assertFalse((boolean)relationship.next(), (String)"no loop relationships");
            Assertions.assertFalse((boolean)group.next(), (String)"only a single group");
            this.read.singleNode(end, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access start node");
            node.relationships(group);
            Assertions.assertTrue((boolean)group.next(), (String)"access relationship group");
            group.incoming(relationship);
            Assertions.assertTrue((boolean)relationship.next(), (String)"access incoming relationships");
            Assertions.assertEquals((long)start, (long)relationship.sourceNodeReference(), (String)"source node");
            Assertions.assertEquals((long)end, (long)relationship.targetNodeReference(), (String)"target node");
            Assertions.assertEquals((long)end, (long)relationship.originNodeReference(), (String)"node of origin");
            Assertions.assertEquals((long)start, (long)relationship.neighbourNodeReference(), (String)"neighbouring node");
            Assertions.assertEquals((int)group.type(), (int)relationship.type(), (String)"relationship should have same label as group");
            Assertions.assertFalse((boolean)relationship.next(), (String)"only a single relationship");
            group.outgoing(relationship);
            Assertions.assertFalse((boolean)relationship.next(), (String)"no outgoing relationships");
            group.loops(relationship);
            Assertions.assertFalse((boolean)relationship.next(), (String)"no loop relationships");
            Assertions.assertFalse((boolean)group.next(), (String)"only a single group");
        }
    }

    @Test
    void shouldHaveBeenAbleToCreateDenseAndSparseNodes() {
        try (NodeCursor node = this.cursors.allocateNodeCursor();){
            this.read.singleNode(RelationshipTraversalCursorTestBase.dense.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access dense node");
            Assertions.assertTrue((boolean)node.isDense(), (String)"dense node");
            this.read.singleNode(RelationshipTraversalCursorTestBase.sparse.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access sparse node");
            Assertions.assertFalse((node.isDense() && this.supportsSparseNodes() ? 1 : 0) != 0, (String)"sparse node");
        }
    }

    @Test
    void shouldTraverseSparseNodeViaGroups() throws Exception {
        this.traverseViaGroups(sparse, false);
    }

    @Test
    void shouldTraverseDenseNodeViaGroups() throws Exception {
        this.traverseViaGroups(dense, false);
    }

    @Test
    void shouldTraverseSparseNodeViaGroupsWithDetachedReferences() throws Exception {
        this.traverseViaGroups(sparse, true);
    }

    @Test
    void shouldTraverseDenseNodeViaGroupsWithDetachedReferences() throws Exception {
        this.traverseViaGroups(dense, true);
    }

    @Test
    void shouldTraverseSparseNodeWithoutGroups() throws Exception {
        Assumptions.assumeTrue((this.supportsSparseNodes() && this.supportsDirectTraversal() ? 1 : 0) != 0);
        this.traverseWithoutGroups(sparse, false);
    }

    @Test
    void shouldTraverseDenseNodeWithoutGroups() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsDirectTraversal());
        this.traverseWithoutGroups(dense, false);
    }

    @Test
    void shouldTraverseSparseNodeWithoutGroupsWithDetachedReferences() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsSparseNodes());
        this.traverseWithoutGroups(sparse, true);
    }

    @Test
    void shouldTraverseDenseNodeWithoutGroupsWithDetachedReferences() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsDirectTraversal());
        this.traverseWithoutGroups(dense, true);
    }

    private void traverseViaGroups(RelationshipTestSupport.StartNode start, boolean detached) throws KernelException {
        Map<String, Integer> expectedCounts = start.expectedCounts();
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipGroupCursor group = this.cursors.allocateRelationshipGroupCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            this.read.singleNode(start.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access node");
            if (detached) {
                this.read.relationshipGroups(start.id, node.relationshipGroupReference(), group);
            } else {
                node.relationships(group);
            }
            while (group.next()) {
                if (detached) {
                    this.read.relationships(start.id, group.outgoingReference(), relationship);
                } else {
                    group.outgoing(relationship);
                }
                RelationshipTestSupport.assertCount(this.tx, relationship, expectedCounts, group.type(), Direction.OUTGOING);
                if (detached) {
                    this.read.relationships(start.id, group.incomingReference(), relationship);
                } else {
                    group.incoming(relationship);
                }
                RelationshipTestSupport.assertCount(this.tx, relationship, expectedCounts, group.type(), Direction.INCOMING);
                if (detached) {
                    this.read.relationships(start.id, group.loopsReference(), relationship);
                } else {
                    group.loops(relationship);
                }
                RelationshipTestSupport.assertCount(this.tx, relationship, expectedCounts, group.type(), Direction.BOTH);
            }
        }
    }

    private void traverseWithoutGroups(RelationshipTestSupport.StartNode start, boolean detached) throws KernelException {
        try (NodeCursor node = this.cursors.allocateNodeCursor();
             RelationshipTraversalCursor relationship = this.cursors.allocateRelationshipTraversalCursor();){
            this.read.singleNode(start.id, node);
            Assertions.assertTrue((boolean)node.next(), (String)"access node");
            if (detached) {
                this.read.relationships(start.id, node.allRelationshipsReference(), relationship);
            } else {
                node.allRelationships(relationship);
            }
            Map<String, Integer> counts = RelationshipTestSupport.count(this.tx, relationship);
            RelationshipTestSupport.assertCounts(start.expectedCounts(), counts);
        }
    }

    private static class Sizes {
        int incoming;
        int outgoing;
        int loop;

        private Sizes() {
        }
    }
}

