/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;

public abstract class TokenTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    void labelGetOrCreateForName() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForName("")));
        int id = this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.labelGetOrCreateForName("label")));
        Assertions.assertEquals((int)id, (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.nodeLabel("label"))));
    }

    @Test
    void labelGetOrCreateForNames() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForNames(new String[]{null}, new int[1])));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForNames(new String[]{""}, new int[1])));
        String[] names = new String[]{"a", "b"};
        int[] ids = new int[2];
        this.forToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.labelGetOrCreateForNames(names, ids)));
        Assertions.assertEquals((int)ids[0], (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.nodeLabel("a"))));
        Assertions.assertEquals((int)ids[1], (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.nodeLabel("b"))));
    }

    @Test
    void propertyKeyGetOrCreateForName() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForName("")));
        int id = this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKeyGetOrCreateForName("prop")));
        Assertions.assertEquals((int)id, (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKey("prop"))));
    }

    @Test
    void propertyKeyGetOrCreateForNames() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForNames(new String[]{null}, new int[1])));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForNames(new String[]{""}, new int[1])));
        String[] names = new String[]{"a", "b"};
        int[] ids = new int[2];
        this.forToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.propertyKeyGetOrCreateForNames(names, ids)));
        Assertions.assertEquals((int)ids[0], (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKey("a"))));
        Assertions.assertEquals((int)ids[1], (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.propertyKey("b"))));
    }

    @Test
    void relationshipTypeGetOrCreateForName() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForName(null)));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForName("")));
        int id = this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipTypeGetOrCreateForName("rel")));
        Assertions.assertEquals((int)id, (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipType("rel"))));
    }

    @Test
    void relationshipTypeGetOrCreateForNames() {
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForNames(new String[]{null}, new int[1])));
        this.assertIllegalToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForNames(new String[]{""}, new int[1])));
        String[] names = new String[]{"a", "b"};
        int[] ids = new int[2];
        this.forToken((ThrowingConsumer<Token, KernelException>)((ThrowingConsumer)token -> token.relationshipTypeGetOrCreateForNames(names, ids)));
        Assertions.assertEquals((int)ids[0], (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipType("a"))));
        Assertions.assertEquals((int)ids[1], (int)this.mapToken((ThrowingFunction<Token, Integer, KernelException>)((ThrowingFunction)token -> token.relationshipType("b"))));
    }

    private void assertIllegalToken(ThrowingConsumer<Token, KernelException> f) {
        try (KernelTransaction tx2 = this.beginTransaction();){
            f.accept((Object)tx2.token());
            Assertions.fail((String)"Expected IllegalTokenNameException");
        }
        catch (IllegalTokenNameException tx2) {
        }
        catch (KernelException e) {
            Assertions.fail((String)("Unwanted exception: " + e.getMessage()));
        }
    }

    private int mapToken(ThrowingFunction<Token, Integer, KernelException> f) {
        int n;
        block8: {
            KernelTransaction tx = this.beginTransaction();
            try {
                n = (Integer)f.apply((Object)tx.token());
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KernelException e) {
                    Assertions.fail((String)("Unwanted exception: " + e.getMessage()));
                    return -1;
                }
            }
            tx.close();
        }
        return n;
    }

    private void forToken(ThrowingConsumer<Token, KernelException> f) {
        try (KernelTransaction tx = this.beginTransaction();){
            f.accept((Object)tx.token());
        }
        catch (KernelException e) {
            Assertions.fail((String)("Unwanted exception: " + e.getMessage()));
        }
    }
}

