/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.File;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class WriteTestSupport
implements KernelAPIWriteTestSupport {
    private GraphDatabaseService db;
    protected DatabaseManagementService managementService;

    @Override
    public void setup(File storeDir) {
        this.db = this.newDb(storeDir);
        try (KernelTransaction tx = this.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            tokenWrite.propertyKeyCreateForName("DO_NOT_USE", false);
            tokenWrite.labelCreateForName("DO_NOT_USE", false);
            tokenWrite.relationshipTypeCreateForName("DO_NOT_USE", false);
        }
        catch (KernelException e) {
            throw new AssertionError("Failed to setup database", e);
        }
    }

    protected GraphDatabaseService newDb(File storeDir) {
        this.managementService = new TestDatabaseManagementServiceBuilder(storeDir).impermanent().build();
        return this.managementService.database("neo4j");
    }

    @Override
    public void clearGraph() {
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this.db);
    }

    @Override
    public Kernel kernelToTest() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.db).getDependencyResolver();
        return (Kernel)resolver.resolveDependency(Kernel.class);
    }

    private KernelTransaction beginTransaction() throws TransactionFailureException {
        return this.kernelToTest().beginTransaction(KernelTransaction.Type.implicit, LoginContext.AUTH_DISABLED);
    }

    @Override
    public GraphDatabaseService graphBackdoor() {
        return this.db;
    }

    @Override
    public void tearDown() {
        this.managementService.shutdown();
        this.db = null;
    }
}

