/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Values;

@ImpermanentDbmsExtension
class SchemaStorageIT {
    private static final String LABEL1 = "Label1";
    private static final String LABEL2 = "Label2";
    private static final String TYPE1 = "Type1";
    private static final String PROP1 = "prop1";
    private static final String PROP2 = "prop2";
    @Inject
    private GraphDatabaseAPI db;
    private static SchemaStore schemaStore;
    private static SchemaStorage storage;

    SchemaStorageIT() {
    }

    @BeforeEach
    void initStorage() throws Exception {
        try (Transaction transaction = this.db.beginTx();){
            TokenWrite tokenWrite = ((InternalTransaction)transaction).kernelTransaction().tokenWrite();
            tokenWrite.propertyKeyGetOrCreateForName(PROP1);
            tokenWrite.propertyKeyGetOrCreateForName(PROP2);
            tokenWrite.labelGetOrCreateForName(LABEL1);
            tokenWrite.labelGetOrCreateForName(LABEL2);
            tokenWrite.relationshipTypeGetOrCreateForName(TYPE1);
            transaction.commit();
        }
        schemaStore = this.resolveDependency(RecordStorageEngine.class).testAccessNeoStores().getSchemaStore();
        storage = new SchemaStorage(schemaStore, this.resolveDependency(TokenHolders.class));
    }

    @Test
    void shouldReturnIndexRuleForLabelAndProperty() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2), SchemaStorageIT.index(LABEL2, PROP1));
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])storage.indexGetForSchema((SchemaDescriptorSupplier)this.indexDescriptor(LABEL1, PROP2)));
        Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP2, false);
    }

    @Test
    void shouldReturnIndexRuleForLabelAndPropertyComposite() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String f = "f";
        this.createSchema(tx -> tx.schema().indexFor(Label.label((String)LABEL1)).on(a).on(b).on(c).on(d).on(e).on(f).create());
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])storage.indexGetForSchema((SchemaDescriptorSupplier)TestIndexDescriptorFactory.forLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(a), this.propId(b), this.propId(c), this.propId(d), this.propId(e), this.propId(f)})));
        Assertions.assertNotNull((Object)rule);
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(LABEL1)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(a)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(b)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(c)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(d)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(e)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(f)));
        Assertions.assertFalse((boolean)rule.isUnique());
    }

    @Test
    void shouldReturnIndexRuleForLabelAndVeryManyPropertiesComposite() {
        String[] props = "abcdefghijklmnopqrstuvwxyzABCDEFGHJILKMNOPQRSTUVWXYZ".split("\\B");
        this.createSchema(tx -> {
            IndexCreator indexCreator = tx.schema().indexFor(Label.label((String)LABEL1));
            for (String prop : props) {
                indexCreator = indexCreator.on(prop);
            }
            indexCreator.create();
        });
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])storage.indexGetForSchema((SchemaDescriptorSupplier)TestIndexDescriptorFactory.forLabel((int)this.labelId(LABEL1), (int[])Arrays.stream(props).mapToInt(this::propId).toArray())));
        Assertions.assertNotNull((Object)rule);
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(LABEL1)));
        for (String prop : props) {
            Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(prop)));
        }
        Assertions.assertFalse((boolean)rule.isUnique());
    }

    @Test
    void shouldReturnEmptyArrayIfIndexRuleForLabelAndPropertyDoesNotExist() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1));
        IndexDescriptor[] rules = storage.indexGetForSchema((SchemaDescriptorSupplier)this.indexDescriptor(LABEL1, PROP2));
        MatcherAssert.assertThat((Object)rules.length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    void shouldListIndexRulesForLabelPropertyAndKind() {
        this.createSchema(SchemaStorageIT.uniquenessConstraint(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2));
        IndexDescriptor rule = (IndexDescriptor)ArrayUtil.single((Object[])storage.indexGetForSchema((SchemaDescriptorSupplier)this.uniqueIndexDescriptor(LABEL1, PROP1)));
        Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, true);
    }

    @Test
    void shouldListAllIndexRules() {
        this.createSchema(SchemaStorageIT.index(LABEL1, PROP1), SchemaStorageIT.index(LABEL1, PROP2), SchemaStorageIT.uniquenessConstraint(LABEL2, PROP1));
        Set listedRules = Iterators.asSet((Iterator)storage.indexesGetAll());
        HashSet<IndexDescriptor> expectedRules = new HashSet<IndexDescriptor>();
        expectedRules.add(this.makeIndexRule(1L, LABEL1, PROP1));
        expectedRules.add(this.makeIndexRule(2L, LABEL1, PROP2));
        expectedRules.add(this.makeIndexRuleForConstraint(3L, LABEL2, PROP1, 0L));
        Assertions.assertEquals(expectedRules, (Object)listedRules);
    }

    @Test
    void shouldReturnCorrectUniquenessRuleForLabelAndProperty() throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        this.createSchema(SchemaStorageIT.uniquenessConstraint(LABEL1, PROP1), SchemaStorageIT.uniquenessConstraint(LABEL2, PROP1));
        ConstraintDescriptor rule = storage.constraintsGetSingle((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)}));
        Assertions.assertNotNull((Object)rule);
        this.assertRule(rule, LABEL1, PROP1, ConstraintType.UNIQUE);
    }

    @Test
    void shouldWriteAndReadIndexConfig() throws KernelException {
        IndexConfig expected = IndexConfig.with((Map)MapUtil.genericMap((Object[])new Object[]{"value.string", Values.stringValue((String)"value"), "value.int", Values.intValue((int)1), "value.doubleArray", Values.doubleArray((double[])new double[]{0.4, 0.6, 1.0}), "value.boolean", Values.booleanValue((boolean)true)}));
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelId(LABEL1), (int[])new int[]{this.propId(PROP1)});
        long id = schemaStore.nextId();
        IndexDescriptor storeIndexDescriptor = IndexPrototype.forSchema((SchemaDescriptor)schema).withName("index_" + id).materialise(id).withIndexConfig(expected);
        storage.writeSchemaRule((SchemaRule)storeIndexDescriptor);
        IndexDescriptor schemaRule = (IndexDescriptor)storage.loadSingleSchemaRule(id);
        storage.deleteSchemaRule((SchemaRule)schemaRule);
        IndexConfig actual = schemaRule.getIndexConfig();
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("Read index config not same as written, expected " + expected + ", actual " + actual));
    }

    private void assertRule(IndexDescriptor rule, String label, String propertyKey, boolean isUnique) {
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)rule, (int)this.labelId(label)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)rule, (int)this.propId(propertyKey)));
        Assertions.assertEquals((Object)isUnique, (Object)rule.isUnique());
    }

    private void assertRule(ConstraintDescriptor constraint, String label, String propertyKey, ConstraintType type) {
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasLabel((SchemaDescriptorSupplier)constraint, (int)this.labelId(label)));
        Assertions.assertTrue((boolean)SchemaDescriptorPredicates.hasProperty((SchemaDescriptorSupplier)constraint, (int)this.propId(propertyKey)));
        Assertions.assertEquals((Object)type, (Object)constraint.type());
    }

    private IndexDescriptor indexDescriptor(String label, String property) {
        return TestIndexDescriptorFactory.forLabel((int)this.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexDescriptor uniqueIndexDescriptor(String label, String property) {
        return TestIndexDescriptorFactory.uniqueForLabel((int)this.labelId(label), (int[])new int[]{this.propId(property)});
    }

    private IndexDescriptor makeIndexRule(long ruleId, String label, String propertyKey) {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelId(label), (int[])new int[]{this.propId(propertyKey)});
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)GenericNativeIndexProvider.DESCRIPTOR);
        prototype = prototype.withName(SchemaRule.generateName((SchemaDescriptorSupplier)prototype, (String[])new String[]{label}, (String[])new String[]{propertyKey}));
        return prototype.materialise(ruleId);
    }

    private IndexDescriptor makeIndexRuleForConstraint(long ruleId, String label, String propertyKey, long constraintId) {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)this.labelId(label), (int[])new int[]{this.propId(propertyKey)});
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)GenericNativeIndexProvider.DESCRIPTOR);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
        prototype = prototype.withName(SchemaRule.generateName((SchemaDescriptorSupplier)constraint, (String[])new String[]{label}, (String[])new String[]{propertyKey}));
        return prototype.materialise(ruleId).withOwningConstraintId(constraintId);
    }

    private int labelId(String labelName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(labelName);
            return n;
        }
    }

    private int propId(String propName) {
        try (Transaction tx = this.db.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().propertyKey(propName);
            return n;
        }
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.db.getDependencyResolver().resolveDependency(clazz);
    }

    private static Consumer<Transaction> index(String label, String prop) {
        return tx -> tx.schema().indexFor(Label.label((String)label)).on(prop).create();
    }

    private static Consumer<Transaction> uniquenessConstraint(String label, String prop) {
        return tx -> tx.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(prop).create();
    }

    @SafeVarargs
    private void createSchema(Consumer<Transaction> ... creators) {
        try (Transaction tx = this.db.beginTx();){
            for (Consumer<Transaction> rule : creators) {
                rule.accept(tx);
            }
            tx.commit();
        }
        this.awaitIndexes();
    }

    private void awaitIndexes() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
    }
}

