/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;

@EphemeralNeo4jLayoutExtension
class TestStoreAccess {
    @RegisterExtension
    static PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;

    TestStoreAccess() {
    }

    @Test
    void openingThroughStoreAccessShouldNotTriggerRecovery() throws Throwable {
        try (EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore();){
            Assertions.assertTrue((boolean)this.isUnclean((FileSystemAbstraction)snapshot), (String)"Store should be unclean");
            PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)snapshot);
            new StoreAccess((FileSystemAbstraction)snapshot, pageCache, this.databaseLayout, Config.defaults()).initialize().close();
            Assertions.assertTrue((boolean)this.isUnclean((FileSystemAbstraction)snapshot), (String)"Store should be unclean");
        }
    }

    private EphemeralFileSystemAbstraction produceUncleanStore() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)this.fs).impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        managementService.shutdown();
        return snapshot;
    }

    private boolean isUnclean(FileSystemAbstraction fileSystem) throws Exception {
        return Recovery.isRecoveryRequired((FileSystemAbstraction)fileSystem, (DatabaseLayout)this.databaseLayout, (Config)Config.defaults());
    }
}

