/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.indexed.IndexedIdGenerator;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.proc.ProcessUtil;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.RandomValues;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
@Timeout(value=20L, unit=TimeUnit.MINUTES)
class ReuseStorageSpaceIT {
    private static final int DATA_SIZE = 1000;
    private static final int CREATION_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int NUMBER_OF_TRANSACTIONS_PER_THREAD = 100;
    private static final int CUSTOM_EXIT_CODE = 99;
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    @Inject
    private TestDirectory directory;
    @Inject
    private RandomRule random;

    ReuseStorageSpaceIT() {
    }

    @Test
    void shouldReuseStorageSpaceWhenCreatingDeletingAndRestarting() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE_DELETE, Operation.CREATE_DELETE, ReuseStorageSpaceIT::sameProcess);
    }

    @Test
    void shouldReuseStorageSpaceWhenDeletingCreatingAndRestarting() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE, Operation.DELETE_CREATE, ReuseStorageSpaceIT::sameProcess);
    }

    @Test
    void shouldReuseStorageSpaceWhenCreatingDeletingAndCrashing() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE_DELETE, Operation.CREATE_DELETE, ReuseStorageSpaceIT::crashingChildProcess);
    }

    @Test
    void shouldReuseStorageSpaceWhenDeletingCreatingAndCrashing() throws Exception {
        this.shouldReuseStorageSpace(Operation.CREATE, Operation.DELETE_CREATE, ReuseStorageSpaceIT::crashingChildProcess);
    }

    private void shouldReuseStorageSpace(Operation initialState, Operation operation, Launcher launcher) throws Exception {
        File storeDirectory = this.directory.homeDir();
        long seed = this.random.seed();
        Sizes initialStoreSizes = ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseService, Exception>)((ThrowingConsumer)db -> initialState.perform((GraphDatabaseService)db, seed)));
        int i = 0;
        while (i < 3) {
            Pair<Integer, Sizes> result = launcher.launch(storeDirectory, seed, operation);
            Assertions.assertEquals((int)99, (Integer)((Integer)result.getLeft()));
            Sizes storeFileSizesNow = (Sizes)result.getRight();
            Sizes diff = storeFileSizesNow.diffAgainst(initialStoreSizes);
            long storeFilesDiff = diff.sum();
            int round = i++;
            Assertions.assertEquals((long)0L, (long)storeFilesDiff, () -> String.format("Initial sizes %s%n%nStore sizes after operation (round %d)%s%n%nDiff between the two above %s%n", initialStoreSizes, round, storeFileSizesNow, diff));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Integer, Sizes> sameProcess(File storeDirectory, long seed, Operation operation) {
        ReuseStorageSpaceIT.enableStrictPrioritizationOfFreelist();
        try {
            Pair pair = Pair.of((Object)99, (Object)ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseService, Exception>)((ThrowingConsumer)db -> operation.perform((GraphDatabaseService)db, seed))));
            return pair;
        }
        finally {
            ReuseStorageSpaceIT.restoreStrictPrioritizationOfFreelist();
        }
    }

    private static Pair<Integer, Sizes> crashingChildProcess(File storeDirectory, long seed, Operation operation) throws Exception {
        Process process = new ProcessBuilder(ProcessUtil.getJavaExecutable().toString(), "-cp", ProcessUtil.getClassPath(), ReuseStorageSpaceIT.class.getCanonicalName(), storeDirectory.getPath(), String.valueOf(seed), operation.name()).inheritIO().start();
        int exitCode = process.waitFor();
        Sizes storeFileSizes = ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseService, Exception>)((ThrowingConsumer)db -> {}));
        return Pair.of((Object)exitCode, (Object)storeFileSizes);
    }

    public static void main(String[] args) {
        ReuseStorageSpaceIT.enableStrictPrioritizationOfFreelist();
        File storeDirectory = new File(args[0]);
        long seed = Long.parseLong(args[1]);
        Operation operation = Operation.valueOf(args[2]);
        ReuseStorageSpaceIT.withDb(storeDirectory, (ThrowingConsumer<GraphDatabaseService, Exception>)((ThrowingConsumer)db -> {
            operation.perform((GraphDatabaseService)db, seed);
            System.exit(99);
        }));
    }

    private static Sizes withDb(File storeDir, ThrowingConsumer<GraphDatabaseService, Exception> transaction) {
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.force_small_id_cache, (Object)true).build();
        try {
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            transaction.accept((Object)db);
            Sizes sizes = new Sizes(db);
            return sizes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            dbms.shutdown();
        }
    }

    private static void createStuff(GraphDatabaseService db, long seed) {
        Race race = new Race();
        AtomicLong createdNodes = new AtomicLong();
        AtomicLong createdRelationships = new AtomicLong();
        int dataSizePerTransaction = 10 / CREATION_THREADS;
        AtomicLong nextSeed = new AtomicLong(seed);
        race.addContestants(CREATION_THREADS, Race.throwing(() -> {
            RandomValues random = RandomValues.create((Random)new Random(nextSeed.getAndIncrement()));
            int nodeCount = 0;
            int relationshipCount = 0;
            for (int t = 0; t < 100; ++t) {
                try (Transaction tx = db.beginTx();){
                    Object[] nodes = new Node[dataSizePerTransaction];
                    for (int n = 0; n < nodes.length; ++n) {
                        nodes[n] = tx.createNode(ReuseStorageSpaceIT.labels((String[])random.selection((Object[])TOKENS, 0, TOKENS.length, false)));
                        Node node = nodes[n];
                        ReuseStorageSpaceIT.setProperties(random, (Entity)node);
                        ++nodeCount;
                    }
                    for (int r = 0; r < nodes.length; ++r) {
                        Relationship relationship = ((Node)random.among(nodes)).createRelationshipTo((Node)random.among(nodes), RelationshipType.withName((String)((String)random.among((Object[])TOKENS))));
                        ReuseStorageSpaceIT.setProperties(random, (Entity)relationship);
                        ++relationshipCount;
                    }
                    tx.commit();
                    continue;
                }
            }
            createdNodes.addAndGet(nodeCount);
            createdRelationships.addAndGet(relationshipCount);
        }), 1);
        race.goUnchecked();
    }

    private static void deleteStuff(GraphDatabaseService db) {
        ReuseStorageSpaceIT.batchedDelete(db, Transaction::getAllRelationships, Relationship::delete);
        ReuseStorageSpaceIT.batchedDelete(db, Transaction::getAllNodes, Node::delete);
    }

    private static <ENTITY> void batchedDelete(GraphDatabaseService db, Function<Transaction, ResourceIterable<ENTITY>> provider, Consumer<ENTITY> deleter) {
        int deleted;
        do {
            try (Transaction tx = db.beginTx();){
                try (ResourceIterator iterator = provider.apply(tx).iterator();){
                    for (deleted = 0; iterator.hasNext() && deleted < 10000; ++deleted) {
                        Object entity = iterator.next();
                        deleter.accept(entity);
                    }
                }
                tx.commit();
            }
        } while (deleted > 0);
    }

    private static void setProperties(RandomValues random, Entity entity) {
        for (String propertyKey : (String[])random.selection((Object[])TOKENS, 0, TOKENS.length, false)) {
            entity.setProperty(propertyKey, random.nextValue().asObject());
        }
    }

    private static Label[] labels(String[] names) {
        Label[] labels = new Label[names.length];
        for (int i = 0; i < names.length; ++i) {
            labels[i] = Label.label((String)names[i]);
        }
        return labels;
    }

    private static void enableStrictPrioritizationOfFreelist() {
        FeatureToggles.set(IndexedIdGenerator.class, (String)"strictlyPrioritizeFreelist", (Object)Boolean.TRUE);
    }

    private static void restoreStrictPrioritizationOfFreelist() {
        FeatureToggles.clear(IndexedIdGenerator.class, (String)"strictlyPrioritizeFreelist");
    }

    static interface Launcher {
        public Pair<Integer, Sizes> launch(File var1, long var2, Operation var4) throws Exception;
    }

    private static enum Operation {
        CREATE{

            @Override
            void perform(GraphDatabaseService db, long seed) {
                ReuseStorageSpaceIT.createStuff(db, seed);
            }
        }
        ,
        CREATE_DELETE{

            @Override
            public void perform(GraphDatabaseService db, long seed) {
                ReuseStorageSpaceIT.createStuff(db, seed);
                ReuseStorageSpaceIT.deleteStuff(db);
            }
        }
        ,
        DELETE_CREATE{

            @Override
            public void perform(GraphDatabaseService db, long seed) throws InterruptedException {
                ReuseStorageSpaceIT.deleteStuff(db);
                Thread.sleep(2000L);
                ReuseStorageSpaceIT.createStuff(db, seed);
            }
        };


        abstract void perform(GraphDatabaseService var1, long var2) throws Exception;
    }

    private static class Sizes {
        private final Map<String, Long> sizes;

        Sizes(GraphDatabaseAPI db) {
            this.sizes = new HashMap<String, Long>();
            IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)db.getDependencyResolver().resolveDependency(IdGeneratorFactory.class);
            for (IdType idType : IdType.values()) {
                this.sizes.put(idType.name(), idGeneratorFactory.get(idType).getHighId());
            }
        }

        private Sizes(Map<String, Long> sizes) {
            this.sizes = sizes;
        }

        Sizes diffAgainst(Sizes other) {
            HashMap<String, Long> diff = new HashMap<String, Long>();
            for (Map.Entry<String, Long> entry : this.sizes.entrySet()) {
                long diffSize;
                Long otherSize = other.sizes.get(entry.getKey());
                if (otherSize == null || (diffSize = entry.getValue() - otherSize) == 0L) continue;
                diff.put(entry.getKey(), diffSize);
            }
            return new Sizes(diff);
        }

        public String toString() {
            List nonEmptyEntries = this.sizes.entrySet().stream().filter(e -> (Long)e.getValue() != 0L).sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
            long sum = this.sum();
            return String.format("SUM %s(%d):%n%s", ByteUnit.bytesToString((long)sum), sum, StringUtils.join(nonEmptyEntries, (String)String.format("%n", new Object[0])));
        }

        long sum() {
            return this.sum(all -> true);
        }

        long sum(Predicate<String> filter) {
            return this.sizes.entrySet().stream().filter(e -> filter.test((String)e.getKey())).mapToLong(Map.Entry::getValue).sum();
        }
    }
}

