/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.state.DatabaseFileListing;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.rule.TestDirectory;

@DbmsExtension
class DatabaseFileListingTest {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private TestDirectory testDirectory;
    private Database database;
    private static final String[] STANDARD_STORE_DIR_FILES = new String[]{"index", "lock", "debug.log", "neostore", "neostore.id", "neostore.counts.db", "neostore.labelscanstore.db", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.id", "neostore.labeltokenstore.db.names", "neostore.labeltokenstore.db.names.id", "neostore.nodestore.db", "neostore.nodestore.db.id", "neostore.nodestore.db.labels", "neostore.nodestore.db.labels.id", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.arrays.id", "neostore.propertystore.db.id", "neostore.propertystore.db.index", "neostore.propertystore.db.index.id", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.index.keys.id", "neostore.propertystore.db.strings", "neostore.propertystore.db.strings.id", "neostore.relationshipgroupstore.db", "neostore.relationshipgroupstore.db.id", "neostore.relationshipstore.db", "neostore.relationshipstore.db.id", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.id", "neostore.relationshiptypestore.db.names", "neostore.relationshiptypestore.db.names.id", "neostore.schemastore.db", "neostore.schemastore.db.id", "neostore.transaction.db.0", "neostore.transaction.db.1", "neostore.transaction.db.2", "store_lock"};
    private static final String[] STANDARD_STORE_DIR_DIRECTORIES = new String[]{"schema", "index", "branched"};

    DatabaseFileListingTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.createIndexDbFile();
        this.database = (Database)this.db.getDependencyResolver().resolveDependency(Database.class);
    }

    @Test
    void shouldCloseIndexAndLabelScanSnapshots() throws Exception {
        LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        DatabaseLayout databaseLayout = (DatabaseLayout)Mockito.mock(DatabaseLayout.class);
        Mockito.when((Object)databaseLayout.metadataStore()).thenReturn((Object)((File)Mockito.mock(File.class)));
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        DatabaseFileListingTest.filesInStoreDirAre(databaseLayout, STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        DatabaseFileListing fileListing = new DatabaseFileListing(databaseLayout, logFiles, labelScanStore, indexingService, storageEngine, idGeneratorFactory);
        ResourceIterator<File> scanSnapshot = DatabaseFileListingTest.scanStoreFilesAre(labelScanStore, new String[]{"blah/scan.store", "scan.more"});
        ResourceIterator<File> indexSnapshot = DatabaseFileListingTest.indexFilesAre(indexingService, new String[]{"schema/index/my.index"});
        ResourceIterator result = fileListing.builder().excludeLogFiles().build();
        result.close();
        ((ResourceIterator)Mockito.verify(scanSnapshot)).close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    void shouldListMetaDataStoreLast() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.database.listStoreFiles(false));
        Assertions.assertEquals((Object)fileMetadata.file(), (Object)this.database.getDatabaseLayout().metadataStore());
    }

    @Test
    void shouldListMetaDataStoreLastWithTxLogs() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.database.listStoreFiles(true));
        Assertions.assertEquals((Object)fileMetadata.file(), (Object)this.database.getDatabaseLayout().metadataStore());
    }

    @Test
    void shouldListTransactionLogsFromCustomAbsoluteLocationWhenConfigured() throws IOException {
        File customLogLocation = this.testDirectory.directory("customLogLocation", new String[0]);
        this.verifyLogFilesWithCustomPathListing(customLogLocation.toPath().toAbsolutePath());
    }

    @Test
    void shouldListTxLogFiles() throws Exception {
        Assertions.assertTrue((boolean)this.database.listStoreFiles(true).stream().map(metaData -> metaData.file().getName()).anyMatch(fileName -> TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(null, (String)fileName)));
    }

    @Test
    void shouldNotListTxLogFiles() throws Exception {
        Assertions.assertTrue((boolean)this.database.listStoreFiles(false).stream().map(metaData -> metaData.file().getName()).noneMatch(fileName -> TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(null, (String)fileName)));
    }

    @Test
    void shouldListNeostoreFiles() throws Exception {
        DatabaseLayout layout = this.database.getDatabaseLayout();
        Set expectedFiles = layout.storeFiles();
        ResourceIterator storeFiles = this.database.listStoreFiles(false);
        Set listedStoreFiles = storeFiles.stream().map(StoreFileMetadata::file).collect(Collectors.toSet());
        Assertions.assertEquals((Object)expectedFiles, listedStoreFiles);
    }

    @Test
    void doNotListFilesFromAdditionalProviderThatRegisterTwice() throws IOException {
        DatabaseFileListing databaseFileListing = this.database.getDatabaseFileListing();
        MarkerFileProvider provider = new MarkerFileProvider();
        databaseFileListing.registerStoreFileProvider((DatabaseFileListing.StoreFileProvider)provider);
        databaseFileListing.registerStoreFileProvider((DatabaseFileListing.StoreFileProvider)provider);
        ResourceIterator metadataResourceIterator = databaseFileListing.builder().build();
        Assertions.assertEquals((long)1L, (long)metadataResourceIterator.stream().filter(metadata -> "marker".equals(metadata.file().getName())).count());
    }

    private void verifyLogFilesWithCustomPathListing(Path path) throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir("customDb")).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)path).build();
        GraphDatabaseAPI graphDatabase = (GraphDatabaseAPI)managementService.database("neo4j");
        Database database = (Database)graphDatabase.getDependencyResolver().resolveDependency(Database.class);
        LogFiles logFiles = (LogFiles)graphDatabase.getDependencyResolver().resolveDependency(LogFiles.class);
        Assertions.assertTrue((boolean)database.listStoreFiles(true).stream().anyMatch(metadata -> metadata.isLogFile() && logFiles.isLogFile(metadata.file())));
        Assertions.assertEquals((Object)path.getFileName().toString(), (Object)logFiles.logFilesDirectory().getParentFile().getName());
        managementService.shutdown();
    }

    private static void filesInStoreDirAre(DatabaseLayout databaseLayout, String[] filenames, String[] dirs) {
        ArrayList<File> files = new ArrayList<File>();
        DatabaseFileListingTest.mockFiles(filenames, files, false);
        DatabaseFileListingTest.mockFiles(dirs, files, true);
        Mockito.when((Object)databaseLayout.listDatabaseFiles((FileFilter)ArgumentMatchers.any())).thenReturn((Object)files.toArray(new File[0]));
    }

    private static ResourceIterator<File> scanStoreFilesAre(LabelScanStore labelScanStore, String[] fileNames) {
        ArrayList<File> files = new ArrayList<File>();
        DatabaseFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)labelScanStore.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private static ResourceIterator<File> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        DatabaseFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotIndexFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void createIndexDbFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        File indexFile = databaseLayout.file("index.db");
        if (!indexFile.exists()) {
            Assertions.assertTrue((boolean)indexFile.createNewFile());
        }
    }

    private static void mockFiles(String[] filenames, ArrayList<File> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            files.add(file);
        }
    }

    private static class MarkerFileProvider
    implements DatabaseFileListing.StoreFileProvider {
        private MarkerFileProvider() {
        }

        public Resource addFilesTo(Collection<StoreFileMetadata> fileMetadataCollection) {
            fileMetadataCollection.add(new StoreFileMetadata(new File("marker"), 0));
            return Resource.EMPTY;
        }
    }
}

