/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension
class NeoStoreIndexStoreViewTest {
    @Inject
    private GraphDatabaseAPI graphDb;
    private final Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();
    private final Label label = Label.label((String)"Person");
    private final RelationshipType relationshipType = RelationshipType.withName((String)"Knows");
    private NeoStoreIndexStoreView storeView;
    private int labelId;
    private int relTypeId;
    private int propertyKeyId;
    private int relPropertyKeyId;
    private Node alistair;
    private Node stefan;
    private LockService locks;
    private NeoStores neoStores;
    private Relationship aKnowsS;
    private Relationship sKnowsA;
    private StorageReader reader;
    private NodePropertyAccessor propertyAccessor;

    NeoStoreIndexStoreViewTest() {
    }

    @BeforeEach
    void before() throws KernelException {
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        RecordStorageEngine storageEngine = (RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
        this.neoStores = storageEngine.testAccessNeoStores();
        this.locks = (LockService)Mockito.mock(LockService.class);
        Mockito.when((Object)this.locks.acquireNodeLock(ArgumentMatchers.anyLong(), (LockService.LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        Mockito.when((Object)this.locks.acquireRelationshipLock(ArgumentMatchers.anyLong(), (LockService.LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        this.storeView = new NeoStoreIndexStoreView(this.locks, () -> ((RecordStorageEngine)storageEngine).newReader());
        this.propertyAccessor = this.storeView.newPropertyAccessor();
        this.reader = storageEngine.newReader();
    }

    @AfterEach
    void after() {
        this.propertyAccessor.close();
        this.reader.close();
    }

    @Test
    void shouldScanExistingNodesForALabel() throws Exception {
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false);
        storeScan.run();
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new EntityUpdates[]{this.add(this.alistair.getId(), this.propertyKeyId, "Alistair", new long[]{this.labelId}), this.add(this.stefan.getId(), this.propertyKeyId, "Stefan", new long[]{this.labelId})}), visitor.getUpdates());
    }

    @Test
    void shouldScanExistingRelationshipsForARelationshipType() throws Exception {
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (Visitor)visitor);
        storeScan.run();
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new EntityUpdates[]{this.add(this.aKnowsS.getId(), this.relPropertyKeyId, "long", new long[]{this.relTypeId}), this.add(this.sKnowsA.getId(), this.relPropertyKeyId, "lengthy", new long[]{this.relTypeId})}), visitor.getUpdates());
    }

    @Test
    void shouldIgnoreDeletedNodesDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false);
        storeScan.run();
        Assertions.assertEquals(Collections.emptySet(), visitor.getUpdates());
    }

    @Test
    void shouldIgnoreDeletedRelationshipsDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        EntityUpdateCollectingVisitor visitor = new EntityUpdateCollectingVisitor();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (Visitor)visitor);
        storeScan.run();
        Assertions.assertEquals(Collections.emptySet(), visitor.getUpdates());
    }

    @Test
    void shouldLockNodesWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, visitor, null, false);
        storeScan.run();
        MatcherAssert.assertThat((String)("allocated locks: " + this.lockMocks.keySet()), (Object)this.lockMocks.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assertions.assertNotNull((Object)lock0, (String)"Lock[node=0] never acquired");
        Assertions.assertNotNull((Object)lock1, (String)"Lock[node=1] never acquired");
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    void shouldLockRelationshipsWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, visitor);
        storeScan.run();
        MatcherAssert.assertThat((String)("allocated locks: " + this.lockMocks.keySet()), (Object)this.lockMocks.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assertions.assertNotNull((Object)lock0, (String)"Lock[relationship=0] never acquired");
        Assertions.assertNotNull((Object)lock1, (String)"Lock[relationship=1] never acquired");
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    void shouldReadProperties() throws EntityNotFoundException {
        Value value = this.propertyAccessor.getNodePropertyValue(this.alistair.getId(), this.propertyKeyId);
        Assertions.assertTrue((boolean)value.equals(Values.of((Object)"Alistair")));
    }

    @Test
    void processAllNodeProperties() {
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        StoreViewNodeStoreScan storeViewNodeStoreScan = new StoreViewNodeStoreScan((StorageReader)new RecordStorageReader(this.neoStores), this.locks, null, (Visitor)propertyUpdateVisitor, new int[]{this.labelId}, id -> true);
        try (StorageNodeCursor nodeCursor = this.reader.allocateNodeCursor();){
            nodeCursor.single(1L);
            nodeCursor.next();
            storeViewNodeStoreScan.process(nodeCursor);
        }
        EntityUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        Assertions.assertNotNull((Object)propertyUpdates, (String)"Visitor should contain container with updates.");
        LabelSchemaDescriptor index1 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
        LabelSchemaDescriptor index2 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor index3 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0, 1});
        LabelSchemaDescriptor index4 = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
        List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        MatcherAssert.assertThat((Object)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes)), (Matcher)Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{index1, index2, index3}));
    }

    @Test
    void processAllRelationshipProperties() {
        this.createAlistairAndStefanNodes();
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        RelationshipStoreScan relationshipStoreScan = new RelationshipStoreScan((StorageReader)new RecordStorageReader(this.neoStores), this.locks, (Visitor)propertyUpdateVisitor, new int[]{this.relTypeId}, id -> true);
        try (StorageRelationshipScanCursor relationshipScanCursor = this.reader.allocateRelationshipScanCursor();){
            relationshipScanCursor.single(1L);
            relationshipScanCursor.next();
            relationshipStoreScan.process(relationshipScanCursor);
        }
        EntityUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        Assertions.assertNotNull((Object)propertyUpdates, (String)"Visitor should contain container with updates.");
        RelationTypeSchemaDescriptor index1 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{2});
        RelationTypeSchemaDescriptor index2 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{3});
        RelationTypeSchemaDescriptor index3 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{2, 3});
        RelationTypeSchemaDescriptor index4 = SchemaDescriptor.forRelType((int)1, (int[])new int[]{3});
        List<RelationTypeSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        MatcherAssert.assertThat((Object)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes)), (Matcher)Matchers.containsInAnyOrder((Object[])new RelationTypeSchemaDescriptor[]{index1, index2, index3}));
    }

    private EntityUpdates add(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return EntityUpdates.forEntity((long)nodeId, (boolean)true).withTokens(labels).added(propertyKeyId, Values.of((Object)value)).build();
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = tx.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.alistair.setProperty("country", (Object)"UK");
            this.stefan = tx.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            this.stefan.setProperty("country", (Object)"Deutschland");
            this.aKnowsS = this.alistair.createRelationshipTo(this.stefan, this.relationshipType);
            this.aKnowsS.setProperty("duration", (Object)"long");
            this.aKnowsS.setProperty("irrelevant", (Object)"prop");
            this.sKnowsA = this.stefan.createRelationshipTo(this.alistair, this.relationshipType);
            this.sKnowsA.setProperty("duration", (Object)"lengthy");
            this.sKnowsA.setProperty("irrelevant", (Object)"prop");
            tx.commit();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.getRelationshipById(this.aKnowsS.getId()).delete();
            tx.getRelationshipById(this.sKnowsA.getId()).delete();
            tx.getNodeById(this.alistair.getId()).delete();
            tx.getNodeById(this.stefan.getId()).delete();
            tx.commit();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            TokenWrite tokenWrite = ((InternalTransaction)tx).kernelTransaction().tokenWrite();
            this.labelId = tokenWrite.labelGetOrCreateForName("Person");
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("Knows");
            this.propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("name");
            this.relPropertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("duration");
            tx.commit();
        }
    }

    static class EntityUpdateCollectingVisitor
    implements Visitor<EntityUpdates, Exception> {
        private final Set<EntityUpdates> updates = new HashSet<EntityUpdates>();

        EntityUpdateCollectingVisitor() {
        }

        public boolean visit(EntityUpdates propertyUpdates) {
            this.updates.add(propertyUpdates);
            return false;
        }

        Set<EntityUpdates> getUpdates() {
            return this.updates;
        }
    }

    private static class CopyUpdateVisitor
    implements Visitor<EntityUpdates, RuntimeException> {
        private EntityUpdates propertyUpdates;

        private CopyUpdateVisitor() {
        }

        public boolean visit(EntityUpdates element) throws RuntimeException {
            this.propertyUpdates = element;
            return true;
        }

        EntityUpdates getPropertyUpdates() {
            return this.propertyUpdates;
        }
    }
}

