/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

@ImpermanentDbmsExtension
class DefaultValueMapperTest {
    @Inject
    private GraphDatabaseService db;

    DefaultValueMapperTest() {
    }

    @Test
    void shouldHandleSingleNodePath() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Path mapped = mapper.mapPath(VirtualValues.path((NodeValue[])this.asNodeValues(node), (RelationshipValue[])this.asRelationshipsValues(new Relationship[0])));
            MatcherAssert.assertThat((Object)mapped.length(), (Matcher)CoreMatchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)mapped.startNode(), (Matcher)CoreMatchers.equalTo((Object)node));
            MatcherAssert.assertThat((Object)mapped.endNode(), (Matcher)CoreMatchers.equalTo((Object)node));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.relationships()), (Matcher)IsCollectionWithSize.hasSize((int)0));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.reverseRelationships()), (Matcher)IsCollectionWithSize.hasSize((int)0));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.nodes()), (Matcher)CoreMatchers.equalTo(Collections.singletonList(node)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.reverseNodes()), (Matcher)CoreMatchers.equalTo(Collections.singletonList(node)));
            MatcherAssert.assertThat((Object)mapped.lastRelationship(), (Matcher)CoreMatchers.nullValue());
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)mapped.iterator()), (Matcher)CoreMatchers.equalTo(Collections.singletonList(node)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleSingleRelationshipPath() {
        Relationship relationship;
        Node end;
        Node start;
        try (Transaction tx = this.db.beginTx();){
            start = tx.createNode();
            end = tx.createNode();
            relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"R"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Path mapped = mapper.mapPath(VirtualValues.path((NodeValue[])this.asNodeValues(start, end), (RelationshipValue[])this.asRelationshipsValues(relationship)));
            MatcherAssert.assertThat((Object)mapped.length(), (Matcher)CoreMatchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)mapped.startNode(), (Matcher)CoreMatchers.equalTo((Object)start));
            MatcherAssert.assertThat((Object)mapped.endNode(), (Matcher)CoreMatchers.equalTo((Object)end));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.relationships()), (Matcher)CoreMatchers.equalTo(Collections.singletonList(relationship)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.reverseRelationships()), (Matcher)CoreMatchers.equalTo(Collections.singletonList(relationship)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.nodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(start, end)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.reverseNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(end, start)));
            MatcherAssert.assertThat((Object)mapped.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)relationship));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)mapped.iterator()), (Matcher)CoreMatchers.equalTo(Arrays.asList(start, relationship, end)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldHandleLongPath() {
        Relationship r4;
        Relationship r3;
        Relationship r2;
        Relationship r1;
        Node e;
        Node d;
        Node c;
        Node b;
        Node a;
        try (Transaction tx = this.db.beginTx();){
            a = tx.createNode();
            b = tx.createNode();
            c = tx.createNode();
            d = tx.createNode();
            e = tx.createNode();
            r1 = a.createRelationshipTo(b, RelationshipType.withName((String)"R"));
            r2 = b.createRelationshipTo(c, RelationshipType.withName((String)"R"));
            r3 = c.createRelationshipTo(d, RelationshipType.withName((String)"R"));
            r4 = d.createRelationshipTo(e, RelationshipType.withName((String)"R"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Path mapped = mapper.mapPath(VirtualValues.path((NodeValue[])this.asNodeValues(a, b, c, d, e), (RelationshipValue[])this.asRelationshipsValues(r1, r2, r3, r4)));
            MatcherAssert.assertThat((Object)mapped.length(), (Matcher)CoreMatchers.equalTo((Object)4));
            MatcherAssert.assertThat((Object)mapped.startNode(), (Matcher)CoreMatchers.equalTo((Object)a));
            MatcherAssert.assertThat((Object)mapped.endNode(), (Matcher)CoreMatchers.equalTo((Object)e));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.relationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(r1, r2, r3, r4)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.reverseRelationships()), (Matcher)CoreMatchers.equalTo(Arrays.asList(r4, r3, r2, r1)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.nodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(a, b, c, d, e)));
            MatcherAssert.assertThat((Object)Iterables.asList((Iterable)mapped.reverseNodes()), (Matcher)CoreMatchers.equalTo(Arrays.asList(e, d, c, b, a)));
            MatcherAssert.assertThat((Object)mapped.lastRelationship(), (Matcher)CoreMatchers.equalTo((Object)r4));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)mapped.iterator()), (Matcher)CoreMatchers.equalTo(Arrays.asList(a, r1, b, r2, c, r3, d, r4, e)));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldMapDirectRelationship() {
        Relationship relationship;
        Node end;
        Node start;
        try (Transaction tx = this.db.beginTx();){
            start = tx.createNode();
            end = tx.createNode();
            relationship = start.createRelationshipTo(end, RelationshipType.withName((String)"R"));
            tx.commit();
        }
        RelationshipValue relationshipValue = VirtualValues.relationshipValue((long)relationship.getId(), (NodeValue)VirtualValues.nodeValue((long)start.getId(), (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP), (NodeValue)VirtualValues.nodeValue((long)start.getId(), (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP), (TextValue)Values.stringValue((String)"R"), (MapValue)VirtualValues.EMPTY_MAP);
        try (Transaction tx = this.db.beginTx();){
            DefaultValueMapper mapper = new DefaultValueMapper((InternalTransaction)tx);
            Relationship coreAPIRelationship = mapper.mapRelationship((VirtualRelationshipValue)relationshipValue);
            MatcherAssert.assertThat((Object)coreAPIRelationship.getId(), (Matcher)CoreMatchers.equalTo((Object)relationship.getId()));
            MatcherAssert.assertThat((Object)coreAPIRelationship.getStartNode(), (Matcher)CoreMatchers.equalTo((Object)start));
            MatcherAssert.assertThat((Object)coreAPIRelationship.getEndNode(), (Matcher)CoreMatchers.equalTo((Object)end));
        }
    }

    private NodeValue[] asNodeValues(Node ... nodes) {
        return (NodeValue[])Arrays.stream(nodes).map(ValueUtils::fromNodeEntity).toArray(NodeValue[]::new);
    }

    private RelationshipValue[] asRelationshipsValues(Relationship ... relationships) {
        return (RelationshipValue[])Arrays.stream(relationships).map(ValueUtils::fromRelationshipEntity).toArray(RelationshipValue[]::new);
    }
}

