/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class TestGraphDescription
implements GraphHolder {
    private static GraphDatabaseService graphdb;
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this));
    private static DatabaseManagementService managementService;

    @Test
    public void havingNoGraphAnnotationCreatesAnEmptyDataCollection() {
        Assert.assertTrue((String)"collection was not empty", (boolean)((Map)this.data.get()).isEmpty());
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void canCreateGraphFromSingleString() {
        this.verifyIKnowYou("know", "I");
    }

    @Test
    @GraphDescription.Graph(value={"a TO b", "b TO c", "c TO a"})
    public void canCreateGraphFromMultipleStrings() {
        Map graph = (Map)this.data.get();
        HashSet<Node> unique = new HashSet<Node>();
        Node n = (Node)graph.get("a");
        while (unique.add(n)) {
            Transaction tx = graphdb.beginTx();
            try {
                n = tx.getNodeById(n.getId()).getSingleRelationship(RelationshipType.withName((String)"TO"), Direction.OUTGOING).getEndNode();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        Assert.assertEquals((long)graph.size(), (long)unique.size());
    }

    @Test
    @GraphDescription.Graph(value={"a:Person EATS b:Banana"})
    public void ensurePeopleCanEatBananas() {
        Map graph = (Map)this.data.get();
        Node a = (Node)graph.get("a");
        Node b = (Node)graph.get("b");
        try (Transaction tx = graphdb.beginTx();){
            Assert.assertTrue((boolean)tx.getNodeById(a.getId()).hasLabel(Label.label((String)"Person")));
            Assert.assertTrue((boolean)tx.getNodeById(b.getId()).hasLabel(Label.label((String)"Banana")));
        }
    }

    @Test
    @GraphDescription.Graph(value={"a:Person EATS b:Banana", "a EATS b:Apple"})
    public void ensurePeopleCanEatBananasAndApples() {
        Map graph = (Map)this.data.get();
        Node a = (Node)graph.get("a");
        Node b = (Node)graph.get("b");
        try (Transaction tx = graphdb.beginTx();){
            Assert.assertTrue((String)"Person label missing", (boolean)tx.getNodeById(a.getId()).hasLabel(Label.label((String)"Person")));
            Assert.assertTrue((String)"Banana label missing", (boolean)tx.getNodeById(b.getId()).hasLabel(Label.label((String)"Banana")));
            Assert.assertTrue((String)"Apple label missing", (boolean)tx.getNodeById(b.getId()).hasLabel(Label.label((String)"Apple")));
        }
    }

    @GraphDescription.Graph(value={"I know you"}, nodes={@GraphDescription.NODE(name="I", properties={@GraphDescription.PROP(key="name", value="me")})})
    private void verifyIKnowYou(String type, String myName) {
        Map graph = (Map)this.data.get();
        try (Transaction tx = graphdb.beginTx();){
            Assert.assertEquals((String)"Wrong graph size.", (long)2L, (long)graph.size());
            Node iNode = tx.getNodeById(((Node)graph.get("I")).getId());
            Assert.assertNotNull((String)"The node 'I' was not defined", (Object)iNode);
            Node you = tx.getNodeById(((Node)graph.get("you")).getId());
            Assert.assertNotNull((String)"The node 'you' was not defined", (Object)you);
            Assert.assertEquals((String)"'I' has wrong 'name'.", (Object)myName, (Object)iNode.getProperty("name"));
            Assert.assertEquals((String)"'you' has wrong 'name'.", (Object)"you", (Object)you.getProperty("name"));
            Iterator rels = iNode.getRelationships().iterator();
            Assert.assertTrue((String)"'I' has too few relationships", (boolean)rels.hasNext());
            Relationship rel = (Relationship)rels.next();
            Assert.assertEquals((String)"'I' is not related to 'you'", (Object)you, (Object)rel.getOtherNode(iNode));
            Assert.assertEquals((String)"Wrong relationship type.", (Object)type, (Object)rel.getType().name());
            Assert.assertFalse((String)"'I' has too many relationships", (boolean)rels.hasNext());
            rels = you.getRelationships().iterator();
            Assert.assertTrue((String)"'you' has too few relationships", (boolean)rels.hasNext());
            rel = (Relationship)rels.next();
            Assert.assertEquals((String)"'you' is not related to 'i'", (Object)iNode, (Object)rel.getOtherNode(you));
            Assert.assertEquals((String)"Wrong relationship type.", (Object)type, (Object)rel.getType().name());
            Assert.assertFalse((String)"'you' has too many relationships", (boolean)rels.hasNext());
            Assert.assertEquals((String)"wrong direction", (Object)iNode, (Object)rel.getStartNode());
        }
    }

    @BeforeClass
    public static void startDatabase() {
        managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        graphdb = managementService.database("neo4j");
    }

    @AfterClass
    public static void stopDatabase() {
        if (graphdb != null) {
            managementService.shutdown();
        }
        graphdb = null;
    }

    public GraphDatabaseService graphdb() {
        return graphdb;
    }
}

