/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.recovery;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.rule.TestDirectory;

@Neo4jLayoutExtension
class RecoveryLogIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementService managementService;

    RecoveryLogIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void transactionsRecoveryLogContainsTimeSpent() throws IOException {
        File[] txLogs;
        File tmpLogDir = this.testDirectory.directory("logs", new String[0]);
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).build();
        GraphDatabaseService db = this.managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            File[] node1 = tx.createNode();
            Node node2 = tx.createNode();
            node1.createRelationshipTo(node2, RelationshipType.withName((String)"likes"));
            tx.commit();
        }
        for (File file : txLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fileSystem).build().logFiles()) {
            this.fileSystem.copyToDirectory(file, tmpLogDir);
        }
        this.managementService.shutdown();
        for (File txLog : txLogs) {
            this.fileSystem.deleteFile(txLog);
        }
        for (File file : LogFilesBuilder.logFilesBasedOnlyBuilder((File)tmpLogDir, (FileSystemAbstraction)this.fileSystem).build().logFiles()) {
            this.fileSystem.moveToDirectory(file, this.databaseLayout.getTransactionLogsDirectory());
        }
        AssertableLogProvider provider = new AssertableLogProvider();
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setInternalLogProvider((LogProvider)provider).build();
        this.managementService.database("neo4j");
        provider.rawMessageMatcher().assertContains(Matchers.matchesPattern((String)".*Recovery completed.*time\\sspent.*"));
    }
}

