/*
 * Decompiled with CFR 0.152.
 */
package synchronization;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitorAdapter;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.EmbeddedDbmsRule;
import org.neo4j.test.rule.OtherThreadRule;

public class TestStartTransactionDuringLogRotation {
    @Rule
    public DbmsRule db = new EmbeddedDbmsRule(){

        protected void configure(DatabaseManagementServiceBuilder databaseFactory) {
            super.configure(databaseFactory);
            databaseFactory.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.mebiBytes((long)1L));
        }
    };
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2-" + this.getClass().getName());
    private ExecutorService executor;
    private CountDownLatch startLogRotationLatch;
    private CountDownLatch completeLogRotationLatch;
    private AtomicBoolean writerStopped;
    private Monitors monitors;
    private LogRotationMonitor rotationListener;
    private Label label;
    private Future<Void> rotationFuture;

    @Before
    public void setUp() throws InterruptedException {
        this.executor = Executors.newCachedThreadPool();
        this.startLogRotationLatch = new CountDownLatch(1);
        this.completeLogRotationLatch = new CountDownLatch(1);
        this.writerStopped = new AtomicBoolean();
        this.monitors = (Monitors)this.db.getDependencyResolver().resolveDependency(Monitors.class);
        this.rotationListener = new LogRotationMonitorAdapter(){

            public void startRotation(long currentLogVersion) {
                TestStartTransactionDuringLogRotation.this.startLogRotationLatch.countDown();
                try {
                    TestStartTransactionDuringLogRotation.this.completeLogRotationLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.monitors.addMonitorListener((Object)this.rotationListener, new String[0]);
        this.label = Label.label((String)"Label");
        this.rotationFuture = this.t2.execute(this.forceLogRotation((GraphDatabaseAPI)this.db));
        this.startLogRotationLatch.await();
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> forceLogRotation(GraphDatabaseAPI db) {
        return state -> {
            try (Transaction tx = db.beginTx();){
                tx.createNode(new Label[]{this.label}).setProperty("a", (Object)1);
                tx.commit();
            }
            ((LogRotation)db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile(LogAppendEvent.NULL);
            return null;
        };
    }

    @After
    public void tearDown() throws Exception {
        this.rotationFuture.get();
        this.writerStopped.set(true);
        this.executor.shutdown();
    }

    @Test(timeout=10000L)
    public void logRotationMustNotObstructStartingReadTransaction() {
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(0L);
            this.completeLogRotationLatch.countDown();
            tx.commit();
        }
    }

    @Test(timeout=10000L)
    public void logRotationMustNotObstructStartingWriteTransaction() {
        try (Transaction tx = this.db.beginTx();){
            tx.createNode();
            this.completeLogRotationLatch.countDown();
            tx.commit();
        }
    }
}

