/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockClient;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.OtherThreadRule;

public class GraphDatabaseShutdownTest {
    private GraphDatabaseAPI db;
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2");
    @Rule
    public final OtherThreadRule<Void> t3 = new OtherThreadRule("T3");
    private DatabaseManagementService managementService;

    @Before
    public void setUp() {
        this.db = this.newDb();
    }

    @After
    public void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    public void transactionShouldReleaseLocksWhenGraphDbIsBeingShutdown() {
        Locks locks = (Locks)this.db.getDependencyResolver().resolveDependency(Locks.class);
        Assert.assertEquals((long)0L, (long)GraphDatabaseShutdownTest.lockCount(locks));
        Exception exceptionThrownByTxClose = null;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            tx.acquireWriteLock((Entity)node);
            Assertions.assertThat((int)GraphDatabaseShutdownTest.lockCount(locks)).isGreaterThanOrEqualTo(1);
            this.managementService.shutdown();
            tx.createNode();
            tx.commit();
        }
        catch (Exception e) {
            exceptionThrownByTxClose = e;
        }
        Assertions.assertThat((Throwable)exceptionThrownByTxClose).isInstanceOf(TransactionTerminatedException.class);
        Assert.assertFalse((boolean)this.db.isAvailable(1L));
        Assert.assertEquals((long)0L, (long)GraphDatabaseShutdownTest.lockCount(locks));
    }

    @Test
    public void shouldBeAbleToShutdownWhenThereAreTransactionsWaitingForLocks() throws Exception {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        CountDownLatch nodeLockedLatch = new CountDownLatch(1);
        CountDownLatch shutdownCalled = new CountDownLatch(1);
        Future shutdownFuture = this.t2.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId()).addLabel(Label.label((String)"ABC"));
                nodeLockedLatch.countDown();
                this.t3.get().waitUntilWaiting(details -> details.isAt(CommunityLockClient.class, "acquireExclusive"));
                this.managementService.shutdown();
                shutdownCalled.countDown();
                tx.commit();
            }
            return null;
        });
        Future secondTxResult = this.t3.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                nodeLockedLatch.await();
                tx.getNodeById(node.getId()).addLabel(Label.label((String)"DEF"));
                shutdownCalled.await();
                tx.commit();
            }
            return null;
        });
        try {
            secondTxResult.get(60L, TimeUnit.SECONDS);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)e)).isInstanceOf(TransactionTerminatedException.class);
        }
        try {
            shutdownFuture.get();
            Assert.fail((String)"Should thrown exception since transaction should be canceled.");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)ExceptionUtils.getRootCause((Throwable)e)).isInstanceOf(TransactionTerminatedException.class);
        }
    }

    private static int lockCount(Locks locks) {
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        locks.accept((Locks.Visitor)lockCountVisitor);
        return lockCountVisitor.getLockCount();
    }

    private GraphDatabaseAPI newDb() {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }
}

