/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.index.label;

import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.recordstorage.TestRelType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configuration")
class TokenScanStoreRebuildIT {
    @Inject
    private GraphDatabaseService db;
    @Inject
    private DatabaseLayout layout;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DbmsController controller;

    TokenScanStoreRebuildIT() {
    }

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, (Object)true);
    }

    @Test
    void shouldReportCorrectEntityCountsOnRebuild() {
        int nbrOfNodes = 100;
        int nbrOfRelationships = 1000;
        this.createSomeData(nbrOfNodes, nbrOfRelationships);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        this.controller.restartDbms(builder -> {
            this.fs.deleteFile(this.layout.labelScanStore());
            this.fs.deleteFile(this.layout.relationshipTypeScanStore());
            builder.setInternalLogProvider((LogProvider)logProvider);
            return builder;
        });
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessagesOnce(new String[]{"No relationship type index found, this might just be first use. Preparing to rebuild.", "No label index found, this might just be first use. Preparing to rebuild.", "Rebuilding relationship type index, this may take a while", "Rebuilding label index, this may take a while", "Relationship type index rebuilt (roughly 1000 relationships)", "Label index rebuilt (roughly 100 nodes)"});
    }

    private void createSomeData(int nbrOfNodes, int nbrOfRelationships) {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < nbrOfNodes; ++i) {
                Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                if (i != 0) continue;
                for (int j = 0; j < nbrOfRelationships; ++j) {
                    node.createRelationshipTo(node, (RelationshipType)TestRelType.LOOP);
                }
            }
            tx.commit();
        }
    }
}

