/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.neo4j.annotations.documented.ReporterFactories;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleNodeValueClient;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

public abstract class IndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    IndexAccessor accessor;
    private final Map<Long, Value[]> committedValues = new HashMap<Long, Value[]>();

    IndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @Before
    public void before() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator populator = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        populator.create();
        populator.close(true, PageCursorTracer.NULL);
        this.accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig);
    }

    @After
    public void after() {
        try {
            this.accessor.consistencyCheck(ReporterFactories.throwingReporterFactory(), PageCursorTracer.NULL);
        }
        finally {
            this.accessor.drop();
            this.accessor.close();
        }
    }

    ValueType[] randomSetOfSupportedTypes() {
        Object[] supportedTypes = this.testSuite.supportedValueTypes();
        return (ValueType[])this.random.randomValues().selection(supportedTypes, 2, supportedTypes.length, false);
    }

    ValueType[] randomSetOfSupportedAndSortableTypes() {
        Object[] types = this.testSuite.supportedValueTypes();
        types = this.removeSpatialTypes((ValueType[])types);
        types = RandomValues.excluding((ValueType[])types, (ValueType[])new ValueType[]{ValueType.STRING, ValueType.STRING_ARRAY});
        types = (ValueType[])this.random.randomValues().selection(types, 2, types.length, false);
        return types;
    }

    private ValueType[] removeSpatialTypes(ValueType[] types) {
        return (ValueType[])Arrays.stream(types).filter(t -> !t.name().contains("POINT")).toArray(ValueType[]::new);
    }

    protected List<Long> query(IndexQuery ... predicates) throws Exception {
        try (IndexReader reader = this.accessor.newReader();){
            SimpleNodeValueClient nodeValueClient = new SimpleNodeValueClient();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodeValueClient, IndexQueryConstraints.unconstrained(), predicates);
            LinkedList<Long> list = new LinkedList<Long>();
            while (nodeValueClient.next()) {
                long entityId = nodeValueClient.reference;
                if (!this.passesFilter(entityId, predicates)) continue;
                list.add(entityId);
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    protected AutoCloseable query(SimpleNodeValueClient client, IndexOrder order, IndexQuery ... predicates) throws Exception {
        IndexReader reader = this.accessor.newReader();
        reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)client, IndexQueryConstraints.constrained((IndexOrder)order, (boolean)false), predicates);
        return reader;
    }

    List<Long> assertInOrder(IndexOrder order, IndexQuery ... predicates) throws Exception {
        List<Long> actualIds;
        if (order == IndexOrder.NONE) {
            actualIds = this.query(predicates);
        } else {
            SimpleNodeValueClient client = new SimpleNodeValueClient();
            try (AutoCloseable ignore = this.query(client, order, predicates);){
                actualIds = this.assertClientReturnValuesInOrder(client, order);
            }
        }
        return actualIds;
    }

    List<Long> assertClientReturnValuesInOrder(SimpleNodeValueClient client, IndexOrder order) {
        ArrayList<Long> seenIds = new ArrayList<Long>();
        Value[] prevValues = null;
        int count = 0;
        while (client.next()) {
            ++count;
            seenIds.add(client.reference);
            Value[] values = client.values;
            if (order == IndexOrder.ASCENDING) {
                this.assertLessThanOrEqualTo(prevValues, values);
            } else if (order == IndexOrder.DESCENDING) {
                this.assertLessThanOrEqualTo(values, prevValues);
            } else {
                Assert.fail((String)("Unexpected order " + order + " (count = " + count + ")"));
            }
            prevValues = values;
        }
        return seenIds;
    }

    IndexOrder[] orderCapability(IndexQuery ... predicates) {
        ValueCategory[] categories = new ValueCategory[predicates.length];
        for (int i = 0; i < predicates.length; ++i) {
            categories[i] = predicates[i].valueGroup().category();
        }
        return this.descriptor.getCapability().orderCapability(categories);
    }

    private void assertLessThanOrEqualTo(Value[] o1, Value[] o2) {
        if (o1 == null || o2 == null) {
            return;
        }
        int length = Math.min(o1.length, o2.length);
        for (int i = 0; i < length; ++i) {
            int compare = Values.COMPARATOR.compare(o1[i], o2[i]);
            ((AbstractIntegerAssert)Assertions.assertThat((int)compare).as("expected less than or equal to but was " + Arrays.toString(o1) + " and " + Arrays.toString(o2), new Object[0])).isLessThanOrEqualTo(0);
            if (compare == 0) continue;
            return;
        }
    }

    private boolean passesFilter(long entityId, IndexQuery[] predicates) {
        if (predicates.length == 1 && predicates[0] instanceof IndexQuery.ExistsPredicate) {
            return true;
        }
        Value[] values = this.committedValues.get(entityId);
        for (int i = 0; i < values.length; ++i) {
            IndexQuery predicate = predicates[i];
            if (predicate.valueGroup() != ValueGroup.GEOMETRY && predicate.valueGroup() != ValueGroup.GEOMETRY_ARRAY && (predicate.valueGroup() != ValueGroup.NUMBER || this.testSuite.supportFullValuePrecisionForNumbers()) || predicates[i].acceptsValue(values[i])) continue;
            return false;
        }
        return true;
    }

    void updateAndCommit(Collection<IndexEntryUpdate<?>> updates) throws IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
            block9: for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
                switch (update.updateMode()) {
                    case ADDED: 
                    case CHANGED: {
                        this.committedValues.put(update.getEntityId(), update.values());
                        continue block9;
                    }
                    case REMOVED: {
                        this.committedValues.remove(update.getEntityId());
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Unknown update mode " + update.updateMode());
            }
        }
    }
}

