/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.TestNodePropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    final IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());

    public SimpleIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        String failure = "The contrived failure";
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.markAsFailed(failure)), false);
        Assertions.assertThat((String)this.indexProvider.getPopulationFailure(this.descriptor, PageCursorTracer.NULL)).contains(new CharSequence[]{failure});
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.markAsFailed(failure);
            p.close(false, PageCursorTracer.NULL);
            Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(this.descriptor, PageCursorTracer.NULL));
        }), false);
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator p = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        p.close(false, PageCursorTracer.NULL);
        p.drop();
    }

    @Test
    public void shouldApplyUpdatesIdempotently() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        Value propertyValue = Values.of((Object)"value1");
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            long nodeId = 1L;
            IndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{propertyValue});
            p.add(Collections.singletonList(update), PageCursorTracer.NULL);
            try (IndexUpdater updater = p.newPopulatingUpdater((node, propertyId, cursorTracer) -> propertyValue, PageCursorTracer.NULL);){
                updater.process(update);
            }
        }));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig);
             IndexReader reader = accessor.newReader();
             NodeValueIterator nodes = new NodeValueIterator();){
            int propertyKeyId = this.descriptor.schema().getPropertyId();
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodes, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)propertyValue)});
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
        }
    }

    @Test
    public void shouldPopulateWithAllValues() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(this.updates(this.valueSet1), PageCursorTracer.NULL)));
        this.assertHasAllValues(this.valueSet1);
    }

    @Test
    public void shouldUpdateWithAllValuesDuringPopulation() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            try (IndexUpdater updater = p.newPopulatingUpdater(this::valueSet1Lookup, PageCursorTracer.NULL);){
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
                    updater.process(IndexEntryUpdate.add((long)entry.nodeId, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{entry.value}));
                }
            }
        }));
        this.assertHasAllValues(this.valueSet1);
    }

    @Test
    public void shouldPopulateAndUpdate() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(this.updates(this.valueSet1), PageCursorTracer.NULL)));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);){
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
                List<IndexEntryUpdate<?>> updates = this.updates(this.valueSet2);
                for (IndexEntryUpdate<?> update : updates) {
                    updater.process(update);
                }
            }
            try (IndexReader reader = accessor.newReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : Iterables.concat((Iterable[])new Iterable[]{this.valueSet1, this.valueSet2})) {
                    try (NodeValueIterator nodes = new NodeValueIterator();){
                        reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodes, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                        Assert.assertEquals((long)entry.nodeId, (long)nodes.next());
                        Assert.assertFalse((boolean)nodes.hasNext());
                    }
                }
            }
        }
    }

    @Test
    public void shouldPopulateAndRemoveEntriesWithSimilarMinimalSplitter() throws Exception {
        String prefix = "Work out your own salvation. Do not depend on others. ";
        int nbrOfNodes = 200;
        long nodeId = 0L;
        ArrayList<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> secondBatch = new ArrayList<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue>();
        for (int i = 0; i < nbrOfNodes; ++i) {
            secondBatch.add(new IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue(nodeId++, (Value)Values.stringValue((String)(prefix + i))));
        }
        ArrayList<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> firstBatch = new ArrayList<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue>();
        for (int i = 0; i < nbrOfNodes; ++i) {
            firstBatch.add(new IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue(nodeId++, (Value)Values.stringValue((String)(prefix + i + " " + i))));
        }
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            p.add(this.updates(firstBatch), PageCursorTracer.NULL);
            p.add(this.updates(secondBatch), PageCursorTracer.NULL);
        }));
        ArrayList<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> toRemove = new ArrayList<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue>();
        toRemove.addAll(firstBatch);
        toRemove.addAll(secondBatch);
        Collections.shuffle(toRemove);
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);){
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue nodeAndValue : toRemove) {
                    updater.process(IndexEntryUpdate.remove((long)nodeAndValue.nodeId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{nodeAndValue.value}));
                }
            }
            try (IndexReader reader = accessor.newReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue nodeAndValue : toRemove) {
                    NodeValueIterator nodes = new NodeValueIterator();
                    reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodes, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)nodeAndValue.value)});
                    boolean anyHits = false;
                    StringJoiner nodesStillLeft = new StringJoiner(", ", "[", "]");
                    while (nodes.hasNext()) {
                        anyHits = true;
                        nodesStillLeft.add(Long.toString(nodes.next()));
                    }
                    Assert.assertFalse((String)("Expected this query to have zero hits but found " + nodesStillLeft), (boolean)anyHits);
                }
            }
        }
    }

    private Value valueSet1Lookup(long nodeId, int propertyId, PageCursorTracer cursorTracer) {
        for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue x : this.valueSet1) {
            if (x.nodeId != nodeId) continue;
            return x.value;
        }
        return Values.NO_VALUE;
    }

    private void assertHasAllValues(List<IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> values) throws IOException, IndexNotApplicableKernelException {
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);
             IndexReader reader = accessor.newReader();){
            int propertyKeyId = this.descriptor.schema().getPropertyId();
            for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : values) {
                try (NodeValueIterator nodes = new NodeValueIterator();){
                    reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodes, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                    Assert.assertEquals((long)entry.nodeId, (long)nodes.next());
                    Assert.assertFalse((boolean)nodes.hasNext());
                }
            }
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends SimpleIndexPopulatorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1000, (int[])new int[]{100})));
        }

        @Test
        public void shouldProvidePopulatorThatEnforcesUniqueConstraints() throws Exception {
            Value value = Values.of((Object)"value1");
            int nodeId1 = 1;
            int nodeId2 = 2;
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                try {
                    p.add(Arrays.asList(IndexEntryUpdate.add((long)nodeId1, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{value}), IndexEntryUpdate.add((long)nodeId2, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{value})), PageCursorTracer.NULL);
                    TestNodePropertyAccessor propertyAccessor = new TestNodePropertyAccessor((long)nodeId1, this.descriptor.schema(), new Value[]{value});
                    propertyAccessor.addNode((long)nodeId2, this.descriptor.schema(), new Value[]{value});
                    p.scanCompleted(PhaseTracker.nullInstance, this.jobScheduler, PageCursorTracer.NULL);
                    p.verifyDeferredConstraints((NodePropertyAccessor)propertyAccessor);
                    Assert.fail((String)"expected exception");
                }
                catch (Exception e) {
                    Throwable root = ExceptionUtils.getRootCause((Throwable)e);
                    if (root instanceof IndexEntryConflictException) {
                        IndexEntryConflictException conflict = (IndexEntryConflictException)root;
                        Assert.assertEquals((long)nodeId1, (long)conflict.getExistingNodeId());
                        Assert.assertEquals((Object)ValueTuple.of((Value[])new Value[]{value}), (Object)conflict.getPropertyValues());
                        Assert.assertEquals((long)nodeId2, (long)conflict.getAddedNodeId());
                    }
                    throw e;
                }
            }), false);
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends SimpleIndexPopulatorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1000, (int[])new int[]{100})));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            long offset = this.valueSet1.size();
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(this.updates(this.valueSet1, 0L), PageCursorTracer.NULL);
                p.add(this.updates(this.valueSet1, offset), PageCursorTracer.NULL);
            }));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig);
                 IndexReader reader = accessor.newReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (IndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
                    try (NodeValueIterator nodes = new NodeValueIterator();){
                        reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)nodes, IndexQueryConstraints.unconstrained(), new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                        Assert.assertEquals((String)entry.value.toString(), (Object)Iterators.asSet((Object[])new Long[]{entry.nodeId, entry.nodeId + offset}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
                    }
                }
            }
        }
    }
}

