/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseFileHelper;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.DatabasePanicEventGenerator;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.PageCacheConfig;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class DatabaseTest {
    @Rule
    public DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs.get());
    @Rule
    public DatabaseRule databaseRule = new DatabaseRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private DatabaseLayout databaseLayout;

    @Before
    public void setUp() {
        this.databaseLayout = DatabaseLayout.ofFlat((File)this.directory.directory("neo4j", new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void databaseHealthShouldBeHealedOnStart() throws Throwable {
        Database database = null;
        try {
            DatabaseHealth databaseHealth = new DatabaseHealth((PanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), NullLogProvider.getInstance().getLog(DatabaseHealth.class));
            Dependencies dependencies = new Dependencies();
            dependencies.satisfyDependency((Object)databaseHealth);
            database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()), (DependencyResolver)dependencies);
            databaseHealth.panic(new Throwable());
            database.start();
            databaseHealth.assertHealthy(Throwable.class);
        }
        finally {
            if (database != null) {
                database.stop();
            }
        }
    }

    @Test
    public void dropDataOfNotStartedDatabase() {
        File customTxLogsRoot = this.directory.directory("customTxLogs", new String[0]);
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)customTxLogsRoot.toPath()).build();
        DatabaseLayout databaseLayout = DatabaseLayout.of((Config)cfg);
        Database database = this.databaseRule.getDatabase(databaseLayout, this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()));
        database.start();
        database.stop();
        Assert.assertNotEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseLayout.getTransactionLogsDirectory());
        Assert.assertTrue((boolean)this.fs.fileExists(databaseLayout.databaseDirectory()));
        Assert.assertTrue((boolean)this.fs.fileExists(databaseLayout.getTransactionLogsDirectory()));
        database.drop();
        Assert.assertFalse((boolean)this.fs.fileExists(databaseLayout.databaseDirectory()));
        Assert.assertFalse((boolean)this.fs.fileExists(databaseLayout.getTransactionLogsDirectory()));
    }

    @Test
    public void truncateNotStartedDatabase() {
        File customTxLogsRoot = this.directory.directory("truncateCustomTxLogs", new String[0]);
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)customTxLogsRoot.toPath()).build();
        DatabaseLayout databaseLayout = DatabaseLayout.of((Config)cfg);
        Database database = this.databaseRule.getDatabase(databaseLayout, (FileSystemAbstraction)this.fs, this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs));
        database.start();
        database.stop();
        File databaseDirectory = databaseLayout.databaseDirectory();
        File transactionLogsDirectory = databaseLayout.getTransactionLogsDirectory();
        Assert.assertTrue((boolean)this.fs.fileExists(databaseDirectory));
        Assert.assertTrue((boolean)this.fs.fileExists(transactionLogsDirectory));
        Object[] databaseFilesShouldExist = (File[])DatabaseFileHelper.filesToKeepOnTruncation((DatabaseLayout)databaseLayout).stream().filter(File::exists).toArray(File[]::new);
        database.truncate();
        Assert.assertTrue((boolean)this.fs.fileExists(databaseDirectory));
        Assert.assertTrue((boolean)this.fs.fileExists(transactionLogsDirectory));
        Object[] currentDatabaseFiles = databaseDirectory.listFiles();
        LogAssertions.assertThat((Object[])currentDatabaseFiles).contains(databaseFilesShouldExist);
    }

    @Test
    public void doNotFlushDataFilesOnDatabaseTruncate() {
        FilesCollectionPageCache pageCache = new FilesCollectionPageCache(this.pageCacheRule, this.fs);
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), (PageCache)pageCache);
        database.start();
        database.truncate();
        List removedFiles = pageCache.getPagedFiles().stream().filter(PagedFile::isDeleteOnClose).map(PagedFile::file).collect(Collectors.toList());
        DatabaseLayout databaseLayout = database.getDatabaseLayout();
        Set files = databaseLayout.storeFiles();
        files.removeAll(DatabaseFileHelper.filesToKeepOnTruncation((DatabaseLayout)databaseLayout));
        Object[] filesShouldBeDeleted = (File[])files.stream().filter(File::exists).toArray(File[]::new);
        LogAssertions.assertThat(removedFiles).contains(filesShouldBeDeleted);
    }

    @Test
    public void filesRecreatedAfterTruncate() {
        File customTxLogsRoot = this.directory.directory("truncateCustomTxLogs", new String[0]);
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)customTxLogsRoot.toPath()).build();
        DatabaseLayout databaseLayout = DatabaseLayout.of((Config)cfg);
        Database database = this.databaseRule.getDatabase(databaseLayout, this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()));
        database.start();
        File databaseDirectory = databaseLayout.databaseDirectory();
        File transactionLogsDirectory = databaseLayout.getTransactionLogsDirectory();
        Assert.assertTrue((boolean)this.fs.fileExists(databaseDirectory));
        Assert.assertTrue((boolean)this.fs.fileExists(transactionLogsDirectory));
        Object[] databaseFilesBeforeTruncate = this.fs.listFiles(databaseDirectory);
        Object[] logFilesBeforeTruncate = this.fs.listFiles(transactionLogsDirectory);
        database.truncate();
        Assert.assertTrue((boolean)this.fs.fileExists(databaseDirectory));
        Assert.assertTrue((boolean)this.fs.fileExists(transactionLogsDirectory));
        Object[] databaseFiles = this.fs.listFiles(databaseDirectory);
        Object[] logFiles = this.fs.listFiles(transactionLogsDirectory);
        LogAssertions.assertThat((Object[])databaseFilesBeforeTruncate).contains(databaseFiles);
        LogAssertions.assertThat((Object[])logFilesBeforeTruncate).contains(logFiles);
    }

    @Test
    public void noPageCacheFlushOnDatabaseDrop() throws Throwable {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        PageCacheConfig pageCacheConfig = PageCacheConfig.config().withTracer((PageCacheTracer)pageCacheTracer);
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get(), pageCacheConfig));
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), pageCache);
        database.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        long flushesBeforeClose = pageCacheTracer.flushes();
        database.drop();
        Assert.assertEquals((long)flushesBeforeClose, (long)pageCacheTracer.flushes());
    }

    @Test
    public void removeDatabaseDataAndLogsOnDrop() {
        File customTxLogsRoot = this.directory.directory("customTxLogs", new String[0]);
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homeDir().toPath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)customTxLogsRoot.toPath()).build();
        DatabaseLayout databaseLayout = DatabaseLayout.of((Config)cfg);
        Database database = this.databaseRule.getDatabase(databaseLayout, this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()));
        database.start();
        Assert.assertNotEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseLayout.getTransactionLogsDirectory());
        Assert.assertTrue((boolean)this.fs.fileExists(databaseLayout.databaseDirectory()));
        Assert.assertTrue((boolean)this.fs.fileExists(databaseLayout.getTransactionLogsDirectory()));
        database.drop();
        Assert.assertFalse((boolean)this.fs.fileExists(databaseLayout.databaseDirectory()));
        Assert.assertFalse((boolean)this.fs.fileExists(databaseLayout.getTransactionLogsDirectory()));
    }

    @Test
    public void flushDatabaseDataOnStop() throws Throwable {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        PageCacheConfig pageCacheConfig = PageCacheConfig.config().withTracer((PageCacheTracer)pageCacheTracer);
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get(), pageCacheConfig));
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), pageCache);
        database.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        long flushesBeforeClose = pageCacheTracer.flushes();
        database.stop();
        Assert.assertNotEquals((long)flushesBeforeClose, (long)pageCacheTracer.flushes());
    }

    @Test
    public void flushOfThePageCacheHappensOnlyOnceDuringShutdown() throws Throwable {
        PageCache realPageCache = this.pageCacheRule.getPageCache(this.fs.get());
        ArrayList files = new ArrayList();
        PageCache pageCache = (PageCache)Mockito.spy((Object)realPageCache);
        ((PageCache)Mockito.doAnswer(invocation -> {
            PagedFile file = (PagedFile)Mockito.spy((Object)realPageCache.map((File)invocation.getArgument(0, File.class), (VersionContextSupplier)invocation.getArgument(1, VersionContextSupplier.class), ((Integer)invocation.getArgument(2, Integer.class)).intValue(), (ImmutableSet)invocation.getArgument(3, ImmutableSet.class)));
            files.add(file);
            return file;
        }).when((Object)pageCache)).map((File)ArgumentMatchers.any(File.class), (VersionContextSupplier)ArgumentMatchers.any(VersionContextSupplier.class), ArgumentMatchers.anyInt(), (ImmutableSet)ArgumentMatchers.any());
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), pageCache);
        files.clear();
        database.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce((IOLimiter)ArgumentMatchers.any(IOLimiter.class));
        database.stop();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.UNLIMITED);
        for (PagedFile file : files) {
            ((PagedFile)Mockito.verify((Object)file, (VerificationMode)Mockito.atLeastOnce())).flushAndForce(IOLimiter.UNLIMITED);
        }
    }

    @Test
    public void flushOfThePageCacheOnShutdownHappensIfTheDbIsHealthy() throws Throwable {
        PageCache realPageCache = this.pageCacheRule.getPageCache(this.fs.get());
        ArrayList files = new ArrayList();
        PageCache pageCache = (PageCache)Mockito.spy((Object)realPageCache);
        ((PageCache)Mockito.doAnswer(invocation -> {
            PagedFile file = (PagedFile)Mockito.spy((Object)realPageCache.map((File)invocation.getArgument(0, File.class), (VersionContextSupplier)invocation.getArgument(1, VersionContextSupplier.class), ((Integer)invocation.getArgument(2, Integer.class)).intValue(), (ImmutableSet)invocation.getArgument(3, ImmutableSet.class)));
            files.add(file);
            return file;
        }).when((Object)pageCache)).map((File)ArgumentMatchers.any(File.class), (VersionContextSupplier)ArgumentMatchers.any(VersionContextSupplier.class), ArgumentMatchers.anyInt(), (ImmutableSet)ArgumentMatchers.any());
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), pageCache);
        files.clear();
        database.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        database.stop();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.UNLIMITED);
        for (PagedFile file : files) {
            ((PagedFile)Mockito.verify((Object)file, (VerificationMode)Mockito.atLeastOnce())).flushAndForce(IOLimiter.UNLIMITED);
        }
    }

    @Test
    public void flushOfThePageCacheOnShutdownDoesNotHappenIfTheDbIsUnhealthy() throws Throwable {
        Health health = (Health)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)health.isHealthy()).thenReturn((Object)false);
        PageCache pageCache = (PageCache)Mockito.spy((Object)this.pageCacheRule.getPageCache(this.fs.get()));
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)health);
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), pageCache, (DependencyResolver)dependencies);
        database.start();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce();
        database.stop();
        ((PageCache)Mockito.verify((Object)pageCache, (VerificationMode)Mockito.never())).flushAndForce(IOLimiter.UNLIMITED);
    }

    @Test
    public void logModuleSetUpError() {
        Config config = Config.defaults();
        IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
        RuntimeException openStoresError = new RuntimeException("Can't set up modules");
        ((IdGeneratorFactory)Mockito.doThrow((Throwable[])new Throwable[]{openStoresError}).when((Object)idGeneratorFactory)).create((PageCache)ArgumentMatchers.any(), (File)ArgumentMatchers.any(File.class), (IdType)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean(), (PageCursorTracer)ArgumentMatchers.any(), (ImmutableSet)ArgumentMatchers.any());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)logProvider, (LogProvider)logProvider);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{idGeneratorFactory, config, logService});
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), pageCache, (DependencyResolver)dependencies);
        try {
            database.start();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)openStoresError, (Object)ExceptionUtils.getRootCause((Throwable)e));
        }
        LogAssertions.assertThat((AssertableLogProvider)logProvider).forClass(Database.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithException("Exception occurred while starting the database. Trying to stop already started components.", (Throwable)openStoresError);
    }

    @Test
    public void shouldAlwaysShutdownLifeEvenWhenCheckPointingFails() throws Exception {
        FileSystemAbstraction fs = this.fs.get();
        PageCache pageCache = this.pageCacheRule.getPageCache(fs);
        Health databaseHealth = (Health)Mockito.mock(DatabaseHealth.class);
        Mockito.when((Object)databaseHealth.isHealthy()).thenReturn((Object)true);
        IOException ex = new IOException("boom!");
        ((Health)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)databaseHealth)).assertHealthy(IOException.class);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{databaseHealth});
        Database database = this.databaseRule.getDatabase(this.databaseLayout, fs, pageCache, (DependencyResolver)dependencies);
        database.start();
        try {
            database.stop();
            Assert.fail((String)"it should have thrown");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHaveDatabaseLogServiceInDependencyResolver() {
        Dependencies dependencies = new Dependencies();
        Database database = this.databaseRule.getDatabase(this.databaseLayout, this.fs.get(), this.pageCacheRule.getPageCache(this.fs.get()), (DependencyResolver)dependencies);
        database.start();
        try {
            LogService logService = (LogService)database.getDependencyResolver().resolveDependency(LogService.class);
            Assert.assertEquals((Object)database.getLogService(), (Object)logService);
            LogAssertions.assertThat((Object)logService).isInstanceOf(DatabaseLogService.class);
        }
        finally {
            database.stop();
        }
    }

    private static class FilesCollectionPageCache
    extends DelegatingPageCache {
        private final List<PagedFile> pagedFiles = new ArrayList<PagedFile>();

        FilesCollectionPageCache(PageCacheRule pageCacheRule, DefaultFileSystemRule fs) {
            super(pageCacheRule.getPageCache((FileSystemAbstraction)fs));
        }

        public PagedFile map(File file, VersionContextSupplier versionContextSupplier, int pageSize, ImmutableSet<OpenOption> openOptions) throws IOException {
            PagedFile pagedFile = super.map(file, versionContextSupplier, pageSize, openOptions);
            this.pagedFiles.add(pagedFile);
            return pagedFile;
        }

        List<PagedFile> getPagedFiles() {
            return this.pagedFiles;
        }
    }
}

