/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class ReadTestSupport
implements KernelAPIReadTestSupport {
    private final Map<Setting<?>, Object> settings = new HashMap();
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    <T> void addSetting(Setting<T> setting, T value) {
        this.settings.put(setting, value);
    }

    @Override
    public void setup(File storeDir, Consumer<GraphDatabaseService> create, Consumer<GraphDatabaseService> sysCreate) {
        TestDatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.newManagementServiceBuilder(storeDir);
        databaseManagementServiceBuilder.setConfig(this.settings);
        this.managementService = databaseManagementServiceBuilder.build();
        this.db = this.managementService.database("neo4j");
        GraphDatabaseService sysDb = this.managementService.database("system");
        create.accept(this.db);
        sysCreate.accept(sysDb);
    }

    protected TestDatabaseManagementServiceBuilder newManagementServiceBuilder(File storeDir) {
        return new TestDatabaseManagementServiceBuilder(storeDir).impermanent();
    }

    @Override
    public Kernel kernelToTest() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.db).getDependencyResolver();
        return (Kernel)resolver.resolveDependency(Kernel.class);
    }

    @Override
    public void tearDown() {
        this.managementService.shutdown();
        this.db = null;
    }
}

