/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@DbmsExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogFileIT {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private LogVersionRepository logVersionRepository;
    @Inject
    private TransactionIdStore transactionIdStore;

    TransactionLogFileIT() {
    }

    @Test
    void tracePageCacheAccessOnRotate() throws IOException {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withStoreId(StoreId.UNKNOWN).withDatabaseTracers(new DatabaseTracers(DatabaseTracer.NULL, LockTracer.NONE, (PageCacheTracer)cacheTracer)).build();
        this.life.add((Lifecycle)logFiles);
        this.life.start();
        Assertions.assertThat((long)cacheTracer.pins()).isZero();
        Assertions.assertThat((long)cacheTracer.unpins()).isZero();
        Assertions.assertThat((long)cacheTracer.pins()).isZero();
        LogFile logFile = logFiles.getLogFile();
        logFile.rotate();
        Assertions.assertThat((long)cacheTracer.pins()).isEqualTo(5L);
        Assertions.assertThat((long)cacheTracer.unpins()).isEqualTo(5L);
        Assertions.assertThat((long)cacheTracer.hits()).isEqualTo(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void trackTransactionLogFileMemory() throws IOException {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        LifeSupport life = new LifeSupport();
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withTransactionIdStore(this.transactionIdStore).withLogVersionRepository(this.logVersionRepository).withStoreId(StoreId.UNKNOWN).withMemoryTracker((MemoryTracker)memoryTracker).build();
        life.add((Lifecycle)logFiles);
        try {
            life.start();
            Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
            Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isGreaterThan(0L);
        }
        finally {
            life.stop();
            life.shutdown();
        }
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
        Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
    }
}

