/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.TokenScanReader;
import org.neo4j.internal.index.label.TokenScanStoreTest;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class LabelScanStoreStartupIT {
    private static final Label LABEL = Label.label((String)"testLabel");
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private RandomRule random;
    @Inject
    private LabelScanStore labelScanStore;
    @Inject
    private RecoveryCleanupWorkCollector workCollector;
    private int labelId;

    LabelScanStoreStartupIT() {
    }

    @Test
    void scanStoreStartWithoutExistentIndex() throws Throwable {
        this.labelScanStore.shutdown();
        this.workCollector.shutdown();
        LabelScanStoreStartupIT.deleteLabelScanStoreFiles(this.databaseAPI.databaseLayout());
        this.workCollector.init();
        this.labelScanStore.init();
        this.workCollector.start();
        this.labelScanStore.start();
        LabelScanStoreStartupIT.checkLabelScanStoreAccessible(this.labelScanStore);
    }

    @Test
    void scanStoreRecreateCorruptedIndexOnStartup() throws Throwable {
        this.createTestNode();
        long[] labels = this.readNodesForLabel(this.labelScanStore);
        Assertions.assertEquals((int)1, (int)labels.length, (String)"Label scan store see 1 label for node");
        this.labelScanStore.force(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
        this.labelScanStore.shutdown();
        this.workCollector.shutdown();
        this.corruptLabelScanStoreFiles(this.databaseAPI.databaseLayout());
        this.workCollector.init();
        this.labelScanStore.init();
        this.workCollector.start();
        this.labelScanStore.start();
        long[] rebuildLabels = this.readNodesForLabel(this.labelScanStore);
        Assertions.assertArrayEquals((long[])labels, (long[])rebuildLabels, (String)"Store should rebuild corrupted index");
    }

    private long[] readNodesForLabel(LabelScanStore labelScanStore) {
        return PrimitiveLongCollections.closingAsArray((PrimitiveLongResourceIterator)labelScanStore.newReader().entitiesWithToken(this.labelId, PageCursorTracer.NULL));
    }

    private void createTestNode() {
        try (Transaction transaction = this.databaseAPI.beginTx();){
            Node node = transaction.createNode(new Label[]{LABEL});
            KernelTransaction ktx = ((InternalTransaction)transaction).kernelTransaction();
            this.labelId = ktx.tokenRead().nodeLabel(LABEL.name());
            transaction.commit();
        }
    }

    private void scrambleFile(File file) throws IOException {
        TokenScanStoreTest.scrambleFile((Random)this.random.random(), (File)file);
    }

    private static File storeFile(DatabaseLayout databaseLayout) {
        return databaseLayout.labelScanStore();
    }

    private void corruptLabelScanStoreFiles(DatabaseLayout databaseLayout) throws IOException {
        this.scrambleFile(LabelScanStoreStartupIT.storeFile(databaseLayout));
    }

    private static void deleteLabelScanStoreFiles(DatabaseLayout databaseLayout) {
        Assertions.assertTrue((boolean)LabelScanStoreStartupIT.storeFile(databaseLayout).delete());
    }

    private static void checkLabelScanStoreAccessible(LabelScanStore labelScanStore) throws IOException {
        int labelId = 1;
        try (TokenScanWriter labelScanWriter = labelScanStore.newWriter(PageCursorTracer.NULL);){
            labelScanWriter.write(EntityTokenUpdate.tokenChanges((long)1L, (long[])new long[0], (long[])new long[]{labelId}));
        }
        TokenScanReader labelScanReader = labelScanStore.newReader();
        try (PrimitiveLongResourceIterator iterator = labelScanReader.entitiesWithToken(labelId, PageCursorTracer.NULL);){
            Assertions.assertEquals((long)1L, (long)iterator.next());
        }
    }
}

