/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class UpdateDeletedIndexIT {
    @Inject
    private GraphDatabaseAPI db;
    private static final String KEY = "key";
    private static final int NODES = 100;

    UpdateDeletedIndexIT() {
    }

    @Test
    void shouldHandleUpdateRemovalOfLabelConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, nodeId) -> tx.getNodeById(nodeId).removeLabel(TestLabels.LABEL_ONE));
    }

    @Test
    void shouldHandleDeleteNodeConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, nodeId) -> tx.getNodeById(nodeId).delete());
    }

    @Test
    void shouldHandleRemovePropertyConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, nodeId) -> tx.getNodeById(nodeId).removeProperty(KEY));
    }

    @Test
    void shouldHandleNodeDetachDeleteConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, nodeId) -> ((InternalTransaction)tx).kernelTransaction().dataWrite().nodeDetachDelete(nodeId));
    }

    private void shouldHandleIndexDropConcurrentlyWithOperation(NodeOperation operation) throws Throwable {
        long[] nodes = this.createNodes();
        IndexDefinition indexDefinition = this.createIndex();
        Race race = new Race();
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexByName(indexDefinition.getName()).drop();
                tx.commit();
            }
        }, 1);
        for (int i = 0; i < 100; ++i) {
            long nodeId = nodes[i];
            race.addContestant(Race.throwing(() -> {
                try (Transaction tx = this.db.beginTx();){
                    operation.run(tx, nodeId);
                    tx.commit();
                }
            }));
        }
        race.go();
    }

    private long[] createNodes() {
        long[] nodes = new long[100];
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node = tx.createNode(new Label[]{TestLabels.LABEL_ONE});
                node.setProperty(KEY, (Object)i);
                nodes[i] = node.getId();
            }
            tx.commit();
        }
        return nodes;
    }

    private IndexDefinition createIndex() {
        IndexDefinition indexDefinition;
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                tx.createNode(new Label[]{TestLabels.LABEL_ONE}).setProperty(KEY, (Object)i);
            }
            tx.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            indexDefinition = tx.schema().indexFor(TestLabels.LABEL_ONE).on(KEY).create();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexDefinition;
    }

    private static interface NodeOperation {
        public void run(Transaction var1, long var2) throws Exception;
    }
}

