/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelAPIParallelStress;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class KernelAPIParallelIndexScanStressIT {
    private static final int N_THREADS = 10;
    private static final int N_NODES = 10000;
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Kernel kernel;
    @Inject
    private RandomRule random;

    KernelAPIParallelIndexScanStressIT() {
    }

    @Test
    void shouldDoParallelIndexScans() throws Throwable {
        IndexDescriptor index3;
        IndexDescriptor index2;
        IndexDescriptor index1;
        try (Transaction tx2 = this.db.beginTx();){
            this.createLabeledNodes(tx2, 10000, "LABEL1", "prop");
            this.createLabeledNodes(tx2, 10000, "LABEL2", "prop");
            this.createLabeledNodes(tx2, 10000, "LABEL3", "prop");
            tx2.commit();
        }
        try (Transaction tx3 = this.db.beginTx();){
            index1 = this.unwrap(tx3.schema().indexFor(Label.label((String)"LABEL1")).on("prop").create());
            index2 = this.unwrap(tx3.schema().indexFor(Label.label((String)"LABEL2")).on("prop").create());
            index3 = this.unwrap(tx3.schema().indexFor(Label.label((String)"LABEL3")).on("prop").create());
            tx3.commit();
        }
        tx3 = this.db.beginTx();
        try {
            tx3.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
            tx3.commit();
        }
        finally {
            if (tx3 != null) {
                tx3.close();
            }
        }
        IndexReadSession[] indexes = new IndexReadSession[3];
        try (KernelTransaction tx4 = this.kernel.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            indexes[0] = KernelAPIParallelIndexScanStressIT.indexReadSession(tx4, index1);
            indexes[1] = KernelAPIParallelIndexScanStressIT.indexReadSession(tx4, index2);
            indexes[2] = KernelAPIParallelIndexScanStressIT.indexReadSession(tx4, index3);
            tx4.commit();
        }
        KernelAPIParallelStress.parallelStressInTx(this.kernel, 10, tx -> tx.cursors().allocateNodeValueIndexCursor(tx.pageCursorTracer()), (read, cursor) -> KernelAPIParallelIndexScanStressIT.indexSeek(read, cursor, indexes[this.random.nextInt(indexes.length)]));
    }

    private IndexDescriptor unwrap(IndexDefinition indexDefinition) {
        return ((IndexDefinitionImpl)indexDefinition).getIndexReference();
    }

    private static IndexReadSession indexReadSession(KernelTransaction tx, IndexDescriptor index) throws IndexNotFoundKernelException {
        return tx.dataRead().indexReadSession(index);
    }

    private void createLabeledNodes(Transaction tx, int nNodes, String labelName, String propKey) {
        for (int i = 0; i < nNodes; ++i) {
            Node node = tx.createNode();
            node.addLabel(Label.label((String)labelName));
            node.setProperty(propKey, (Object)i);
        }
    }

    private static Runnable indexSeek(Read read, NodeValueIndexCursor cursor, IndexReadSession index) {
        return () -> {
            try {
                IndexQuery.ExistsPredicate query = IndexQuery.exists((int)index.reference().schema().getPropertyIds()[0]);
                read.nodeIndexSeek(index, cursor, IndexQueryConstraints.unorderedValues(), new IndexQuery[]{query});
                int n = 0;
                while (cursor.next()) {
                    ++n;
                }
                Assertions.assertEquals((int)10000, (int)n, (String)"correct number of nodes");
            }
            catch (KernelException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

