/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.index.schema.FailingGenericNativeIndexProviderFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class DbIndexesFailureMessageIT
extends KernelIntegrationTest {
    private final AtomicBoolean failNextIndexPopulation = new AtomicBoolean();

    DbIndexesFailureMessageIT() {
    }

    @Test
    void listAllIndexesWithFailedIndex() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int failedLabel = transaction.tokenWrite().labelGetOrCreateForName("Fail");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        this.failNextIndexPopulation.set(true);
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)failedLabel, (int[])new int[]{propertyKeyId1});
        IndexDescriptor index = transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, "fail foo index");
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES));
        }
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexDetails"})).id(), (AnyValue[])new TextValue[]{Values.stringValue((String)index.getName())}, ProcedureCallContext.EMPTY);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stream.hasNext());
        AnyValue[] result = (AnyValue[])stream.next();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stream.hasNext());
        this.commit();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.longValue((long)index.getId()), (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"fail foo index"), (Object)result[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"FAILED"), (Object)result[2]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.doubleValue((double)0.0), (Object)result[3]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"NONUNIQUE"), (Object)result[4]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"BTREE"), (Object)result[5]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)"NODE"), (Object)result[6]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"Fail")}), (Object)result[7]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)"foo")}), (Object)result[8]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Values.stringValue((String)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName()), (Object)result[9]);
        this.assertMapsEqual(index.getIndexConfig().asMap(), (MapValue)result[10]);
        Assertions.assertThat((String)((TextValue)result[11]).stringValue()).contains(new CharSequence[]{"java.lang.RuntimeException: Fail on update during population"});
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)result.length);
    }

    @Test
    void indexDetailsWithNonExistingIndex() {
        ProcedureException exception = (ProcedureException)org.junit.jupiter.api.Assertions.assertThrows(ProcedureException.class, () -> this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexDetails"})).id(), (AnyValue[])new TextValue[]{Values.stringValue((String)"MyIndex")}, ProcedureCallContext.EMPTY));
        org.junit.jupiter.api.Assertions.assertEquals((Object)exception.getMessage(), (Object)"Could not find index with name \"MyIndex\"");
    }

    private void assertMapsEqual(Map<String, Value> expected, MapValue actual) {
        org.junit.jupiter.api.Assertions.assertEquals((int)expected.size(), (int)actual.size());
        expected.forEach((k, v) -> {
            AnyValue value = actual.get(k);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)value);
            org.junit.jupiter.api.Assertions.assertEquals((Object)v, (Object)value);
        });
        actual.foreach((k, v) -> {
            Value value = (Value)expected.get(k);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)value);
            org.junit.jupiter.api.Assertions.assertEquals((Object)v, (Object)value);
        });
    }

    @Override
    protected TestDatabaseManagementServiceBuilder createGraphDatabaseFactory(File databaseRootDir) {
        return super.createGraphDatabaseFactory(databaseRootDir).removeExtensions(TestDatabaseManagementServiceBuilder.INDEX_PROVIDERS_FILTER).noOpSystemGraphInitializer().addExtension((ExtensionFactory)new FailingGenericNativeIndexProviderFactory(new FailingGenericNativeIndexProviderFactory.FailureType[]{FailingGenericNativeIndexProviderFactory.FailureType.POPULATION}));
    }
}

