/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;

@EphemeralNeo4jLayoutExtension
class TestIdReuse {
    @Inject
    private EphemeralFileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;

    TestIdReuse() {
    }

    @Test
    void makeSureIdsGetsReusedForPropertyStore() {
        this.makeSureIdsGetsReused(this.databaseLayout.propertyStore(), 10, 200);
    }

    @Test
    void makeSureIdsGetsReusedForArrayStore() {
        long[] array = new long[500];
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0xFFFFFFFFFFFFL + (long)i;
        }
        this.makeSureIdsGetsReused(this.databaseLayout.propertyArrayStore(), array, 20);
    }

    @Test
    void makeSureIdsGetsReusedForStringStore() {
        Object string = "something";
        for (int i = 0; i < 100; ++i) {
            string = (String)string + "something else " + i;
        }
        this.makeSureIdsGetsReused(this.databaseLayout.propertyStringStore(), string, 20);
    }

    private void makeSureIdsGetsReused(File storeFile, Object value, int iterations) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)this.fileSystem).impermanent().build();
        GraphDatabaseService db = managementService.database("neo4j");
        for (int i = 0; i < 5; ++i) {
            this.setAndRemoveSomeProperties(db, value);
        }
        managementService.shutdown();
        long sizeBefore = storeFile.length();
        DatabaseManagementService impermanentManagement = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)this.fileSystem).impermanent().build();
        db = impermanentManagement.database("neo4j");
        for (int i = 0; i < iterations; ++i) {
            this.setAndRemoveSomeProperties(db, value);
        }
        impermanentManagement.shutdown();
        Assertions.assertEquals((long)sizeBefore, (long)storeFile.length());
    }

    private void setAndRemoveSomeProperties(GraphDatabaseService graphDatabaseService, Object value) {
        Node commonNode;
        try (Transaction transaction = graphDatabaseService.beginTx();){
            commonNode = transaction.createNode();
            for (int i = 0; i < 10; ++i) {
                commonNode.setProperty("key" + i, value);
            }
            transaction.commit();
        }
        transaction = graphDatabaseService.beginTx();
        try {
            Node txNode = transaction.getNodeById(commonNode.getId());
            for (int i = 0; i < 10; ++i) {
                txNode.removeProperty("key" + i);
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

