/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;

@ExtendWith(value={RandomExtension.class})
public abstract class AbstractIndexProvidedOrderTest
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static final int N_NODES = 10000;
    private static final int N_ITERATIONS = 100;
    @Inject
    RandomRule randomRule;
    private TreeSet<NodeValueTuple> singlePropValues = new TreeSet(ValueTuple.COMPARATOR);
    private TreeSet<NodeValueTuple> doublePropValues = new TreeSet(ValueTuple.COMPARATOR);
    private ValueType[] targetedTypes;
    private IndexDescriptor indexNodeProp;

    @Override
    public ReadTestSupport newTestSupport() {
        ReadTestSupport readTestSupport = new ReadTestSupport();
        readTestSupport.addSetting(GraphDatabaseSettings.default_schema_provider, this.getSchemaIndex().providerName());
        return readTestSupport;
    }

    abstract GraphDatabaseSettings.SchemaIndex getSchemaIndex();

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            this.indexNodeProp = this.unwrap(tx.schema().indexFor(Label.label((String)"Node")).on("prop").create());
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").on("prip").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        RandomValues randomValues = this.randomRule.randomValues();
        Object[] allExceptNonOrderable = RandomValues.excluding((ValueType[])new ValueType[]{ValueType.STRING, ValueType.STRING_ARRAY, ValueType.GEOGRAPHIC_POINT, ValueType.GEOGRAPHIC_POINT_ARRAY, ValueType.GEOGRAPHIC_POINT_3D, ValueType.GEOGRAPHIC_POINT_3D_ARRAY, ValueType.CARTESIAN_POINT, ValueType.CARTESIAN_POINT_ARRAY, ValueType.CARTESIAN_POINT_3D, ValueType.CARTESIAN_POINT_3D_ARRAY});
        this.targetedTypes = (ValueType[])randomValues.selection(allExceptNonOrderable, 1, allExceptNonOrderable.length, false);
        this.targetedTypes = this.ensureHighEnoughCardinality(this.targetedTypes);
        try (Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < 10000; ++i) {
                Value pripValue;
                Value propValue;
                NodeValueTuple doubleValue;
                NodeValueTuple singleValue;
                Node node = tx.createNode(new Label[]{Label.label((String)"Node")});
                do {
                    propValue = randomValues.nextValueOfTypes(this.targetedTypes);
                    pripValue = randomValues.nextValueOfTypes(this.targetedTypes);
                    singleValue = new NodeValueTuple(node.getId(), propValue);
                    doubleValue = new NodeValueTuple(node.getId(), propValue, pripValue);
                } while (this.singlePropValues.contains((Object)singleValue) || this.doublePropValues.contains((Object)doubleValue));
                this.singlePropValues.add(singleValue);
                this.doublePropValues.add(doubleValue);
                node.setProperty("prop", propValue.asObject());
                node.setProperty("prip", pripValue.asObject());
            }
            tx.commit();
        }
    }

    private IndexDescriptor unwrap(IndexDefinition indexDefinition) {
        return ((IndexDefinitionImpl)indexDefinition).getIndexReference();
    }

    @Test
    void shouldProvideResultInOrderIfCapable() throws KernelException {
        int prop = this.token.propertyKey("prop");
        RandomValues randomValues = this.randomRule.randomValues();
        IndexReadSession index = this.read.indexReadSession(this.indexNodeProp);
        for (int i = 0; i < 100; ++i) {
            IndexOrder[] order;
            ValueType type = (ValueType)randomValues.among((Object[])this.targetedTypes);
            for (IndexOrder indexOrder : order = index.reference().getCapability().orderCapability(new ValueCategory[]{type.valueGroup.category()})) {
                if (indexOrder == IndexOrder.NONE) continue;
                NodeValueTuple from = new NodeValueTuple(Long.MIN_VALUE, randomValues.nextValueOfType(type));
                NodeValueTuple to = new NodeValueTuple(Long.MAX_VALUE, randomValues.nextValueOfType(type));
                if (ValueTuple.COMPARATOR.compare(from, to) > 0) {
                    NodeValueTuple tmp = from;
                    from = to;
                    to = tmp;
                }
                boolean fromInclusive = randomValues.nextBoolean();
                boolean toInclusive = randomValues.nextBoolean();
                IndexQuery.RangePredicate range = IndexQuery.range((int)prop, (Value)from.getOnlyValue(), (boolean)fromInclusive, (Value)to.getOnlyValue(), (boolean)toInclusive);
                try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor(PageCursorTracer.NULL);){
                    this.read.nodeIndexSeek(index, node, IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)false), new IndexQuery[]{range});
                    List<Long> expectedIdsInOrder = this.expectedIdsInOrder(from, fromInclusive, to, toInclusive, indexOrder);
                    ArrayList<Long> actualIdsInOrder = new ArrayList<Long>();
                    while (node.next()) {
                        actualIdsInOrder.add(node.nodeReference());
                    }
                    Assertions.assertEquals(expectedIdsInOrder, actualIdsInOrder, (String)("actual node ids not in same order as expected for value type " + type));
                }
            }
        }
    }

    private List<Long> expectedIdsInOrder(NodeValueTuple from, boolean fromInclusive, NodeValueTuple to, boolean toInclusive, IndexOrder indexOrder) {
        List<Long> expectedIdsInOrder = this.singlePropValues.subSet(from, fromInclusive, to, toInclusive).stream().map(NodeValueTuple::nodeId).collect(Collectors.toList());
        if (indexOrder == IndexOrder.DESCENDING) {
            Collections.reverse(expectedIdsInOrder);
        }
        return expectedIdsInOrder;
    }

    private ValueType[] ensureHighEnoughCardinality(ValueType[] targetedTypes) {
        ValueType[] lowCardinalityArray = new ValueType[]{ValueType.BOOLEAN, ValueType.BYTE, ValueType.BOOLEAN_ARRAY};
        ArrayList<ValueType> typesOfLowCardinality = new ArrayList<ValueType>(Arrays.asList(lowCardinalityArray));
        for (ValueType targetedType : targetedTypes) {
            if (typesOfLowCardinality.contains(targetedType)) continue;
            return targetedTypes;
        }
        ArrayList<ValueType> result = new ArrayList<ValueType>(Arrays.asList(targetedTypes));
        ValueType highCardinalityType = (ValueType)this.randomRule.randomValues().among((Object[])RandomValues.excluding((ValueType[])lowCardinalityArray));
        result.add(highCardinalityType);
        return result.toArray(new ValueType[0]);
    }

    private static class NodeValueTuple
    extends ValueTuple {
        private final long nodeId;

        private NodeValueTuple(long nodeId, Value ... values) {
            super(values);
            this.nodeId = nodeId;
        }

        long nodeId() {
            return this.nodeId;
        }
    }
}

