/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestKernelReadTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipSelection;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class KernelReadTracerTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private long foo;
    private long bar;
    private long bare;
    private long has;
    private long is;
    private IndexDescriptor index;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        Node deleted;
        try (Transaction tx = graphDb.beginTx();){
            Node foo = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = tx.createNode(new Label[]{Label.label((String)"Bar")});
            tx.createNode(new Label[]{Label.label((String)"Baz")});
            tx.createNode(new Label[]{Label.label((String)"Bar"), Label.label((String)"Baz")});
            deleted = tx.createNode();
            Node bare = tx.createNode();
            this.has = foo.createRelationshipTo(bar, RelationshipType.withName((String)"HAS")).getId();
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"HAS"));
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"IS"));
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"HAS"));
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"HAS"));
            this.is = bar.createRelationshipTo(bare, RelationshipType.withName((String)"IS")).getId();
            this.foo = foo.getId();
            this.bar = bar.getId();
            this.bare = bare.getId();
            foo.setProperty("p1", (Object)1);
            foo.setProperty("p2", (Object)2);
            foo.setProperty("p3", (Object)3);
            foo.setProperty("p4", (Object)4);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            this.index = ((IndexDefinitionImpl)tx.schema().indexFor(Label.label((String)"Foo")).on("p1").create()).getIndexReference();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            tx.getNodeById(deleted.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldTraceAllNodesScan() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        ArrayList<TestKernelReadTracer.TraceEvent> expectedEvents = new ArrayList<TestKernelReadTracer.TraceEvent>();
        expectedEvents.add(TestKernelReadTracer.ON_ALL_NODES_SCAN);
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);){
            nodes.setTracer((KernelReadTracer)tracer);
            this.read.allNodesScan(nodes);
            while (nodes.next()) {
                expectedEvents.add(TestKernelReadTracer.OnNode(nodes.nodeReference()));
            }
        }
        tracer.assertEvents(expectedEvents);
    }

    @Test
    void shouldTraceSingleNode() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (NodeCursor cursor = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleNode(this.foo, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(this.foo));
            this.read.singleNode(this.bar, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(this.bar));
            this.read.singleNode(this.bare, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(this.bare));
        }
    }

    @Test
    void shouldStopAndRestartTracing() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (NodeCursor cursor = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleNode(this.foo, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(this.foo));
            cursor.removeTracer();
            this.read.singleNode(this.bar, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleNode(this.bare, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(this.bare));
        }
    }

    @Test
    void shouldTraceLabelScan() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        int barId = this.token.labelGetOrCreateForName("Bar");
        ArrayList<TestKernelReadTracer.TraceEvent> expectedEvents = new ArrayList<TestKernelReadTracer.TraceEvent>();
        expectedEvents.add(TestKernelReadTracer.OnLabelScan(barId));
        try (NodeLabelIndexCursor cursor = this.cursors.allocateNodeLabelIndexCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.nodeLabelScan(barId, cursor, IndexOrder.NONE);
            while (cursor.next()) {
                expectedEvents.add(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            }
        }
        tracer.assertEvents(expectedEvents);
    }

    @Test
    void shouldTraceIndexSeek() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (NodeValueIndexCursor cursor = this.cursors.allocateNodeValueIndexCursor(PageCursorTracer.NULL);){
            int p1 = this.token.propertyKey("p1");
            IndexReadSession session = this.read.indexReadSession(this.index);
            this.assertIndexSeekTracing(tracer, cursor, session, IndexOrder.NONE, p1);
            this.assertIndexSeekTracing(tracer, cursor, session, IndexOrder.ASCENDING, p1);
        }
    }

    private void assertIndexSeekTracing(TestKernelReadTracer tracer, NodeValueIndexCursor cursor, IndexReadSession session, IndexOrder order, int prop) throws KernelException {
        cursor.setTracer((KernelReadTracer)tracer);
        this.read.nodeIndexSeek(session, cursor, IndexQueryConstraints.constrained((IndexOrder)order, (boolean)false), new IndexQuery[]{IndexQuery.range((int)prop, (Number)0, (boolean)false, (Number)10, (boolean)false)});
        tracer.assertEvents(TestKernelReadTracer.OnIndexSeek());
        Assertions.assertTrue((boolean)cursor.next());
        tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
        Assertions.assertFalse((boolean)cursor.next());
        tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
    }

    @Test
    void shouldTraceSingleRelationship() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (RelationshipScanCursor cursor = this.cursors.allocateRelationshipScanCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleRelationship(this.has, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(this.has));
            cursor.removeTracer();
            this.read.singleRelationship(this.is, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleRelationship(this.is, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(this.is));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceRelationshipTraversal() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);
             RelationshipTraversalCursor cursor = this.cursors.allocateRelationshipTraversalCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleNode(this.foo, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.relationships(cursor, RelationshipSelection.ALL_RELATIONSHIPS);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            cursor.removeTracer();
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
            cursor.setTracer((KernelReadTracer)tracer);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertTrue((boolean)cursor.next());
            tracer.clear();
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceLazySelectionRelationshipTraversal() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);
             RelationshipTraversalCursor cursor = this.cursors.allocateRelationshipTraversalCursor(PageCursorTracer.NULL);){
            cursor.setTracer((KernelReadTracer)tracer);
            this.read.singleNode(this.foo, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            int type = this.token.relationshipType("HAS");
            nodeCursor.relationships(cursor, RelationshipSelection.selection((int)type, (Direction)Direction.OUTGOING));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            cursor.removeTracer();
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
            cursor.setTracer((KernelReadTracer)tracer);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.clear();
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTracePropertyAccess() {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor(PageCursorTracer.NULL);
             PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            propertyCursor.setTracer((KernelReadTracer)tracer);
            this.read.singleNode(this.foo, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assertions.assertTrue((boolean)propertyCursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnProperty(propertyCursor.propertyKey()));
            Assertions.assertTrue((boolean)propertyCursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnProperty(propertyCursor.propertyKey()));
            propertyCursor.removeTracer();
            Assertions.assertTrue((boolean)propertyCursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
            propertyCursor.setTracer((KernelReadTracer)tracer);
            Assertions.assertTrue((boolean)propertyCursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnProperty(propertyCursor.propertyKey()));
            Assertions.assertFalse((boolean)propertyCursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }
}

