/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.memory.MemoryTracker;

public class ManagedTestCursors
implements CursorFactory {
    private final List<Cursor> allCursors = new ArrayList<Cursor>();
    private final CursorFactory cursors;

    ManagedTestCursors(CursorFactory c) {
        this.cursors = c;
    }

    void assertAllClosedAndReset() {
        for (Cursor n : this.allCursors) {
            if (n.isClosed()) continue;
            Assertions.fail((String)("The Cursor " + n + " was not closed properly."));
        }
        this.allCursors.clear();
    }

    public NodeCursor allocateNodeCursor(PageCursorTracer cursorTracer) {
        NodeCursor n = this.cursors.allocateNodeCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeCursor allocateFullAccessNodeCursor(PageCursorTracer cursorTracer) {
        NodeCursor n = this.cursors.allocateFullAccessNodeCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateRelationshipScanCursor(PageCursorTracer cursorTracer) {
        RelationshipScanCursor n = this.cursors.allocateRelationshipScanCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipScanCursor allocateFullAccessRelationshipScanCursor(PageCursorTracer cursorTracer) {
        RelationshipScanCursor n = this.cursors.allocateFullAccessRelationshipScanCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTraversalCursor allocateRelationshipTraversalCursor(PageCursorTracer cursorTracer) {
        RelationshipTraversalCursor n = this.cursors.allocateRelationshipTraversalCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocatePropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        PropertyCursor n = this.cursors.allocatePropertyCursor(cursorTracer, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public PropertyCursor allocateFullAccessPropertyCursor(PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
        PropertyCursor n = this.cursors.allocateFullAccessPropertyCursor(cursorTracer, memoryTracker);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(PageCursorTracer cursorTracer) {
        NodeValueIndexCursor n = this.cursors.allocateNodeValueIndexCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(PageCursorTracer cursorTracer) {
        NodeLabelIndexCursor n = this.cursors.allocateNodeLabelIndexCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipIndexCursor allocateRelationshipIndexCursor(PageCursorTracer cursorTracer) {
        RelationshipIndexCursor n = this.cursors.allocateRelationshipIndexCursor(cursorTracer);
        this.allCursors.add((Cursor)n);
        return n;
    }

    public RelationshipTypeIndexCursor allocateRelationshipTypeIndexCursor() {
        RelationshipTypeIndexCursor n = this.cursors.allocateRelationshipTypeIndexCursor();
        this.allCursors.add((Cursor)n);
        return n;
    }
}

