/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class CommitContentionTest {
    @Inject
    private TestDirectory testDirectory;
    private final Semaphore semaphore1 = new Semaphore(1);
    private final Semaphore semaphore2 = new Semaphore(1);
    private final AtomicReference<Exception> reference = new AtomicReference();
    private GraphDatabaseService db;
    private DatabaseManagementService managementService;

    CommitContentionTest() {
    }

    @BeforeEach
    void before() throws Exception {
        this.semaphore1.acquire();
        this.semaphore2.acquire();
        this.db = this.createDb();
    }

    @AfterEach
    void after() {
        this.managementService.shutdown();
    }

    @Test
    void shouldNotContendOnCommitWhenPushingUpdates() throws Exception {
        Thread thread = this.startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes();
        this.runAndFinishSecondTransaction();
        thread.join();
        this.assertNoFailures();
    }

    private void assertNoFailures() {
        Exception e = this.reference.get();
        if (e != null) {
            throw new AssertionError((Object)e);
        }
    }

    private void runAndFinishSecondTransaction() {
        this.createNode();
        this.signalSecondTransactionFinished();
    }

    private void createNode() {
        try (Transaction transaction = this.db.beginTx();){
            transaction.createNode();
            transaction.commit();
        }
    }

    private Thread startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes() throws InterruptedException {
        Thread thread = new Thread(this::createNode);
        thread.start();
        this.waitForFirstTransactionToStartPushing();
        return thread;
    }

    private GraphDatabaseService createDb() {
        Config cfg = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.absolutePath().toPath());
        this.managementService = new DatabaseManagementServiceFactory(DbmsInfo.COMMUNITY, globalModule -> new CommunityEditionModule((GlobalModule)globalModule){

            public DatabaseTransactionStats createTransactionMonitor() {
                return new SkipTransactionDatabaseStats();
            }
        }).build(cfg, (ExternalDependencies)GraphDatabaseDependencies.newDependencies().dependencies((DependencyResolver)TestDatabaseIdRepository.noOpSystemGraphInitializer((Config)cfg)));
        return this.managementService.database((String)Config.defaults().get(GraphDatabaseSettings.default_database));
    }

    private void waitForFirstTransactionToStartPushing() throws InterruptedException {
        if (!this.semaphore1.tryAcquire(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("First transaction never started pushing");
        }
    }

    private void signalFirstTransactionStartedPushing() {
        this.semaphore1.release();
    }

    private void signalSecondTransactionFinished() {
        this.semaphore2.release();
    }

    private void waitForSecondTransactionToFinish() {
        try {
            boolean acquired = this.semaphore2.tryAcquire(10L, TimeUnit.SECONDS);
            if (!acquired) {
                this.reference.set(new IllegalStateException("Second transaction never finished"));
            }
        }
        catch (InterruptedException e) {
            this.reference.set(e);
        }
    }

    private class SkipTransactionDatabaseStats
    extends DatabaseTransactionStats {
        boolean skip;

        private SkipTransactionDatabaseStats() {
        }

        public void transactionFinished(boolean committed, boolean write) {
            super.transactionFinished(committed, write);
            if (committed) {
                if (this.skip) {
                    return;
                }
                this.skip = true;
                CommitContentionTest.this.signalFirstTransactionStartedPushing();
                CommitContentionTest.this.waitForSecondTransactionToFinish();
            }
        }
    }
}

