/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.ClassGuardedAdversary;
import org.neo4j.adversaries.CountingAdversary;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointerImpl;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.recovery.RecoveryExtension;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.MemoryPools;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.AdversarialPageCacheGraphDatabaseFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.time.Clocks;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class DatabaseRecoveryIT {
    private static final String[] TOKENS = new String[]{"Token1", "Token2", "Token3", "Token4", "Token5"};
    @Inject
    private TestDirectory directory;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private RandomRule random;
    @RegisterExtension
    static final PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private DatabaseManagementService managementService;

    DatabaseRecoveryIT() {
    }

    @AfterEach
    void cleanUp() {
        if (this.managementService != null) {
            this.managementService.shutdown();
            this.managementService = null;
        }
    }

    @Test
    void idGeneratorsRebuildAfterRecovery() throws IOException {
        GraphDatabaseService database = this.startDatabase(this.directory.homeDir());
        int numberOfNodes = 10;
        try (Transaction transaction = database.beginTx();){
            for (int nodeIndex = 0; nodeIndex < numberOfNodes; ++nodeIndex) {
                transaction.createNode();
            }
            transaction.commit();
        }
        DatabaseLayout restoreDbLayout = this.copyStore();
        GraphDatabaseService recoveredDatabase = this.startDatabase(restoreDbLayout.getNeo4jLayout().homeDirectory());
        try (Transaction tx = recoveredDatabase.beginTx();){
            Assertions.assertEquals((long)numberOfNodes, (long)Iterables.count((Iterable)tx.getAllNodes()));
            tx.createNode();
        }
    }

    @Test
    void reportProgressOnRecovery() throws IOException {
        GraphDatabaseService database = this.startDatabase(this.directory.homeDir());
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                transaction.createNode();
                transaction.commit();
                continue;
            }
        }
        DatabaseLayout restoreDbLayout = this.copyStore();
        DatabaseManagementService recoveredService = this.getManagementService(restoreDbLayout.getNeo4jLayout().homeDirectory());
        GraphDatabaseService recoveredDatabase = recoveredService.database("neo4j");
        try (Transaction tx = recoveredDatabase.beginTx();){
            Assertions.assertEquals((long)10L, (long)Iterables.count((Iterable)tx.getAllNodes()));
        }
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"10% completed", "100% completed"});
        recoveredService.shutdown();
    }

    @Test
    void shouldRecoverIdsCorrectlyWhenWeCreateAndDeleteANodeInTheSameRecoveryRun() throws IOException {
        Node node;
        GraphDatabaseService database = this.startDatabase(this.directory.homeDir());
        Label testLabel = Label.label((String)"testLabel");
        String propertyToDelete = "propertyToDelete";
        String validPropertyName = "validProperty";
        try (Transaction transaction = database.beginTx();){
            node = transaction.createNode();
            node.addLabel(testLabel);
            transaction.commit();
        }
        transaction = database.beginTx();
        try {
            node = DatabaseRecoveryIT.findNodeByLabel(transaction, testLabel);
            node.setProperty("propertyToDelete", (Object)DatabaseRecoveryIT.createLongString());
            node.setProperty("validProperty", (Object)DatabaseRecoveryIT.createLongString());
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = database.beginTx();
        try {
            node = DatabaseRecoveryIT.findNodeByLabel(transaction, testLabel);
            node.removeProperty("propertyToDelete");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        DatabaseLayout restoreDbLayout = this.copyStore();
        DatabaseManagementService recoveredService = this.getManagementService(restoreDbLayout.getNeo4jLayout().homeDirectory());
        GraphDatabaseService recoveredDatabase = recoveredService.database("neo4j");
        try (Transaction transaction = recoveredDatabase.beginTx();){
            Node node2 = DatabaseRecoveryIT.findNodeByLabel(transaction, testLabel);
            Assertions.assertFalse((boolean)node2.hasProperty("propertyToDelete"));
            Assertions.assertTrue((boolean)node2.hasProperty("validProperty"));
        }
        recoveredService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void recoveryShouldFixPartiallyAppliedSchemaIndexUpdates() {
        Label label = Label.label((String)"Foo");
        String property = "Bar";
        ClassGuardedAdversary adversary = new ClassGuardedAdversary((Adversary)new CountingAdversary(1, true), new Class[]{Command.RelationshipCommand.class});
        adversary.disable();
        File storeDir = this.directory.homeDir();
        DatabaseManagementService managementService = AdversarialPageCacheGraphDatabaseFactory.create((File)storeDir, (FileSystemAbstraction)this.fileSystem, (Adversary)adversary).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try {
            Transaction tx;
            try (Transaction tx2 = db.beginTx();){
                tx2.schema().constraintFor(label).assertPropertyIsUnique(property).create();
                tx2.commit();
            }
            long relationshipId = DatabaseRecoveryIT.createRelationship(db);
            TransactionFailureException txFailure = null;
            try {
                tx = db.beginTx();
                try {
                    Node node = tx.createNode(new Label[]{label});
                    node.setProperty(property, (Object)"B");
                    tx.getRelationshipById(relationshipId).delete();
                    adversary.enable();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }
            catch (TransactionFailureException e) {
                txFailure = e;
            }
            Assertions.assertNotNull((Object)((Object)txFailure));
            adversary.disable();
            DatabaseRecoveryIT.healthOf(db).healed();
            tx = db.beginTx();
            try {
                Assertions.assertNotNull((Object)DatabaseRecoveryIT.findNode(label, property, "B", tx));
                Assertions.assertNotNull((Object)tx.getRelationshipById(relationshipId));
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            DatabaseRecoveryIT.healthOf(db).panic(txFailure.getCause());
            managementService.shutdown();
            db = this.startDatabase(storeDir);
            tx = db.beginTx();
            try {
                Assertions.assertNotNull((Object)DatabaseRecoveryIT.findNode(label, property, "B", tx));
                DatabaseRecoveryIT.assertRelationshipNotExist(tx, relationshipId);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void shouldSeeSameIndexUpdatesDuringRecoveryAsFromNormalIndexApplication() throws Exception {
        File storeDir = this.directory.absolutePath();
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        UpdateCapturingIndexProvider updateCapturingIndexProvider = new UpdateCapturingIndexProvider(IndexProvider.EMPTY, new HashMap());
        GraphDatabaseAPI db = this.startDatabase(storeDir, fs, updateCapturingIndexProvider);
        Label label = TestLabels.LABEL_ONE;
        String key1 = "key1";
        String key2 = "key2";
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(label).on(key1).create();
            tx.schema().indexFor(label).on(key1).on(key2).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        DatabaseRecoveryIT.checkPoint((GraphDatabaseService)db);
        this.produceRandomNodePropertyAndLabelUpdates((GraphDatabaseService)db, this.random.intBetween(20, 40), label, key1, key2);
        DatabaseRecoveryIT.checkPoint((GraphDatabaseService)db);
        Map<Long, Collection<IndexEntryUpdate<?>>> updatesAtLastCheckPoint = updateCapturingIndexProvider.snapshot();
        this.produceRandomNodePropertyAndLabelUpdates((GraphDatabaseService)db, this.random.intBetween(40, 100), label, key1, key2);
        DatabaseRecoveryIT.flush((GraphDatabaseService)db);
        EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        Map<Long, Collection<IndexEntryUpdate<?>>> updatesAtCrash = updateCapturingIndexProvider.snapshot();
        UpdateCapturingIndexProvider recoveredUpdateCapturingIndexProvider = new UpdateCapturingIndexProvider(IndexProvider.EMPTY, updatesAtLastCheckPoint);
        long lastCommittedTxIdBeforeRecovered = DatabaseRecoveryIT.lastCommittedTxId((GraphDatabaseService)db);
        this.managementService.shutdown();
        fs.close();
        db = this.startDatabase(storeDir, crashedFs, recoveredUpdateCapturingIndexProvider);
        long lastCommittedTxIdAfterRecovered = DatabaseRecoveryIT.lastCommittedTxId((GraphDatabaseService)db);
        Map<Long, Collection<IndexEntryUpdate<?>>> updatesAfterRecovery = recoveredUpdateCapturingIndexProvider.snapshot();
        Assertions.assertEquals((long)lastCommittedTxIdBeforeRecovered, (long)lastCommittedTxIdAfterRecovered);
        DatabaseRecoveryIT.assertSameUpdates(updatesAtCrash, updatesAfterRecovery);
        this.managementService.shutdown();
        crashedFs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSeeTheSameRecordsAtCheckpointAsAfterReverseRecovery() throws Exception {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        this.managementService = new TestDatabaseManagementServiceBuilder(this.directory.homeDir()).setFileSystem((FileSystemAbstraction)fs).impermanent().build();
        GraphDatabaseService db = this.managementService.database("neo4j");
        this.produceRandomGraphUpdates(db, 100);
        DatabaseRecoveryIT.checkPoint(db);
        EphemeralFileSystemAbstraction checkPointFs = fs.snapshot();
        this.produceRandomGraphUpdates(db, 100);
        DatabaseRecoveryIT.flush(db);
        final EphemeralFileSystemAbstraction crashedFs = fs.snapshot();
        this.managementService.shutdown();
        fs.close();
        Dependencies dependencies = new Dependencies();
        final PageCache pageCache = pageCacheExtension.getPageCache((FileSystemAbstraction)crashedFs);
        dependencies.satisfyDependencies(new Object[]{pageCache});
        Monitors monitors = new Monitors();
        final AtomicReference reversedFs = new AtomicReference();
        monitors.addMonitorListener((Object)new RecoveryMonitor(){

            public void reverseStoreRecoveryCompleted(long checkpointTxId) {
                try {
                    pageCache.flushAndForce();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                reversedFs.set(crashedFs.snapshot());
            }
        }, new String[0]);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.directory.homeDir()).setFileSystem((FileSystemAbstraction)crashedFs).setExternalDependencies((DependencyResolver)dependencies).setMonitors(monitors).impermanent().build();
        managementService.shutdown();
        fs.close();
        try {
            DatabaseRecoveryIT.assertSameStoreContents(checkPointFs, (EphemeralFileSystemAbstraction)reversedFs.get(), this.databaseLayout);
        }
        catch (Throwable throwable) {
            IOUtils.closeAll((AutoCloseable[])new EphemeralFileSystemAbstraction[]{checkPointFs, (EphemeralFileSystemAbstraction)reversedFs.get()});
            throw throwable;
        }
        IOUtils.closeAll((AutoCloseable[])new EphemeralFileSystemAbstraction[]{checkPointFs, (EphemeralFileSystemAbstraction)reversedFs.get()});
    }

    private static long lastCommittedTxId(GraphDatabaseService db) {
        return ((TransactionIdStore)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
    }

    private static void assertSameStoreContents(EphemeralFileSystemAbstraction fs1, EphemeralFileSystemAbstraction fs2, DatabaseLayout databaseLayout) {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        VersionContextSupplier contextSupplier = EmptyVersionContextSupplier.EMPTY;
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             PageCache pageCache1 = new ConfiguringPageCacheFactory((FileSystemAbstraction)fs1, Config.defaults(), PageCacheTracer.NULL, (Log)NullLog.getInstance(), contextSupplier, (JobScheduler)jobScheduler, Clocks.nanoClock(), new MemoryPools()).getOrCreatePageCache();
             PageCache pageCache2 = new ConfiguringPageCacheFactory((FileSystemAbstraction)fs2, Config.defaults(), PageCacheTracer.NULL, (Log)NullLog.getInstance(), contextSupplier, (JobScheduler)jobScheduler, Clocks.nanoClock(), new MemoryPools()).getOrCreatePageCache();
             NeoStores store1 = new StoreFactory(databaseLayout, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs1, RecoveryCleanupWorkCollector.immediate()), pageCache1, (FileSystemAbstraction)fs1, (LogProvider)logProvider, PageCacheTracer.NULL).openAllNeoStores();
             NeoStores store2 = new StoreFactory(databaseLayout, Config.defaults(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs2, RecoveryCleanupWorkCollector.immediate()), pageCache2, (FileSystemAbstraction)fs2, (LogProvider)logProvider, PageCacheTracer.NULL).openAllNeoStores();){
            for (StoreType storeType : StoreType.values()) {
                if (storeType == StoreType.META_DATA) continue;
                DatabaseRecoveryIT.assertSameStoreContents(store1.getRecordStore(storeType), store2.getRecordStore(storeType));
            }
        }
    }

    private static <RECORD extends AbstractBaseRecord> void assertSameStoreContents(RecordStore<RECORD> store1, RecordStore<RECORD> store2) {
        long highId1 = store1.getHighId();
        long highId2 = store2.getHighId();
        long maxHighId = Long.max(highId1, highId2);
        AbstractBaseRecord record1 = store1.newRecord();
        AbstractBaseRecord record2 = store2.newRecord();
        for (long id = (long)store1.getNumberOfReservedLowIds(); id < maxHighId; ++id) {
            boolean deletedAndDynamicPropertyRecord;
            store1.getRecord(id, record1, RecordLoad.CHECK, PageCursorTracer.NULL);
            store2.getRecord(id, record2, RecordLoad.CHECK, PageCursorTracer.NULL);
            boolean bl = deletedAndDynamicPropertyRecord = !record1.inUse() && store1 instanceof AbstractDynamicStore;
            if (deletedAndDynamicPropertyRecord) continue;
            Assertions.assertEquals((Object)record1, (Object)record2);
        }
    }

    private static void flush(GraphDatabaseService db) throws IOException {
        CheckPointerImpl.ForceOperation forceOperation = (CheckPointerImpl.ForceOperation)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointerImpl.ForceOperation.class);
        forceOperation.flushAndForce(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
    }

    private static void checkPoint(GraphDatabaseService db) throws IOException {
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Manual trigger"));
    }

    private void produceRandomGraphUpdates(GraphDatabaseService db, int numberOfTransactions) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (Transaction tx = db.beginTx();){
            try (ResourceIterator allNodes = tx.getAllNodes().iterator();){
                while (allNodes.hasNext()) {
                    nodes.add((Node)allNodes.next());
                }
            }
            tx.commit();
        }
        for (int i = 0; i < numberOfTransactions; ++i) {
            int transactionSize = this.random.intBetween(1, 30);
            try (Transaction tx = db.beginTx();){
                for (int j = 0; j < transactionSize; ++j) {
                    float operationType = this.random.nextFloat();
                    float operation = this.random.nextFloat();
                    if ((double)operationType < 0.5) {
                        if ((double)operation < 0.5) {
                            Label[] labelArray;
                            if (this.random.nextBoolean()) {
                                Label[] labelArray2 = new Label[1];
                                labelArray = labelArray2;
                                labelArray2[0] = this.randomLabel();
                            } else {
                                labelArray = new Label[]{};
                            }
                            Node node2 = tx.createNode(labelArray);
                            if (!this.random.nextBoolean()) continue;
                            node2.setProperty(this.randomKey(), this.random.nextValueAsObject());
                            continue;
                        }
                        if (nodes.isEmpty()) continue;
                        Relationship relationship2 = tx.getNodeById(((Node)this.random.among(nodes)).getId()).createRelationshipTo(tx.getNodeById(((Node)this.random.among(nodes)).getId()), this.randomRelationshipType());
                        if (!this.random.nextBoolean()) continue;
                        relationship2.setProperty(this.randomKey(), this.random.nextValueAsObject());
                        continue;
                    }
                    if ((double)operationType < 0.8) {
                        if ((double)operation < 0.25) {
                            this.random.among(nodes, node -> tx.getNodeById(node.getId()).addLabel(this.randomLabel()));
                            continue;
                        }
                        if ((double)operation < 0.5) {
                            this.random.among(nodes, node -> tx.getNodeById(node.getId()).removeLabel(this.randomLabel()));
                            continue;
                        }
                        if ((double)operation < 0.75) {
                            this.random.among(nodes, node -> tx.getNodeById(node.getId()).setProperty(this.randomKey(), this.random.nextValueAsObject()));
                            continue;
                        }
                        this.onRandomRelationship(nodes, relationship -> tx.getRelationshipById(relationship.getId()).setProperty(this.randomKey(), this.random.nextValueAsObject()), tx);
                        continue;
                    }
                    if ((double)operation < 0.25) {
                        this.random.among(nodes, node -> tx.getNodeById(node.getId()).removeProperty(this.randomKey()));
                        continue;
                    }
                    if ((double)operation < 0.5) {
                        this.onRandomRelationship(nodes, relationship -> relationship.removeProperty(this.randomKey()), tx);
                        continue;
                    }
                    if ((double)operation < 0.9) {
                        this.onRandomRelationship(nodes, Relationship::delete, tx);
                        continue;
                    }
                    this.random.among(nodes, node -> {
                        node = tx.getNodeById(node.getId());
                        for (Relationship relationship : node.getRelationships()) {
                            relationship.delete();
                        }
                        node.delete();
                        nodes.remove(node);
                    });
                }
                tx.commit();
                continue;
            }
        }
    }

    private void onRandomRelationship(List<Node> nodes, Consumer<Relationship> action, Transaction transaction) {
        this.random.among(nodes, node -> this.random.among(Iterables.asList((Iterable)transaction.getNodeById(node.getId()).getRelationships()), action));
    }

    private RelationshipType randomRelationshipType() {
        return RelationshipType.withName((String)((String)this.random.among((Object[])TOKENS)));
    }

    private String randomKey() {
        return (String)this.random.among((Object[])TOKENS);
    }

    private Label randomLabel() {
        return Label.label((String)((String)this.random.among((Object[])TOKENS)));
    }

    private static void assertSameUpdates(Map<Long, Collection<IndexEntryUpdate<?>>> updatesAtCrash, Map<Long, Collection<IndexEntryUpdate<?>>> recoveredUpdatesSnapshot) {
        Map<Long, Map<Long, Collection<IndexEntryUpdate<?>>>> crashUpdatesPerNode = DatabaseRecoveryIT.splitPerNode(updatesAtCrash);
        Map<Long, Map<Long, Collection<IndexEntryUpdate<?>>>> recoveredUpdatesPerNode = DatabaseRecoveryIT.splitPerNode(recoveredUpdatesSnapshot);
        Assertions.assertEquals(crashUpdatesPerNode, recoveredUpdatesPerNode);
    }

    private static Map<Long, Map<Long, Collection<IndexEntryUpdate<?>>>> splitPerNode(Map<Long, Collection<IndexEntryUpdate<?>>> updates) {
        HashMap result = new HashMap();
        updates.forEach((indexId, indexUpdates) -> result.put((Long)indexId, DatabaseRecoveryIT.splitPerNode(indexUpdates)));
        return result;
    }

    private static Map<Long, Collection<IndexEntryUpdate<?>>> splitPerNode(Collection<IndexEntryUpdate<?>> updates) {
        HashMap perNode = new HashMap();
        updates.forEach(update -> perNode.computeIfAbsent(update.getEntityId(), nodeId -> new ArrayList()).add(update));
        return perNode;
    }

    private void produceRandomNodePropertyAndLabelUpdates(GraphDatabaseService db, int numberOfTransactions, Label label, String ... keys) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (Transaction tx = db.beginTx();){
            try (ResourceIterator allNodes = tx.getAllNodes().iterator();){
                while (allNodes.hasNext()) {
                    nodes.add((Node)allNodes.next());
                }
            }
            tx.commit();
        }
        for (int i = 0; i < numberOfTransactions; ++i) {
            int transactionSize = this.random.intBetween(1, 30);
            try (Transaction tx = db.beginTx();){
                for (int j = 0; j < transactionSize; ++j) {
                    float operation = this.random.nextFloat();
                    if ((double)operation < 0.1) {
                        if (nodes.isEmpty()) continue;
                        tx.getNodeById(((Node)nodes.remove(this.random.nextInt(nodes.size()))).getId()).delete();
                        continue;
                    }
                    if ((double)operation < 0.3) {
                        Label[] labelArray;
                        if (this.random.nextBoolean()) {
                            Label[] labelArray2 = new Label[1];
                            labelArray = labelArray2;
                            labelArray2[0] = label;
                        } else {
                            labelArray = new Label[]{};
                        }
                        Node node2 = tx.createNode(labelArray);
                        for (String key : keys) {
                            if (!this.random.nextBoolean()) continue;
                            node2.setProperty(key, this.random.nextValueAsObject());
                        }
                        nodes.add(node2);
                        continue;
                    }
                    if ((double)operation < 0.4) {
                        this.random.among(nodes, node -> tx.getNodeById(node.getId()).removeLabel(label));
                        continue;
                    }
                    if ((double)operation < 0.6) {
                        this.random.among(nodes, node -> tx.getNodeById(node.getId()).addLabel(label));
                        continue;
                    }
                    if ((double)operation < 0.85) {
                        this.random.among(nodes, node -> tx.getNodeById(node.getId()).setProperty((String)this.random.among((Object[])keys), this.random.nextValueAsObject()));
                        continue;
                    }
                    this.random.among(nodes, node -> tx.getNodeById(node.getId()).removeProperty((String)this.random.among((Object[])keys)));
                }
                tx.commit();
                continue;
            }
        }
    }

    private static Node findNodeByLabel(Transaction transaction, Label testLabel) {
        try (ResourceIterator nodes = transaction.findNodes(testLabel);){
            Node node = (Node)nodes.next();
            return node;
        }
    }

    private static Node findNode(Label label, String property, String value, Transaction transaction) {
        try (ResourceIterator nodes = transaction.findNodes(label, property, (Object)value);){
            Node node = (Node)Iterators.single((Iterator)nodes);
            return node;
        }
    }

    private static long createRelationship(GraphDatabaseService db) {
        long relationshipId;
        try (Transaction tx = db.beginTx();){
            Node start = tx.createNode(new Label[]{Label.label((String)("" + System.currentTimeMillis()))});
            Node end = tx.createNode(new Label[]{Label.label((String)("" + System.currentTimeMillis()))});
            relationshipId = start.createRelationshipTo(end, RelationshipType.withName((String)"KNOWS")).getId();
            tx.commit();
        }
        return relationshipId;
    }

    private static void assertRelationshipNotExist(Transaction tx, long id) {
        Assertions.assertThrows(NotFoundException.class, () -> tx.getRelationshipById(id));
    }

    private static Health healthOf(GraphDatabaseService db) {
        DependencyResolver resolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        return (Health)resolver.resolveDependency(DatabaseHealth.class);
    }

    private static String createLongString() {
        Object[] strings = new String[(int)ByteUnit.kibiBytes((long)2L)];
        Arrays.fill(strings, "a");
        return Arrays.toString(strings);
    }

    private DatabaseLayout copyStore() throws IOException {
        DatabaseLayout restoreDbLayout = Neo4jLayout.of((File)this.directory.homeDir("restore-db")).databaseLayout("neo4j");
        this.fileSystem.mkdirs(restoreDbLayout.databaseDirectory());
        this.fileSystem.mkdirs(restoreDbLayout.getTransactionLogsDirectory());
        DatabaseRecoveryIT.copy((FileSystemAbstraction)this.fileSystem, this.databaseLayout.getTransactionLogsDirectory(), restoreDbLayout.getTransactionLogsDirectory());
        DatabaseRecoveryIT.copy((FileSystemAbstraction)this.fileSystem, this.databaseLayout.databaseDirectory(), restoreDbLayout.databaseDirectory());
        return restoreDbLayout;
    }

    private static void copy(FileSystemAbstraction fs, File fromDirectory, File toDirectory) throws IOException {
        Assertions.assertTrue((boolean)fs.isDirectory(fromDirectory));
        Assertions.assertTrue((boolean)fs.isDirectory(toDirectory));
        fs.copyRecursively(fromDirectory, toDirectory);
    }

    private GraphDatabaseAPI startDatabase(File homeDir, EphemeralFileSystemAbstraction fs, UpdateCapturingIndexProvider indexProvider) {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.managementService = new TestDatabaseManagementServiceBuilder(homeDir).setFileSystem((FileSystemAbstraction)fs).setExtensions(Collections.singletonList(new IndexExtensionFactory((IndexProvider)indexProvider))).impermanent().noOpSystemGraphInitializer().setConfig(GraphDatabaseSettings.default_schema_provider, (Object)indexProvider.getProviderDescriptor().name()).build();
        return (GraphDatabaseAPI)this.managementService.database("neo4j");
    }

    private GraphDatabaseService startDatabase(File homeDir) {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
        this.managementService = this.getManagementService(homeDir);
        return this.managementService.database("neo4j");
    }

    private DatabaseManagementService getManagementService(File homeDir) {
        return new TestDatabaseManagementServiceBuilder(homeDir).setInternalLogProvider((LogProvider)this.logProvider).build();
    }

    @RecoveryExtension
    private static class IndexExtensionFactory
    extends ExtensionFactory<Dependencies> {
        private final IndexProvider indexProvider;

        IndexExtensionFactory(IndexProvider indexProvider) {
            super(ExtensionType.DATABASE, "customExtension");
            this.indexProvider = indexProvider;
        }

        public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
            return this.indexProvider;
        }

        static interface Dependencies {
        }
    }

    public static class UpdateCapturingIndexUpdater
    extends DelegatingIndexUpdater {
        private final Collection<IndexEntryUpdate<?>> updatesTarget;

        UpdateCapturingIndexUpdater(IndexUpdater actual, Collection<IndexEntryUpdate<?>> updatesTarget) {
            super(actual);
            this.updatesTarget = updatesTarget;
        }

        public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
            super.process(update);
            this.updatesTarget.add(update);
        }
    }

    public class UpdateCapturingIndexAccessor
    extends IndexAccessor.Delegating {
        private final Collection<IndexEntryUpdate<?>> updates;

        UpdateCapturingIndexAccessor(IndexAccessor actual, Collection<IndexEntryUpdate<?>> initialUpdates) {
            super(actual);
            this.updates = new ArrayList();
            if (initialUpdates != null) {
                this.updates.addAll(initialUpdates);
            }
        }

        public IndexUpdater newUpdater(IndexUpdateMode mode, PageCursorTracer cursorTracer) {
            return this.wrap(super.newUpdater(mode, cursorTracer));
        }

        private IndexUpdater wrap(IndexUpdater actual) {
            return new UpdateCapturingIndexUpdater(actual, this.updates);
        }

        public Collection<IndexEntryUpdate<?>> snapshot() {
            return new ArrayList(this.updates);
        }
    }

    public class UpdateCapturingIndexProvider
    extends IndexProvider.Delegating {
        private final Map<Long, UpdateCapturingIndexAccessor> indexes;
        private final Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates;

        UpdateCapturingIndexProvider(IndexProvider actual, Map<Long, Collection<IndexEntryUpdate<?>>> initialUpdates) {
            super(actual);
            this.indexes = new ConcurrentHashMap<Long, UpdateCapturingIndexAccessor>();
            this.initialUpdates = initialUpdates;
        }

        public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
            IndexAccessor actualAccessor = super.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);
            return (IndexAccessor)this.indexes.computeIfAbsent(descriptor.getId(), id -> new UpdateCapturingIndexAccessor(actualAccessor, this.initialUpdates.get(id)));
        }

        public Map<Long, Collection<IndexEntryUpdate<?>>> snapshot() {
            HashMap result = new HashMap();
            this.indexes.forEach((indexId, index) -> result.put((Long)indexId, index.snapshot()));
            return result;
        }
    }
}

