/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ResourceLock(value="sharedContext")
public abstract class KernelAPIWriteTestBase<WriteSupport extends KernelAPIWriteTestSupport> {
    protected static KernelAPIWriteTestSupport testSupport;
    protected static GraphDatabaseService graphDb;
    @Inject
    private TestDirectory testDirectory;

    public abstract WriteSupport newTestSupport();

    @BeforeEach
    public void setupGraph() {
        if (testSupport == null) {
            testSupport = this.newTestSupport();
            testSupport.setup(this.testDirectory.homeDir(), this::createSystemGraph);
            graphDb = testSupport.graphBackdoor();
        }
        testSupport.clearGraph();
    }

    public void createSystemGraph(GraphDatabaseService graphDb) {
    }

    protected KernelTransaction beginTransaction() throws TransactionFailureException {
        return this.beginTransaction(LoginContext.AUTH_DISABLED);
    }

    protected KernelTransaction beginTransaction(LoginContext loginContext) throws TransactionFailureException {
        Kernel kernel = testSupport.kernelToTest();
        return kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, loginContext);
    }

    @AfterAll
    public static void tearDown() {
        if (testSupport != null) {
            testSupport.tearDown();
            testSupport = null;
        }
    }
}

