/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.storemigration.StoreScanChunk;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class StoreScanChunkIT {
    @Inject
    private TestDirectory testDirectory;

    StoreScanChunkIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void differentChunksHaveDifferentCursors() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            RecordStorageEngine recordStorageEngine = (RecordStorageEngine)database.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = recordStorageEngine.testAccessNeoStores();
            RecordStorageReader storageReader = new RecordStorageReader(neoStores);
            TestStoreScanChunk scanChunk1 = new TestStoreScanChunk(storageReader, false);
            TestStoreScanChunk scanChunk2 = new TestStoreScanChunk(storageReader, false);
            Assertions.assertNotSame((Object)scanChunk1.getCursor(), (Object)scanChunk2.getCursor());
            Assertions.assertNotSame((Object)scanChunk1.getStorePropertyCursor(), (Object)scanChunk2.getStorePropertyCursor());
        }
        finally {
            managementService.shutdown();
        }
    }

    private static class TestStoreScanChunk
    extends StoreScanChunk<StorageNodeCursor> {
        TestStoreScanChunk(RecordStorageReader storageReader, boolean requiresPropertyMigration) {
            super((StorageEntityCursor)storageReader.allocateNodeCursor(PageCursorTracer.NULL), storageReader, requiresPropertyMigration, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        protected void read(StorageNodeCursor cursor, long id) {
            cursor.single(id);
        }

        void visitRecord(StorageNodeCursor record, InputEntityVisitor visitor) {
        }

        StorageNodeCursor getCursor() {
            return (StorageNodeCursor)this.cursor;
        }

        StoragePropertyCursor getStorePropertyCursor() {
            return this.storePropertyCursor;
        }
    }
}

