/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChecksumChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.TransactionMetaDataStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class})
class RecoveryCorruptedTransactionLogIT {
    @Inject
    private DefaultFileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private RandomRule random;
    private static final int HEADER_OFFSET = 64;
    private static final byte CHECKPOINT_COMMAND_SIZE = 22;
    private final AssertableLogProvider logProvider = new AssertableLogProvider(true);
    private final RecoveryMonitor recoveryMonitor = new RecoveryMonitor();
    private File databaseDirectory;
    private final Monitors monitors = new Monitors();
    private LogFiles logFiles;
    private TestDatabaseManagementServiceBuilder databaseFactory;
    private StorageEngineFactory storageEngineFactory;

    RecoveryCorruptedTransactionLogIT() {
    }

    @BeforeEach
    void setUp() {
        this.databaseDirectory = this.databaseLayout.databaseDirectory();
        this.monitors.addMonitorListener((Object)this.recoveryMonitor, new String[0]);
        this.databaseFactory = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setInternalLogProvider((LogProvider)this.logProvider).setMonitors(this.monitors).setFileSystem((FileSystemAbstraction)this.fileSystem);
        this.startStopDatabase();
    }

    @Test
    void evenTruncateNewerTransactionLogFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfClosedTransactions = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database).getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomBytes);
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void doNotTruncateNewerTransactionLogFileWhenFailOnError() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        managementService1.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addRandomBytesToLastLogFile(this::randomInvalidVersionsBytes);
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(UnsupportedLogVersionException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void truncateNewerTransactionLogFileWhenForced() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long numberOfClosedTransactions = transactionIdStore.getLastClosedTransactionId() - 1L;
        managementService.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        Supplier<Byte> randomBytesSupplier = this::randomBytes;
        BytesCaptureSupplier capturingSupplier = new BytesCaptureSupplier(randomBytesSupplier);
        this.addRandomBytesToLastLogFile(capturingSupplier);
        Assertions.assertFalse((boolean)this.recoveryMonitor.wasRecoveryRequired());
        this.startStopDbRecoveryOfCorruptedLogs();
        try {
            Assertions.assertEquals((long)numberOfClosedTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
            Assertions.assertTrue((boolean)this.recoveryMonitor.wasRecoveryRequired());
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read transaction log version 0. Last valid transaction start offset is: 5634."});
        }
        catch (Throwable t) {
            throw new RuntimeException("Generated random bytes: " + capturingSupplier.getCapturedBytes(), t);
        }
    }

    @Test
    void recoverFirstCorruptedTransactionSingleFileNoCheckpoint() throws IOException {
        this.addCorruptedCommandsToLastLogFile();
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Fail to read first transaction of log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=64}", "Fail to recover all transactions. Any later transactions after position LogPosition{logVersion=0, byteOffset=64} are unreadable and will be truncated."});
        this.logFiles = this.buildDefaultLogFiles(StoreId.UNKNOWN);
        Assertions.assertEquals((long)0L, (long)this.logFiles.getHighestLogVersion());
        ObjectLongMap<Class<?>> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assertions.assertEquals((int)1, (int)logEntriesDistribution.size());
        Assertions.assertEquals((long)2L, (long)logEntriesDistribution.get(CheckPoint.class));
    }

    @Test
    void failToStartWithTransactionLogsWithDataAfterLastEntry() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has some data available after last readable log entry. Last readable position 1104");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startWithTransactionLogsWithDataAfterLastEntryAndCorruptedLogsRecoveryEnabled() throws IOException {
        long initialTransactionOffset = 1082L;
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        Assertions.assertEquals((long)initialTransactionOffset, (long)this.getLastClosedTransactionOffset(database));
        managementService.shutdown();
        this.writeRandomBytesAfterLastCommandInLastLogFile(() -> ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5}));
        managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        try {
            LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=1082}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has some data available after last readable log entry. Last readable position 1104");
            GraphDatabaseAPI restartedDb = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertEquals((long)(initialTransactionOffset + 22L), (long)this.getLastClosedTransactionOffset(restartedDb));
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void failToStartWithNotLastTransactionLogHavingZerosInTheEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            File originalFile = this.logFiles.getHighestLogFile();
            this.logFiles.getLogFile().rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessageContaining("Transaction log files with version 0 has 50 unreadable bytes");
    }

    @Test
    void startWithNotLastTransactionLogHavingZerosInTheEndAndCorruptedLogRecoveryEnabled() throws IOException {
        long originalLogDataLength;
        File firstLogFile;
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            LogFile logFile = this.logFiles.getLogFile();
            LogPosition readablePosition = this.getLastReadablePosition(logFile);
            firstLogFile = this.logFiles.getHighestLogFile();
            originalLogDataLength = readablePosition.getByteOffset();
            logFile.rotate();
            try (StoreFileChannel writeChannel = this.fileSystem.write(firstLogFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        Assertions.assertEquals((long)(originalLogDataLength + 44L), (long)this.fileSystem.getFileSize(firstLogFile));
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Recovery required from position LogPosition{logVersion=0, byteOffset=1082}"}).assertExceptionForLogMessage("Fail to read transaction log version 0.").hasMessage("Transaction log files with version 0 has 50 unreadable bytes. Was able to read upto 1104 but 1154 is available.");
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEnd() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            File originalFile = this.logFiles.getHighestLogFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDatabase();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    @Test
    void startWithoutProblemsIfRotationForcedBeforeFileEndAndCorruptedLogFilesRecoveryEnabled() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        managementService.shutdown();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{this.logFiles});){
            File originalFile = this.logFiles.getHighestLogFile();
            try (StoreFileChannel writeChannel = this.fileSystem.write(originalFile);){
                writeChannel.position(writeChannel.size());
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0}));
                }
            }
            this.logFiles.getLogFile().rotate();
        }
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).doesNotContainMessage("Fail to read transaction log version 0.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void failToRecoverFirstCorruptedTransactionSingleFileNoCheckpointIfFailOnCorruption() throws IOException {
        this.addCorruptedCommandsToLastLogFile();
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(db.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(db.databaseId()).get())).hasRootCauseInstanceOf(NegativeArraySizeException.class);
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void recoverNotAFirstCorruptedTransactionSingleFileNoCheckpoint() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        for (int i = 0; i < 10; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = this.fileSystem.getFileSize(highestLogFile);
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 0.", "Recovery required from position LogPosition{logVersion=0, byteOffset=64}", "Fail to recover all transactions.", "Any later transaction after LogPosition{logVersion=0, byteOffset=6203} are unreadable and will be truncated."});
        Assertions.assertEquals((long)0L, (long)this.logFiles.getHighestLogVersion());
        ObjectLongMap<Class<?>> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assertions.assertEquals((long)3L, (long)logEntriesDistribution.get(CheckPoint.class));
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)(originalFileLength + 22L), (long)highestLogFile.length());
    }

    @Test
    void recoverNotAFirstCorruptedTransactionMultipleFilesNoCheckpoints() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        TransactionIdStore transactionIdStore = RecoveryCorruptedTransactionLogIT.getTransactionIdStore(database);
        long lastClosedTransactionBeforeStart = transactionIdStore.getLastClosedTransactionId();
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 3);
        for (int i = 0; i < 7; ++i) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
        }
        long numberOfTransactions = transactionIdStore.getLastClosedTransactionId() - lastClosedTransactionBeforeStart;
        managementService.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=0, byteOffset=64}", "Fail to recover all transactions.", "Any later transaction after LogPosition{logVersion=3, byteOffset=4616} are unreadable and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getHighestLogVersion());
        ObjectLongMap<Class<?>> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assertions.assertEquals((long)3L, (long)logEntriesDistribution.get(CheckPoint.class));
        Assertions.assertEquals((long)numberOfTransactions, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)(originalFileLength + 22L), (long)highestLogFile.length());
    }

    @Test
    void recoverNotAFirstCorruptedTransactionMultipleFilesMultipleCheckpoints() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        long transactionsToRecover = 7L;
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotateWithCheckpoint(database, 3);
        int i = 0;
        while ((long)i < transactionsToRecover) {
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            ++i;
        }
        managementService.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.removeLastCheckpointRecordFromLastLogFile();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 3.", "Recovery required from position LogPosition{logVersion=3, byteOffset=633}", "Fail to recover all transactions.", "Any later transaction after LogPosition{logVersion=3, byteOffset=4638} are unreadable and will be truncated."});
        Assertions.assertEquals((long)3L, (long)this.logFiles.getHighestLogVersion());
        ObjectLongMap<Class<?>> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assertions.assertEquals((long)6L, (long)logEntriesDistribution.get(CheckPoint.class));
        Assertions.assertEquals((long)transactionsToRecover, (long)this.recoveryMonitor.getNumberOfRecoveredTransactions());
        Assertions.assertEquals((long)(originalFileLength + 22L), (long)highestLogFile.length());
    }

    @Test
    void recoverFirstCorruptedTransactionAfterCheckpointInLastLogFile() throws IOException {
        DatabaseManagementService managementService = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 5);
        managementService.shutdown();
        File highestLogFile = this.logFiles.getHighestLogFile();
        long originalFileLength = this.getLastReadablePosition(highestLogFile).getByteOffset();
        this.addCorruptedCommandsToLastLogFile();
        long modifiedFileLength = highestLogFile.length();
        LogAssertions.assertThat((long)modifiedFileLength).isGreaterThan(originalFileLength);
        this.startStopDbRecoveryOfCorruptedLogs();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Fail to read transaction log version 5.", "Fail to read first transaction of log version 5.", "Recovery required from position LogPosition{logVersion=5, byteOffset=633}", "Fail to recover all transactions. Any later transactions after position LogPosition{logVersion=5, byteOffset=633} are unreadable and will be truncated."});
        Assertions.assertEquals((long)5L, (long)this.logFiles.getHighestLogVersion());
        ObjectLongMap<Class<?>> logEntriesDistribution = this.getLogEntriesDistribution(this.logFiles);
        Assertions.assertEquals((long)3L, (long)logEntriesDistribution.get(CheckPoint.class));
        Assertions.assertEquals((long)(originalFileLength + 22L), (long)highestLogFile.length());
    }

    @Test
    void repetitiveRecoveryOfCorruptedLogs() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 4, false);
        managementService1.shutdown();
        this.removeLastCheckpointRecordFromLastLogFile();
        for (int expectedRecoveredTransactions = 7; expectedRecoveredTransactions > 0; --expectedRecoveredTransactions) {
            this.truncateBytesFromLastLogFile(1 + this.random.nextInt(10));
            this.startStopDbRecoveryOfCorruptedLogs();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            Assertions.assertEquals((int)expectedRecoveredTransactions, (int)numberOfRecoveredTransactions);
            this.removeLastCheckpointRecordFromLastLogFile();
        }
    }

    @Test
    void repetitiveRecoveryIfCorruptedLogsWithCheckpoints() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 4, true);
        managementService1.shutdown();
        while (this.logFiles.getHighestLogVersion() > 0L) {
            int bytesToTrim = 23 + this.random.nextInt(100);
            this.truncateBytesFromLastLogFile(bytesToTrim);
            DatabaseManagementService managementService = this.databaseFactory.build();
            managementService.shutdown();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            LogAssertions.assertThat((int)numberOfRecoveredTransactions).isGreaterThanOrEqualTo(0);
        }
        File corruptedLogArchives = new File(this.databaseDirectory, "corrupted-neostore.transaction.db");
        LogAssertions.assertThat((Object[])corruptedLogArchives.listFiles()).isNotEmpty();
    }

    @Test
    void repetitiveRecoveryIfCorruptedLogsSmallTailsWithCheckpoints() throws IOException {
        DatabaseManagementService managementService1 = this.databaseFactory.setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.mebiBytes((long)1L)).build();
        GraphDatabaseAPI database = (GraphDatabaseAPI)managementService1.database("neo4j");
        this.logFiles = this.buildDefaultLogFiles(this.getStoreId(database));
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, 4, true);
        managementService1.shutdown();
        byte[] trimSizes = new byte[]{16, 48};
        int trimSize = 0;
        while (this.logFiles.getHighestLogVersion() > 0L) {
            byte bytesToTrim = (byte)(trimSizes[trimSize++ % trimSizes.length] + 22);
            this.truncateBytesFromLastLogFile(bytesToTrim);
            DatabaseManagementService managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
            managementService.shutdown();
            int numberOfRecoveredTransactions = this.recoveryMonitor.getNumberOfRecoveredTransactions();
            LogAssertions.assertThat((int)numberOfRecoveredTransactions).isGreaterThanOrEqualTo(0);
        }
        File corruptedLogArchives = new File(this.databaseDirectory, "corrupted-neostore.transaction.db");
        LogAssertions.assertThat((Object[])corruptedLogArchives.listFiles()).isNotEmpty();
    }

    private StoreId getStoreId(GraphDatabaseAPI database) {
        return ((StoreIdProvider)database.getDependencyResolver().resolveDependency(StoreIdProvider.class)).getStoreId();
    }

    private static TransactionIdStore getTransactionIdStore(GraphDatabaseAPI database) {
        return (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private void removeLastCheckpointRecordFromLastLogFile() throws IOException {
        LogPosition checkpointPosition = null;
        LogFile transactionLogFile = this.logFiles.getLogFile();
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        LogPosition startPosition = this.logFiles.extractHeader(this.logFiles.getHighestLogVersion()).getStartPosition();
        try (ReadableLogChannel reader = transactionLogFile.getReader(startPosition);){
            LogEntry logEntry;
            do {
                if (!((logEntry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader)) instanceof CheckPoint)) continue;
                checkpointPosition = ((CheckPoint)logEntry).getLogPosition();
            } while (logEntry != null);
        }
        if (checkpointPosition != null) {
            try (StoreFileChannel storeChannel = this.fileSystem.write(this.logFiles.getHighestLogFile());){
                storeChannel.truncate(checkpointPosition.getByteOffset());
            }
        }
    }

    private void truncateBytesFromLastLogFile(long bytesToTrim) throws IOException {
        File highestLogFile = this.logFiles.getHighestLogFile();
        long readableOffset = this.getLastReadablePosition(highestLogFile).getByteOffset();
        if (this.fileSystem.getFileSize(highestLogFile) > readableOffset) {
            this.fileSystem.truncate(highestLogFile, readableOffset);
            return;
        }
        if (bytesToTrim > readableOffset) {
            this.fileSystem.deleteFile(highestLogFile);
            if (this.logFiles.logFiles().length > 0) {
                this.truncateBytesFromLastLogFile(bytesToTrim);
            }
        } else {
            this.fileSystem.truncate(highestLogFile, readableOffset - bytesToTrim);
        }
    }

    private void writeRandomBytesAfterLastCommandInLastLogFile(Supplier<ByteBuffer> source) throws IOException {
        int someRandomPaddingAfterEndOfDataInLogFile = this.random.nextInt(1, 10);
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            LogPosition position = this.getLastReadablePosition(transactionLogFile);
            try (StoreFileChannel writeChannel = this.fileSystem.write(this.logFiles.getHighestLogFile());){
                writeChannel.position(position.getByteOffset() + (long)someRandomPaddingAfterEndOfDataInLogFile);
                for (int i = 0; i < 10; ++i) {
                    writeChannel.writeAll(source.get());
                }
            }
        }
    }

    private LogPosition getLastReadablePosition(File logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        long logVersion = this.logFiles.getLogVersion(logFile);
        LogPosition startPosition = this.logFiles.extractHeader(logVersion).getStartPosition();
        try (ReadAheadLogChannel reader = this.openTransactionFileChannel(logVersion, startPosition);){
            while (entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader) != null) {
            }
        }
        catch (IncompleteLogHeaderException e) {
            return new LogPosition(logVersion, 0L);
        }
        return entryReader.lastPosition();
    }

    private ReadAheadLogChannel openTransactionFileChannel(long logVersion, LogPosition startPosition) throws IOException {
        PhysicalLogVersionedStoreChannel storeChannel = this.logFiles.openForVersion(logVersion);
        storeChannel.position(startPosition.getByteOffset());
        return new ReadAheadLogChannel((LogVersionedStoreChannel)storeChannel, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private LogPosition getLastReadablePosition(LogFile logFile) throws IOException {
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        LogPosition startPosition = this.logFiles.extractHeader(this.logFiles.getHighestLogVersion()).getStartPosition();
        try (ReadableLogChannel reader = logFile.getReader(startPosition);){
            while (entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)reader) != null) {
            }
        }
        return entryReader.lastPosition();
    }

    private void addRandomBytesToLastLogFile(Supplier<Byte> byteSource) throws IOException {
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            LogFile transactionLogFile = this.logFiles.getLogFile();
            lifespan.add((Lifecycle)this.logFiles);
            FlushablePositionAwareChecksumChannel logFileWriter = transactionLogFile.getWriter();
            for (int i = 0; i < 10; ++i) {
                logFileWriter.put(byteSource.get().byteValue());
            }
        }
    }

    private byte randomInvalidVersionsBytes() {
        return (byte)this.random.nextInt(LogEntryVersion.LATEST.version() + 1, 127);
    }

    private byte randomBytes() {
        return (byte)this.random.nextInt(-128, 127);
    }

    private void addCorruptedCommandsToLastLogFile() throws IOException {
        PositiveLogFilesBasedLogVersionRepository versionRepository = new PositiveLogFilesBasedLogVersionRepository(this.logFiles);
        LogFiles internalLogFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)versionRepository).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(StoreId.UNKNOWN).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine().commandReaderFactory()).build();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{internalLogFiles});){
            LogFile transactionLogFile = internalLogFiles.getLogFile();
            FlushablePositionAwareChecksumChannel channel = transactionLogFile.getWriter();
            TransactionLogWriter writer = new TransactionLogWriter((LogEntryWriter)new CorruptedLogEntryWriter((FlushableChecksumChannel)channel));
            ArrayList<Object> commands = new ArrayList<Object>();
            commands.add(new Command.PropertyCommand(new PropertyRecord(1L), new PropertyRecord(2L)));
            commands.add(new Command.NodeCommand(new NodeRecord(2L), new NodeRecord(3L)));
            PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
            writer.append((TransactionRepresentation)transaction, 1000L, -559063315);
        }
    }

    private long getLastClosedTransactionOffset(GraphDatabaseAPI database) {
        TransactionMetaDataStore metaDataStore = (TransactionMetaDataStore)database.getDependencyResolver().resolveDependency(TransactionMetaDataStore.class);
        return metaDataStore.getLastClosedTransaction()[2];
    }

    private ObjectLongMap<Class<?>> getLogEntriesDistribution(LogFiles logFiles) throws IOException {
        LogFile transactionLogFile = logFiles.getLogFile();
        LogPosition fileStartPosition = logFiles.extractHeader(0L).getStartPosition();
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(this.storageEngineFactory.commandReaderFactory());
        ObjectLongHashMap multiset = new ObjectLongHashMap();
        try (ReadableLogChannel fileReader = transactionLogFile.getReader(fileStartPosition);){
            LogEntry logEntry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)fileReader);
            while (logEntry != null) {
                multiset.addToValue(logEntry.getClass(), 1L);
                logEntry = entryReader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)fileReader);
            }
        }
        return multiset;
    }

    private LogFiles buildDefaultLogFiles(StoreId storeId) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withStoreId(storeId).withCommandReaderFactory(StorageEngineFactory.selectStorageEngine().commandReaderFactory()).build();
    }

    private static void generateTransactionsAndRotateWithCheckpoint(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, true);
    }

    private static void generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate) throws IOException {
        RecoveryCorruptedTransactionLogIT.generateTransactionsAndRotate(database, logFilesToGenerate, false);
    }

    private static void generateTransactionsAndRotate(GraphDatabaseAPI database, int logFilesToGenerate, boolean checkpoint) throws IOException {
        DependencyResolver resolver = database.getDependencyResolver();
        LogFiles logFiles = (LogFiles)resolver.resolveDependency(LogFiles.class);
        CheckPointer checkpointer = (CheckPointer)resolver.resolveDependency(CheckPointer.class);
        while (logFiles.getHighestLogVersion() < (long)logFilesToGenerate) {
            logFiles.getLogFile().rotate();
            RecoveryCorruptedTransactionLogIT.generateTransaction(database);
            if (!checkpoint) continue;
            checkpointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
        }
    }

    private static void generateTransaction(GraphDatabaseAPI database) {
        try (Transaction transaction = database.beginTx();){
            Node startNode = transaction.createNode(new Label[]{Label.label((String)"startNode")});
            startNode.setProperty("key", (Object)"value");
            Node endNode = transaction.createNode(new Label[]{Label.label((String)"endNode")});
            endNode.setProperty("key", (Object)"value");
            startNode.createRelationshipTo(endNode, RelationshipType.withName((String)"connects"));
            transaction.commit();
        }
    }

    private void startStopDbRecoveryOfCorruptedLogs() {
        DatabaseManagementService managementService = this.databaseFactory.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).build();
        managementService.shutdown();
    }

    private void startStopDatabase() {
        DatabaseManagementService managementService = this.databaseFactory.build();
        this.storageEngineFactory = (StorageEngineFactory)((GraphDatabaseAPI)managementService.database("neo4j")).getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
    }

    private static class BytesCaptureSupplier
    implements Supplier<Byte> {
        private final Supplier<Byte> generator;
        private final List<Byte> capturedBytes = new ArrayList<Byte>();

        BytesCaptureSupplier(Supplier<Byte> generator) {
            this.generator = generator;
        }

        @Override
        public Byte get() {
            Byte data = this.generator.get();
            this.capturedBytes.add(data);
            return data;
        }

        public List<Byte> getCapturedBytes() {
            return this.capturedBytes;
        }
    }

    private static class PositiveLogFilesBasedLogVersionRepository
    implements LogVersionRepository {
        private long version;

        PositiveLogFilesBasedLogVersionRepository(LogFiles logFiles) {
            this.version = logFiles == null ? 0L : logFiles.getHighestLogVersion();
        }

        public long getCurrentLogVersion() {
            return this.version;
        }

        public void setCurrentLogVersion(long version, PageCursorTracer cursorTracer) {
            this.version = version;
        }

        public long incrementAndGetVersion(PageCursorTracer cursorTracer) {
            ++this.version;
            return this.version;
        }
    }

    private static class RecoveryMonitor
    implements org.neo4j.kernel.recovery.RecoveryMonitor {
        private final List<Long> recoveredTransactions = new ArrayList<Long>();
        private int numberOfRecoveredTransactions;
        private final AtomicBoolean recoveryRequired = new AtomicBoolean();

        private RecoveryMonitor() {
        }

        public void recoveryRequired(LogPosition recoveryPosition) {
            this.recoveryRequired.set(true);
        }

        public void transactionRecovered(long txId) {
            this.recoveredTransactions.add(txId);
        }

        public void recoveryCompleted(int numberOfRecoveredTransactions, long recoveryTimeInMilliseconds) {
            this.numberOfRecoveredTransactions = numberOfRecoveredTransactions;
        }

        boolean wasRecoveryRequired() {
            return this.recoveryRequired.get();
        }

        int getNumberOfRecoveredTransactions() {
            return this.numberOfRecoveredTransactions;
        }
    }

    private static class CorruptedLogEntryWriter
    extends LogEntryWriter {
        CorruptedLogEntryWriter(FlushableChecksumChannel channel) {
            super((WritableChecksumChannel)channel);
        }

        public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            CorruptedLogEntryWriter.writeLogEntryHeader((byte)1, (WritableChannel)this.channel);
        }
    }
}

